/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.factory;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.Service;
import org.apache.knox.gateway.services.ServiceFactory;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.KeystoreService;
import org.apache.knox.gateway.services.security.MasterService;

public abstract class AbstractServiceFactory
implements ServiceFactory {
    private static final GatewayMessages LOG = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private static final String IMPLEMENTATION_PARAM_NAME = "impl";
    private static final String EMPTY_DEFAULT_IMPLEMENTATION = "";

    public Service create(GatewayServices gatewayServices, ServiceType serviceType, GatewayConfig gatewayConfig, Map<String, String> options) throws ServiceLifecycleException {
        return this.create(gatewayServices, serviceType, gatewayConfig, options, this.getImplementation(gatewayConfig));
    }

    public Service create(GatewayServices gatewayServices, ServiceType serviceType, GatewayConfig gatewayConfig, Map<String, String> options, String implementation) throws ServiceLifecycleException {
        Service service = null;
        if (this.getServiceType() == serviceType && (service = this.createService(gatewayServices, serviceType, gatewayConfig, options, implementation)) == null && StringUtils.isNotBlank((CharSequence)implementation)) {
            try {
                service = (Service)Class.forName(implementation).newInstance();
                this.logServiceUsage(implementation, serviceType);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new ServiceLifecycleException("Error while instantiating " + serviceType.getShortName() + " service implementation " + implementation, (Exception)e);
            }
        }
        return service;
    }

    protected String getImplementation(GatewayConfig gatewayConfig) {
        return gatewayConfig.getServiceParameter(this.getServiceType().getShortName(), IMPLEMENTATION_PARAM_NAME);
    }

    protected boolean matchesImplementation(String implementation, Class<? extends Object> clazz) {
        return this.matchesImplementation(implementation, clazz, false);
    }

    protected boolean matchesImplementation(String implementation, Class<? extends Object> clazz, boolean acceptEmptyImplementation) {
        boolean match = clazz.getName().equals(implementation);
        if (!match && acceptEmptyImplementation) {
            match = this.isEmptyDefaultImplementation(implementation);
        }
        return match;
    }

    protected boolean isEmptyDefaultImplementation(String implementation) {
        return EMPTY_DEFAULT_IMPLEMENTATION.equals(implementation);
    }

    protected boolean shouldCreateService(String implementation) {
        return implementation == null || this.isEmptyDefaultImplementation(implementation) || this.getKnownImplementations().contains(implementation);
    }

    protected MasterService getMasterService(GatewayServices gatewayServices) {
        return (MasterService)gatewayServices.getService(ServiceType.MASTER_SERVICE);
    }

    protected KeystoreService getKeystoreService(GatewayServices gatewayServices) {
        return (KeystoreService)gatewayServices.getService(ServiceType.KEYSTORE_SERVICE);
    }

    protected AliasService getAliasService(GatewayServices gatewayServices) {
        return (AliasService)gatewayServices.getService(ServiceType.ALIAS_SERVICE);
    }

    protected void logServiceUsage(String implementation, ServiceType serviceType) {
        LOG.usingServiceImplementation(this.isEmptyDefaultImplementation(implementation) ? "default" : implementation, serviceType.getServiceTypeName());
    }

    protected abstract Service createService(GatewayServices var1, ServiceType var2, GatewayConfig var3, Map<String, String> var4, String var5) throws ServiceLifecycleException;

    protected abstract ServiceType getServiceType();

    protected abstract Collection<String> getKnownImplementations();
}

