/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;

public class BasicResponse
implements Closeable {
    private HttpResponse response;
    private boolean consumed;
    private String string;
    private InputStream stream;
    private byte[] bytes;

    public BasicResponse(HttpResponse response) {
        this.response = response;
    }

    public void consume() {
        if (!this.consumed) {
            EntityUtils.consumeQuietly((HttpEntity)this.response.getEntity());
            this.consumed = true;
        }
    }

    @Override
    public void close() {
        this.consume();
    }

    protected HttpResponse response() {
        return this.response;
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    public int getStatusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    public long getContentLength() {
        return this.response.getEntity().getContentLength();
    }

    public String getContentType() {
        return ContentType.getOrDefault((HttpEntity)this.response.getEntity()).getMimeType();
    }

    public String getContentEncoding() {
        return ContentType.getOrDefault((HttpEntity)this.response.getEntity()).getCharset().name();
    }

    public InputStream getStream() throws IOException {
        if (!this.consumed && this.stream == null) {
            this.stream = this.response.getEntity().getContent();
            this.consumed = true;
        }
        return this.stream;
    }

    public String getString() throws IOException {
        if (!this.consumed && this.string == null) {
            this.string = EntityUtils.toString((HttpEntity)this.response.getEntity());
            this.consumed = true;
        }
        return this.string;
    }

    public byte[] getBytes() throws IOException {
        if (!this.consumed && this.bytes == null) {
            this.bytes = EntityUtils.toByteArray((HttpEntity)this.response.getEntity());
            this.consumed = true;
        }
        return this.bytes;
    }
}

