/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Arguments used for Cluster Restart command.  Since V11: If both restartOnlyStaleServices and restartServiceNames are specified, a service must be specified in restartServiceNames and also be stale, in order to be restarted.")
public class ApiRestartClusterArgs {
    @SerializedName(value="restartOnlyStaleServices")
    private Boolean restartOnlyStaleServices = null;
    @SerializedName(value="redeployClientConfiguration")
    private Boolean redeployClientConfiguration = null;
    @SerializedName(value="restartServiceNames")
    private List<String> restartServiceNames = null;

    public ApiRestartClusterArgs restartOnlyStaleServices(Boolean restartOnlyStaleServices) {
        this.restartOnlyStaleServices = restartOnlyStaleServices;
        return this;
    }

    @ApiModelProperty(value="Only restart services that have stale configuration and their dependent services.")
    public Boolean getRestartOnlyStaleServices() {
        return this.restartOnlyStaleServices;
    }

    public void setRestartOnlyStaleServices(Boolean restartOnlyStaleServices) {
        this.restartOnlyStaleServices = restartOnlyStaleServices;
    }

    public ApiRestartClusterArgs redeployClientConfiguration(Boolean redeployClientConfiguration) {
        this.redeployClientConfiguration = redeployClientConfiguration;
        return this;
    }

    @ApiModelProperty(value="Re-deploy client configuration for all services in the cluster.")
    public Boolean getRedeployClientConfiguration() {
        return this.redeployClientConfiguration;
    }

    public void setRedeployClientConfiguration(Boolean redeployClientConfiguration) {
        this.redeployClientConfiguration = redeployClientConfiguration;
    }

    public ApiRestartClusterArgs restartServiceNames(List<String> restartServiceNames) {
        this.restartServiceNames = restartServiceNames;
        return this;
    }

    public ApiRestartClusterArgs addRestartServiceNamesItem(String restartServiceNamesItem) {
        if (this.restartServiceNames == null) {
            this.restartServiceNames = new ArrayList<String>();
        }
        this.restartServiceNames.add(restartServiceNamesItem);
        return this;
    }

    @ApiModelProperty(value="Only restart services that are specified and their dependent services. Available since V11.")
    public List<String> getRestartServiceNames() {
        return this.restartServiceNames;
    }

    public void setRestartServiceNames(List<String> restartServiceNames) {
        this.restartServiceNames = restartServiceNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiRestartClusterArgs apiRestartClusterArgs = (ApiRestartClusterArgs)o;
        return Objects.equals(this.restartOnlyStaleServices, apiRestartClusterArgs.restartOnlyStaleServices) && Objects.equals(this.redeployClientConfiguration, apiRestartClusterArgs.redeployClientConfiguration) && Objects.equals(this.restartServiceNames, apiRestartClusterArgs.restartServiceNames);
    }

    public int hashCode() {
        return Objects.hash(this.restartOnlyStaleServices, this.redeployClientConfiguration, this.restartServiceNames);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiRestartClusterArgs {\n");
        sb.append("    restartOnlyStaleServices: ").append(this.toIndentedString(this.restartOnlyStaleServices)).append("\n");
        sb.append("    redeployClientConfiguration: ").append(this.toIndentedString(this.redeployClientConfiguration)).append("\n");
        sb.append("    restartServiceNames: ").append(this.toIndentedString(this.restartServiceNames)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

