/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiClusterRef;
import com.cloudera.api.swagger.model.ApiRoleConfigGroupRef;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A host template belongs to a cluster and contains a set of role config groups for slave roles (such as DataNodes and TaskTrackers) from services in the cluster. At most one role config group per role type can be present in a host template. Host templates can be applied to fresh hosts (those with no roles on them) in order to create a role for each of the role groups on each host.")
public class ApiHostTemplate {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="clusterRef")
    private ApiClusterRef clusterRef = null;
    @SerializedName(value="roleConfigGroupRefs")
    private List<ApiRoleConfigGroupRef> roleConfigGroupRefs = null;

    public ApiHostTemplate name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the host template. Unique across clusters.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApiHostTemplate clusterRef(ApiClusterRef clusterRef) {
        this.clusterRef = clusterRef;
        return this;
    }

    @ApiModelProperty(value="Readonly. A reference to the cluster the host template belongs to.")
    public ApiClusterRef getClusterRef() {
        return this.clusterRef;
    }

    public void setClusterRef(ApiClusterRef clusterRef) {
        this.clusterRef = clusterRef;
    }

    public ApiHostTemplate roleConfigGroupRefs(List<ApiRoleConfigGroupRef> roleConfigGroupRefs) {
        this.roleConfigGroupRefs = roleConfigGroupRefs;
        return this;
    }

    public ApiHostTemplate addRoleConfigGroupRefsItem(ApiRoleConfigGroupRef roleConfigGroupRefsItem) {
        if (this.roleConfigGroupRefs == null) {
            this.roleConfigGroupRefs = new ArrayList<ApiRoleConfigGroupRef>();
        }
        this.roleConfigGroupRefs.add(roleConfigGroupRefsItem);
        return this;
    }

    @ApiModelProperty(value="The role config groups belonging to this host tempalte.")
    public List<ApiRoleConfigGroupRef> getRoleConfigGroupRefs() {
        return this.roleConfigGroupRefs;
    }

    public void setRoleConfigGroupRefs(List<ApiRoleConfigGroupRef> roleConfigGroupRefs) {
        this.roleConfigGroupRefs = roleConfigGroupRefs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiHostTemplate apiHostTemplate = (ApiHostTemplate)o;
        return Objects.equals(this.name, apiHostTemplate.name) && Objects.equals(this.clusterRef, apiHostTemplate.clusterRef) && Objects.equals(this.roleConfigGroupRefs, apiHostTemplate.roleConfigGroupRefs);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.clusterRef, this.roleConfigGroupRefs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiHostTemplate {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    clusterRef: ").append(this.toIndentedString(this.clusterRef)).append("\n");
        sb.append("    roleConfigGroupRefs: ").append(this.toIndentedString(this.roleConfigGroupRefs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

