/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger;

import com.cloudera.api.swagger.client.ApiCallback;
import com.cloudera.api.swagger.client.ApiClient;
import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.client.ApiResponse;
import com.cloudera.api.swagger.client.Configuration;
import com.cloudera.api.swagger.client.Pair;
import com.cloudera.api.swagger.client.ProgressRequestBody;
import com.cloudera.api.swagger.client.ProgressResponseBody;
import com.cloudera.api.swagger.model.ApiAdhocSnapshot;
import com.cloudera.api.swagger.model.ApiCommand;
import com.cloudera.api.swagger.model.ApiSnapshotCommandList;
import com.cloudera.api.swagger.model.ApiSnapshotPolicy;
import com.cloudera.api.swagger.model.ApiSnapshotPolicyList;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;

public class SnapshotsResourceApi {
    private ApiClient apiClient;

    public SnapshotsResourceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SnapshotsResourceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call adhocSnapshotCall(String clusterName, String serviceName, ApiAdhocSnapshot body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiAdhocSnapshot localVarPostBody = body;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/snapshots".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call adhocSnapshotValidateBeforeCall(String clusterName, String serviceName, ApiAdhocSnapshot body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling adhocSnapshot(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling adhocSnapshot(Async)");
        }
        Call call = this.adhocSnapshotCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiCommand adhocSnapshot(String clusterName, String serviceName, ApiAdhocSnapshot body) throws ApiException {
        ApiResponse<ApiCommand> resp = this.adhocSnapshotWithHttpInfo(clusterName, serviceName, body);
        return resp.getData();
    }

    public ApiResponse<ApiCommand> adhocSnapshotWithHttpInfo(String clusterName, String serviceName, ApiAdhocSnapshot body) throws ApiException {
        Call call = this.adhocSnapshotValidateBeforeCall(clusterName, serviceName, body, null, null);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call adhocSnapshotAsync(String clusterName, String serviceName, ApiAdhocSnapshot body, final ApiCallback<ApiCommand> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.adhocSnapshotValidateBeforeCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiCommand>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call createPoliciesCall(String clusterName, String serviceName, ApiSnapshotPolicyList body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiSnapshotPolicyList localVarPostBody = body;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/snapshots/policies".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createPoliciesValidateBeforeCall(String clusterName, String serviceName, ApiSnapshotPolicyList body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling createPolicies(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling createPolicies(Async)");
        }
        Call call = this.createPoliciesCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiSnapshotPolicyList createPolicies(String clusterName, String serviceName, ApiSnapshotPolicyList body) throws ApiException {
        ApiResponse<ApiSnapshotPolicyList> resp = this.createPoliciesWithHttpInfo(clusterName, serviceName, body);
        return resp.getData();
    }

    public ApiResponse<ApiSnapshotPolicyList> createPoliciesWithHttpInfo(String clusterName, String serviceName, ApiSnapshotPolicyList body) throws ApiException {
        Call call = this.createPoliciesValidateBeforeCall(clusterName, serviceName, body, null, null);
        Type localVarReturnType = new TypeToken<ApiSnapshotPolicyList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createPoliciesAsync(String clusterName, String serviceName, ApiSnapshotPolicyList body, final ApiCallback<ApiSnapshotPolicyList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createPoliciesValidateBeforeCall(clusterName, serviceName, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiSnapshotPolicyList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deletePolicyCall(String clusterName, String policyName, String serviceName, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/snapshots/policies/{policyName}".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{policyName\\}", this.apiClient.escapeString(policyName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deletePolicyValidateBeforeCall(String clusterName, String policyName, String serviceName, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling deletePolicy(Async)");
        }
        if (policyName == null) {
            throw new ApiException("Missing the required parameter 'policyName' when calling deletePolicy(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling deletePolicy(Async)");
        }
        Call call = this.deletePolicyCall(clusterName, policyName, serviceName, progressListener, progressRequestListener);
        return call;
    }

    public ApiSnapshotPolicy deletePolicy(String clusterName, String policyName, String serviceName) throws ApiException {
        ApiResponse<ApiSnapshotPolicy> resp = this.deletePolicyWithHttpInfo(clusterName, policyName, serviceName);
        return resp.getData();
    }

    public ApiResponse<ApiSnapshotPolicy> deletePolicyWithHttpInfo(String clusterName, String policyName, String serviceName) throws ApiException {
        Call call = this.deletePolicyValidateBeforeCall(clusterName, policyName, serviceName, null, null);
        Type localVarReturnType = new TypeToken<ApiSnapshotPolicy>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call deletePolicyAsync(String clusterName, String policyName, String serviceName, final ApiCallback<ApiSnapshotPolicy> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deletePolicyValidateBeforeCall(clusterName, policyName, serviceName, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiSnapshotPolicy>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call readHistoryCall(String clusterName, String policyName, String serviceName, BigDecimal limit, BigDecimal offset, String view, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/snapshots/policies/{policyName}/history".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{policyName\\}", this.apiClient.escapeString(policyName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        }
        if (view != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "view", view));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call readHistoryValidateBeforeCall(String clusterName, String policyName, String serviceName, BigDecimal limit, BigDecimal offset, String view, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling readHistory(Async)");
        }
        if (policyName == null) {
            throw new ApiException("Missing the required parameter 'policyName' when calling readHistory(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling readHistory(Async)");
        }
        Call call = this.readHistoryCall(clusterName, policyName, serviceName, limit, offset, view, progressListener, progressRequestListener);
        return call;
    }

    public ApiSnapshotCommandList readHistory(String clusterName, String policyName, String serviceName, BigDecimal limit, BigDecimal offset, String view) throws ApiException {
        ApiResponse<ApiSnapshotCommandList> resp = this.readHistoryWithHttpInfo(clusterName, policyName, serviceName, limit, offset, view);
        return resp.getData();
    }

    public ApiResponse<ApiSnapshotCommandList> readHistoryWithHttpInfo(String clusterName, String policyName, String serviceName, BigDecimal limit, BigDecimal offset, String view) throws ApiException {
        Call call = this.readHistoryValidateBeforeCall(clusterName, policyName, serviceName, limit, offset, view, null, null);
        Type localVarReturnType = new TypeToken<ApiSnapshotCommandList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call readHistoryAsync(String clusterName, String policyName, String serviceName, BigDecimal limit, BigDecimal offset, String view, final ApiCallback<ApiSnapshotCommandList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.readHistoryValidateBeforeCall(clusterName, policyName, serviceName, limit, offset, view, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiSnapshotCommandList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call readPoliciesCall(String clusterName, String serviceName, String view, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/snapshots/policies".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (view != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "view", view));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call readPoliciesValidateBeforeCall(String clusterName, String serviceName, String view, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling readPolicies(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling readPolicies(Async)");
        }
        Call call = this.readPoliciesCall(clusterName, serviceName, view, progressListener, progressRequestListener);
        return call;
    }

    public ApiSnapshotPolicyList readPolicies(String clusterName, String serviceName, String view) throws ApiException {
        ApiResponse<ApiSnapshotPolicyList> resp = this.readPoliciesWithHttpInfo(clusterName, serviceName, view);
        return resp.getData();
    }

    public ApiResponse<ApiSnapshotPolicyList> readPoliciesWithHttpInfo(String clusterName, String serviceName, String view) throws ApiException {
        Call call = this.readPoliciesValidateBeforeCall(clusterName, serviceName, view, null, null);
        Type localVarReturnType = new TypeToken<ApiSnapshotPolicyList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call readPoliciesAsync(String clusterName, String serviceName, String view, final ApiCallback<ApiSnapshotPolicyList> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.readPoliciesValidateBeforeCall(clusterName, serviceName, view, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiSnapshotPolicyList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call readPolicyCall(String clusterName, String policyName, String serviceName, String view, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/snapshots/policies/{policyName}".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{policyName\\}", this.apiClient.escapeString(policyName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (view != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "view", view));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call readPolicyValidateBeforeCall(String clusterName, String policyName, String serviceName, String view, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling readPolicy(Async)");
        }
        if (policyName == null) {
            throw new ApiException("Missing the required parameter 'policyName' when calling readPolicy(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling readPolicy(Async)");
        }
        Call call = this.readPolicyCall(clusterName, policyName, serviceName, view, progressListener, progressRequestListener);
        return call;
    }

    public ApiSnapshotPolicy readPolicy(String clusterName, String policyName, String serviceName, String view) throws ApiException {
        ApiResponse<ApiSnapshotPolicy> resp = this.readPolicyWithHttpInfo(clusterName, policyName, serviceName, view);
        return resp.getData();
    }

    public ApiResponse<ApiSnapshotPolicy> readPolicyWithHttpInfo(String clusterName, String policyName, String serviceName, String view) throws ApiException {
        Call call = this.readPolicyValidateBeforeCall(clusterName, policyName, serviceName, view, null, null);
        Type localVarReturnType = new TypeToken<ApiSnapshotPolicy>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call readPolicyAsync(String clusterName, String policyName, String serviceName, String view, final ApiCallback<ApiSnapshotPolicy> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.readPolicyValidateBeforeCall(clusterName, policyName, serviceName, view, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiSnapshotPolicy>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updatePolicyCall(String clusterName, String policyName, String serviceName, ApiSnapshotPolicy body, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApiSnapshotPolicy localVarPostBody = body;
        String localVarPath = "/clusters/{clusterName}/services/{serviceName}/snapshots/policies/{policyName}".replaceAll("\\{clusterName\\}", this.apiClient.escapeString(clusterName.toString())).replaceAll("\\{policyName\\}", this.apiClient.escapeString(policyName.toString())).replaceAll("\\{serviceName\\}", this.apiClient.escapeString(serviceName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"basic"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updatePolicyValidateBeforeCall(String clusterName, String policyName, String serviceName, ApiSnapshotPolicy body, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (clusterName == null) {
            throw new ApiException("Missing the required parameter 'clusterName' when calling updatePolicy(Async)");
        }
        if (policyName == null) {
            throw new ApiException("Missing the required parameter 'policyName' when calling updatePolicy(Async)");
        }
        if (serviceName == null) {
            throw new ApiException("Missing the required parameter 'serviceName' when calling updatePolicy(Async)");
        }
        Call call = this.updatePolicyCall(clusterName, policyName, serviceName, body, progressListener, progressRequestListener);
        return call;
    }

    public ApiSnapshotPolicy updatePolicy(String clusterName, String policyName, String serviceName, ApiSnapshotPolicy body) throws ApiException {
        ApiResponse<ApiSnapshotPolicy> resp = this.updatePolicyWithHttpInfo(clusterName, policyName, serviceName, body);
        return resp.getData();
    }

    public ApiResponse<ApiSnapshotPolicy> updatePolicyWithHttpInfo(String clusterName, String policyName, String serviceName, ApiSnapshotPolicy body) throws ApiException {
        Call call = this.updatePolicyValidateBeforeCall(clusterName, policyName, serviceName, body, null, null);
        Type localVarReturnType = new TypeToken<ApiSnapshotPolicy>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updatePolicyAsync(String clusterName, String policyName, String serviceName, ApiSnapshotPolicy body, final ApiCallback<ApiSnapshotPolicy> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updatePolicyValidateBeforeCall(clusterName, policyName, serviceName, body, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApiSnapshotPolicy>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

