/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.hdfs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIBuilder;
import org.apache.knox.gateway.shell.AbstractRequest;
import org.apache.knox.gateway.shell.BasicResponse;
import org.apache.knox.gateway.shell.KnoxSession;

public class Get {

    public static class Response
    extends BasicResponse {
        Response(HttpResponse response, String to) throws IOException {
            super(response);
            if (to != null) {
                FileUtils.copyInputStreamToFile((InputStream)this.getStream(), (File)new File(to));
            }
        }
    }

    public static class Request
    extends AbstractRequest<Response> {
        private String from;
        private String to;

        Request(KnoxSession session) {
            super(session);
        }

        public Request from(String file) {
            this.from = file;
            return this;
        }

        public Request file(String file) {
            this.to = file;
            return this;
        }

        @Override
        protected Callable<Response> callable() {
            return new Callable<Response>(){

                @Override
                public Response call() throws Exception {
                    URIBuilder uri = this.uri(new String[]{"/webhdfs/v1", from});
                    this.addQueryParam(uri, "op", "OPEN");
                    HttpGet request = new HttpGet(uri.build());
                    return new Response((HttpResponse)this.execute((HttpRequest)request), to);
                }
            };
        }
    }
}

