/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.tool.xmlsectool;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.GeneralSecurityException;
import java.security.KeyException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.shibboleth.tool.xmlsectool.ReturnCode;
import net.shibboleth.tool.xmlsectool.Terminator;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.X509Support;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CredentialHelper {
    private static final Logger LOG = LoggerFactory.getLogger(CredentialHelper.class);

    private CredentialHelper() {
    }

    protected static BasicX509Credential getFileBasedCredentials(String keyFile, String keyPassword, String certificateFile) throws KeyException, CertificateException {
        LOG.debug("Reading PEM/DER encoded credentials from the filesystem");
        LOG.debug("Reading certificates from file {}", (Object)certificateFile);
        Collection certificates = X509Support.decodeCertificates((File)new File(certificateFile));
        X509Certificate entityCertificate = (X509Certificate)certificates.iterator().next();
        BasicX509Credential credential = new BasicX509Credential(entityCertificate);
        credential.setEntityCertificateChain(certificates);
        LOG.debug("Certificates successfully read");
        if (keyFile != null) {
            LOG.debug("Reading private key from file {}", (Object)keyFile);
            if (keyPassword == null) {
                credential.setPrivateKey(KeySupport.decodePrivateKey((File)new File(keyFile), null));
            } else {
                credential.setPrivateKey(KeySupport.decodePrivateKey((File)new File(keyFile), (char[])keyPassword.toCharArray()));
            }
            LOG.debug("Private key succesfully read");
        }
        return credential;
    }

    protected static BasicX509Credential getKeystoreCredential(String keystorePath, String keystorePassword, String keystoreProvider, String keystoreType, String keyAlias, String keyPassword) throws IOException, GeneralSecurityException {
        String storePassword;
        LOG.debug("Reading credentials from keystore");
        String storeType = keystoreType;
        if (storeType == null) {
            storeType = KeyStore.getDefaultType();
        }
        if ((storePassword = keystorePassword) == null) {
            storePassword = keyPassword;
        }
        KeyStore keystore = keystoreProvider != null ? KeyStore.getInstance(storeType, keystoreProvider) : KeyStore.getInstance(storeType);
        keystore.load(new FileInputStream(keystorePath), storePassword.toCharArray());
        return CredentialHelper.getCredentialFromKeystore(keystore, keyAlias, keyPassword);
    }

    protected static BasicX509Credential getPKCS11Credential(String keystoreProvider, String pkcs11Config, String keyAlias, String keyPassword) throws IOException, GeneralSecurityException {
        LOG.debug("Install PKCS11 provider");
        KeyStore keystore = null;
        try {
            if (keystoreProvider != null) {
                LOG.debug("Creating PKCS11 keystore with provider {} and configuration file {}", (Object)keystoreProvider, (Object)pkcs11Config);
                Class<?> providerClass = CredentialHelper.class.getClassLoader().loadClass(keystoreProvider);
                Constructor<?> providerConstructor = providerClass.getConstructor(String.class);
                Provider pkcs11Provider = (Provider)providerConstructor.newInstance(pkcs11Config);
                pkcs11Provider.load(new FileInputStream(pkcs11Config));
                Security.addProvider(pkcs11Provider);
                keystore = KeyStore.getInstance("PKCS11", pkcs11Provider);
            } else {
                LOG.debug("Creating PKCS11 keystore with system wide provider and configuration file");
                keystore = KeyStore.getInstance("PKCS11");
            }
        }
        catch (ClassNotFoundException e) {
            LOG.error("Unable to load keystore provider class: " + keystoreProvider);
            throw new Terminator(ReturnCode.RC_INIT);
        }
        catch (NoSuchMethodException e) {
            LOG.error("Keystore provider class does not provide a String-argument constructor");
            throw new Terminator(ReturnCode.RC_INIT);
        }
        catch (Exception e) {
            LOG.error("Unable to read PKCS11 keystore", (Throwable)e);
            throw new IOException("Unable to read PKCS11 keystore", e);
        }
        LOG.debug("Initializing PKCS11 keystore");
        keystore.load(null, keyPassword.toCharArray());
        return CredentialHelper.getCredentialFromKeystore(keystore, keyAlias, keyPassword);
    }

    protected static BasicX509Credential getCredentialFromKeystore(KeyStore keystore, String keyAlias, String keyPassword) throws GeneralSecurityException {
        BasicX509Credential credential;
        KeyStore.Entry keyEntry = keystore.getEntry(keyAlias, new KeyStore.PasswordProtection(keyPassword.toCharArray()));
        if (keyEntry instanceof KeyStore.PrivateKeyEntry) {
            KeyStore.PrivateKeyEntry privKeyEntry = (KeyStore.PrivateKeyEntry)keyEntry;
            List<Certificate> certChain = Arrays.asList(privKeyEntry.getCertificateChain());
            credential = new BasicX509Credential((X509Certificate)privKeyEntry.getCertificate());
            credential.setEntityCertificateChain(certChain);
            credential.setPrivateKey(privKeyEntry.getPrivateKey());
        } else if (keyEntry instanceof KeyStore.TrustedCertificateEntry) {
            KeyStore.TrustedCertificateEntry certEntry = (KeyStore.TrustedCertificateEntry)keyEntry;
            credential = new BasicX509Credential((X509Certificate)certEntry.getTrustedCertificate());
        } else {
            throw new CertificateException("unknown type of key entry in keystore");
        }
        LOG.debug("Successfully read credentials from keystore");
        return credential;
    }
}

