/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.ha.deploy;

import java.io.IOException;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import org.apache.knox.gateway.deploy.DeploymentContext;
import org.apache.knox.gateway.deploy.ProviderDeploymentContributorBase;
import org.apache.knox.gateway.descriptor.FilterParamDescriptor;
import org.apache.knox.gateway.descriptor.ResourceDescriptor;
import org.apache.knox.gateway.ha.provider.HaDescriptor;
import org.apache.knox.gateway.ha.provider.HaServiceConfig;
import org.apache.knox.gateway.ha.provider.HaServletContextListener;
import org.apache.knox.gateway.ha.provider.impl.HaDescriptorFactory;
import org.apache.knox.gateway.ha.provider.impl.HaDescriptorManager;
import org.apache.knox.gateway.ha.provider.impl.i18n.HaMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.topology.Provider;
import org.apache.knox.gateway.topology.Service;
import org.apache.knox.gateway.topology.Topology;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;

public class HaProviderDeploymentContributor
extends ProviderDeploymentContributorBase {
    private static final String PROVIDER_ROLE_NAME = "ha";
    private static final String PROVIDER_IMPL_NAME = "HaProvider";
    private static final String HA_DESCRIPTOR_NAME = "ha.provider.descriptor";
    private static final HaMessages LOG = (HaMessages)MessagesFactory.get(HaMessages.class);

    public String getRole() {
        return PROVIDER_ROLE_NAME;
    }

    public String getName() {
        return PROVIDER_IMPL_NAME;
    }

    public void contributeProvider(DeploymentContext context, Provider provider) {
        Topology topology = context.getTopology();
        Map params = provider.getParams();
        HaDescriptor descriptor = HaDescriptorFactory.createDescriptor();
        for (Map.Entry entry : params.entrySet()) {
            String role = (String)entry.getKey();
            String roleParams = (String)entry.getValue();
            HaServiceConfig config = HaDescriptorFactory.createServiceConfig(role, roleParams);
            Map serviceLevelParams = null;
            for (Service s : topology.getServices()) {
                if (!s.getRole().equals(role)) continue;
                serviceLevelParams = s.getParams();
                break;
            }
            this.applyParamOverrides(config, serviceLevelParams);
            descriptor.addServiceConfig(config);
        }
        StringWriter writer = new StringWriter();
        try {
            HaDescriptorManager.store(descriptor, writer);
        }
        catch (IOException e) {
            LOG.failedToWriteHaDescriptor(e);
        }
        String asset = writer.toString();
        context.getWebArchive().addAsWebInfResource((Asset)new StringAsset(asset), "ha.xml");
        context.addDescriptor(HA_DESCRIPTOR_NAME, (Object)descriptor);
    }

    private void applyParamOverrides(HaServiceConfig config, Map<String, String> serviceLevelParams) {
        if (serviceLevelParams != null && !serviceLevelParams.isEmpty()) {
            String zkNamespace;
            String zkEnsemble;
            String failOverAttempts;
            String failOverSleep;
            String enabled = serviceLevelParams.get("haEnabled");
            if (enabled != null) {
                config.setEnabled(Boolean.parseBoolean(enabled));
            }
            if ((failOverSleep = serviceLevelParams.get("failoverSleep")) != null) {
                config.setFailoverSleep(Integer.parseInt(failOverSleep));
            }
            if ((failOverAttempts = serviceLevelParams.get("maxFailoverAttempts")) != null) {
                config.setMaxFailoverAttempts(Integer.parseInt(failOverAttempts));
            }
            if ((zkEnsemble = serviceLevelParams.get("zookeeperEnsemble")) != null) {
                config.setZookeeperEnsemble(zkEnsemble);
            }
            if ((zkNamespace = serviceLevelParams.get("zookeeperNamespace")) != null) {
                config.setZookeeperNamespace(zkNamespace);
            }
        }
    }

    public void finalizeContribution(DeploymentContext context) {
        if (context.getDescriptor(HA_DESCRIPTOR_NAME) != null) {
            context.getWebAppDescriptor().createListener().listenerClass(HaServletContextListener.class.getName());
            context.getWebAppDescriptor().createContextParam().paramName("haDescriptorLocation").paramValue("/WEB-INF/ha.xml");
        }
    }

    public void contributeFilter(DeploymentContext context, Provider provider, Service service, ResourceDescriptor resource, List<FilterParamDescriptor> params) {
    }
}

