/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.clientcert.filter;

import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.knox.gateway.audit.api.AuditService;
import org.apache.knox.gateway.audit.api.AuditServiceFactory;
import org.apache.knox.gateway.audit.api.Auditor;
import org.apache.knox.gateway.clientcert.filter.ClientCertMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.security.PrimaryPrincipal;
import org.apache.knox.gateway.util.X500PrincipalParser;

public class ClientCertFilter
implements Filter {
    private static ClientCertMessages log = (ClientCertMessages)MessagesFactory.get(ClientCertMessages.class);
    private static final String CLIENT_CERT_PRINCIPAL_ATTRIBUTE_NAME = "client.cert.principal.attribute.name";
    private static AuditService auditService = AuditServiceFactory.getAuditService();
    private static Auditor auditor = auditService.getAuditor("audit", "knox", "knox");
    private String principalAttributeName;

    public void init(FilterConfig filterConfig) {
        this.principalAttributeName = filterConfig.getInitParameter(CLIENT_CERT_PRINCIPAL_ATTRIBUTE_NAME);
        if (this.principalAttributeName == null) {
            this.principalAttributeName = "DN";
        } else if (!"DN".equalsIgnoreCase(this.principalAttributeName) && !"CN".equalsIgnoreCase(this.principalAttributeName)) {
            log.unknownCertificateAttribute(this.principalAttributeName);
            this.principalAttributeName = "DN";
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        X509Certificate cert = this.extractCertificate(httpRequest);
        if (cert != null) {
            String principal = this.extractPrincipalFromCert(cert);
            Subject subject = new Subject();
            subject.getPrincipals().add((Principal)new PrimaryPrincipal(principal));
            auditService.getContext().setUsername(principal);
            String sourceUri = (String)request.getAttribute("sourceRequestContextUrl");
            auditor.audit("authentication", sourceUri, "uri", "success");
            this.continueWithEstablishedSecurityContext(subject, httpRequest, (HttpServletResponse)response, filterChain);
        } else {
            ((HttpServletResponse)response).sendError(403, "User not authenticated");
        }
    }

    private String extractPrincipalFromCert(X509Certificate cert) {
        String p = null;
        if ("DN".equalsIgnoreCase(this.principalAttributeName)) {
            p = cert.getSubjectDN().getName();
        } else if ("CN".equalsIgnoreCase(this.principalAttributeName)) {
            X500Principal x500Principal = cert.getSubjectX500Principal();
            X500PrincipalParser parser = new X500PrincipalParser(x500Principal);
            p = parser.getCN();
        } else {
            log.unknownCertificateAttribute(this.principalAttributeName);
            p = cert.getSubjectDN().getName();
        }
        return p;
    }

    private X509Certificate extractCertificate(HttpServletRequest req) {
        X509Certificate[] certs = (X509Certificate[])req.getAttribute("javax.servlet.request.X509Certificate");
        if (null != certs && certs.length > 0) {
            return certs[0];
        }
        return null;
    }

    private void continueWithEstablishedSecurityContext(Subject subject, final HttpServletRequest request, final HttpServletResponse response, final FilterChain chain) throws IOException, ServletException {
        try {
            Subject.doAs(subject, new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            throw new ServletException(t);
        }
    }

    public void destroy() {
    }
}

