/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import javax.net.ssl.KeyManagerFactory;
import org.apache.directory.api.util.Strings;
import sun.security.x509.AlgorithmId;
import sun.security.x509.BasicConstraintsExtension;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.DNSName;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNames;
import sun.security.x509.IPAddressName;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public final class CertificateUtil {
    private static final boolean SELF_SIGNED = true;
    private static final boolean CA_SIGNED = false;
    private static final boolean CRITICAL = true;

    private CertificateUtil() {
    }

    private static void setInfo(X509CertInfo info, X500Name subject, X500Name issuer, KeyPair keyPair, int days, String algoStr, boolean isCA) throws CertificateException, IOException, NoSuchAlgorithmException {
        Date from = new Date();
        Date to = new Date(from.getTime() + (long)days * 86400000L);
        CertificateValidity interval = new CertificateValidity(from, to);
        info.set("version", new CertificateVersion(2));
        BigInteger serialNumber = new BigInteger(64, new SecureRandom());
        info.set("serialNumber", new CertificateSerialNumber(serialNumber));
        AlgorithmId algo = AlgorithmId.get(algoStr);
        info.set("algorithmID", new CertificateAlgorithmId(algo));
        info.set("issuer", issuer);
        info.set("validity", interval);
        info.set("subject", subject);
        info.set("key", new CertificateX509Key(keyPair.getPublic()));
        CertificateExtensions extensions = new CertificateExtensions();
        GeneralNames names = new GeneralNames();
        names.add(new GeneralName(new DNSName(InetAddress.getLocalHost().getHostName())));
        String ipAddress = InetAddress.getLocalHost().getHostAddress();
        names.add(new GeneralName(new IPAddressName(ipAddress)));
        SubjectAlternativeNameExtension subjectAltName = new SubjectAlternativeNameExtension(names);
        extensions.set(subjectAltName.getExtensionId().toString(), subjectAltName);
        BasicConstraintsExtension basicConstraint = new BasicConstraintsExtension(true, isCA, -1);
        extensions.set(basicConstraint.getExtensionId().toString(), basicConstraint);
        info.set("extensions", extensions);
    }

    public static X509Certificate generateSelfSignedCertificate(X500Name issuer, KeyPair keyPair, int days, String algoStr) throws CertificateException, IOException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        X509CertInfo info = new X509CertInfo();
        CertificateUtil.setInfo(info, issuer, issuer, keyPair, days, algoStr, true);
        X509CertImpl certificate = new X509CertImpl(info);
        certificate.sign(keyPair.getPrivate(), algoStr);
        return certificate;
    }

    public static X509Certificate generateCertificate(X500Name subject, X500Name issuer, KeyPair keyPair, int days, String algoStr) throws CertificateException, IOException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        X509CertInfo info = new X509CertInfo();
        CertificateUtil.setInfo(info, subject, issuer, keyPair, days, algoStr, false);
        X509CertImpl certificate = new X509CertImpl(info);
        certificate.sign(keyPair.getPrivate(), algoStr);
        return certificate;
    }

    public static KeyManagerFactory loadKeyStore(String keyStoreFile, String keyStorePasswordStr) throws Exception {
        char[] keyStorePassword;
        char[] cArray = keyStorePassword = Strings.isEmpty((String)keyStorePasswordStr) ? null : keyStorePasswordStr.toCharArray();
        if (!Strings.isEmpty((String)keyStoreFile)) {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            try (InputStream is = Files.newInputStream(Paths.get(keyStoreFile, new String[0]), new OpenOption[0]);){
                keyStore.load(is, keyStorePassword);
            }
            Enumeration<String> aliases = keyStore.aliases();
            if (!aliases.hasMoreElements()) {
                throw new KeyStoreException("Key store is empty");
            }
            String alias = aliases.nextElement();
            if (aliases.hasMoreElements()) {
                throw new KeyStoreException("Key store contains more than one entry");
            }
            if (!keyStore.isKeyEntry(alias)) {
                throw new KeyStoreException("Key store must contain a key entry");
            }
            if (keyStore.getCertificateChain(alias) == null) {
                throw new KeyStoreException("Key store must contain a certificate chain");
            }
            if (keyStore.getKey(alias, keyStorePassword) == null) {
                throw new KeyStoreException("Private key must be recoverable by the key store password");
            }
            String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
            if (algorithm == null) {
                algorithm = KeyManagerFactory.getDefaultAlgorithm();
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(algorithm);
            keyManagerFactory.init(keyStore, keyStorePassword);
            return keyManagerFactory;
        }
        return null;
    }

    public static File createTempKeyStore(String keyStoreName, char[] keyStorePassword) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, InvalidKeyException, NoSuchProviderException, SignatureException {
        File keyStoreFile = Files.createTempFile(keyStoreName, "ks", new FileAttribute[0]).toFile();
        keyStoreFile.deleteOnExit();
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (FileInputStream keyStoreData = new FileInputStream(keyStoreFile);){
            keyStore.load(null, keyStorePassword);
        }
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC");
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        X500Name owner = new X500Name("apacheds", "directory", "apache", "US");
        X509Certificate certificate = CertificateUtil.generateSelfSignedCertificate(owner, keyPair, 365, "SHA256WithECDSA");
        keyStore.setKeyEntry("apachedsKey", keyPair.getPrivate(), keyStorePassword, new X509Certificate[]{certificate});
        try (FileOutputStream out = new FileOutputStream(keyStoreFile);){
            keyStore.store(out, keyStorePassword);
        }
        return keyStoreFile;
    }
}

