/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.ha.dispatch;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.knox.gateway.ha.dispatch.DefaultHaDispatch;

public class AtlasApiTrustedProxyHaDispatch
extends DefaultHaDispatch {
    public AtlasApiTrustedProxyHaDispatch() {
        this.setServiceRole("ATLAS-API");
    }

    @Override
    protected void executeRequest(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse) throws IOException {
        HttpResponse inboundResponse = null;
        try {
            inboundResponse = this.executeOutboundRequest(outboundRequest);
            int statusCode = inboundResponse.getStatusLine().getStatusCode();
            Header originalLocationHeader = inboundResponse.getFirstHeader("Location");
            if ((statusCode == 302 || statusCode == 307) && originalLocationHeader != null) {
                inboundResponse.removeHeaders("Location");
                this.failoverRequest(outboundRequest, inboundRequest, outboundResponse, inboundResponse, new Exception("Atlas HA redirection"));
            }
            this.writeOutboundResponse(outboundRequest, inboundRequest, outboundResponse, inboundResponse);
        }
        catch (IOException e) {
            LOG.errorConnectingToServer(outboundRequest.getURI().toString(), e);
            this.failoverRequest(outboundRequest, inboundRequest, outboundResponse, inboundResponse, e);
        }
    }
}

