/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.engine;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.pac4j.core.authorization.checker.AuthorizationChecker;
import org.pac4j.core.authorization.checker.DefaultAuthorizationChecker;
import org.pac4j.core.client.Client;
import org.pac4j.core.client.Clients;
import org.pac4j.core.client.DirectClient;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.client.finder.ClientFinder;
import org.pac4j.core.client.finder.DefaultSecurityClientFinder;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.engine.AbstractExceptionAwareLogic;
import org.pac4j.core.engine.SecurityGrantedAccessAdapter;
import org.pac4j.core.engine.SecurityLogic;
import org.pac4j.core.engine.decision.DefaultProfileStorageDecision;
import org.pac4j.core.engine.decision.ProfileStorageDecision;
import org.pac4j.core.engine.savedrequest.DefaultSavedRequestHandler;
import org.pac4j.core.engine.savedrequest.SavedRequestHandler;
import org.pac4j.core.exception.http.ForbiddenAction;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.exception.http.UnauthorizedAction;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.http.ajax.AjaxRequestResolver;
import org.pac4j.core.matching.checker.DefaultMatchingChecker;
import org.pac4j.core.matching.checker.MatchingChecker;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSecurityLogic<R, C extends WebContext>
extends AbstractExceptionAwareLogic<R, C>
implements SecurityLogic<R, C> {
    public static final DefaultSecurityLogic INSTANCE = new DefaultSecurityLogic();
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSecurityLogic.class);
    private ClientFinder clientFinder = new DefaultSecurityClientFinder();
    private AuthorizationChecker authorizationChecker = new DefaultAuthorizationChecker();
    private MatchingChecker matchingChecker = new DefaultMatchingChecker();
    private ProfileStorageDecision profileStorageDecision = new DefaultProfileStorageDecision();
    private SavedRequestHandler savedRequestHandler = new DefaultSavedRequestHandler();

    @Override
    public R perform(C context, Config config, SecurityGrantedAccessAdapter<R, C> securityGrantedAccessAdapter, HttpActionAdapter<R, C> httpActionAdapter, String clients, String authorizers, String matchers, Boolean inputMultiProfile, Object ... parameters) {
        HttpAction action;
        block11: {
            LOGGER.debug("=== SECURITY ===");
            try {
                boolean multiProfile = inputMultiProfile != null && inputMultiProfile != false;
                CommonHelper.assertNotNull("context", context);
                CommonHelper.assertNotNull("config", config);
                CommonHelper.assertNotNull("httpActionAdapter", httpActionAdapter);
                CommonHelper.assertNotNull("clientFinder", this.clientFinder);
                CommonHelper.assertNotNull("authorizationChecker", this.authorizationChecker);
                CommonHelper.assertNotNull("matchingChecker", this.matchingChecker);
                CommonHelper.assertNotNull("profileStorageDecision", this.profileStorageDecision);
                Clients configClients = config.getClients();
                CommonHelper.assertNotNull("configClients", configClients);
                LOGGER.debug("url: {}", (Object)context.getFullRequestURL());
                LOGGER.debug("matchers: {}", (Object)matchers);
                if (this.matchingChecker.matches((WebContext)context, matchers, config.getMatchers())) {
                    LOGGER.debug("clients: {}", (Object)clients);
                    List<Client> currentClients = this.clientFinder.find(configClients, (WebContext)context, clients);
                    LOGGER.debug("currentClients: {}", currentClients);
                    boolean loadProfilesFromSession = this.profileStorageDecision.mustLoadProfilesFromSession(context, currentClients);
                    LOGGER.debug("loadProfilesFromSession: {}", (Object)loadProfilesFromSession);
                    context.setRequestAttribute("pac4jLoadProfilesFromSession", loadProfilesFromSession);
                    ProfileManager<UserProfile> manager = this.getProfileManager(context);
                    manager.setConfig(config);
                    List<UserProfile> profiles = manager.getAll(loadProfilesFromSession);
                    LOGGER.debug("profiles: {}", profiles);
                    if (CommonHelper.isEmpty(profiles) && CommonHelper.isNotEmpty(currentClients)) {
                        boolean updated = false;
                        for (Client currentClient : currentClients) {
                            if (!(currentClient instanceof DirectClient)) continue;
                            LOGGER.debug("Performing authentication for direct client: {}", (Object)currentClient);
                            Optional credentials = currentClient.getCredentials((WebContext)context);
                            LOGGER.debug("credentials: {}", credentials);
                            if (!credentials.isPresent()) continue;
                            Optional<UserProfile> profile = currentClient.getUserProfile((Credentials)credentials.get(), (WebContext)context);
                            LOGGER.debug("profile: {}", profile);
                            if (!profile.isPresent()) continue;
                            boolean saveProfileInSession = this.profileStorageDecision.mustSaveProfileInSession(context, currentClients, (DirectClient)currentClient, profile.get());
                            LOGGER.debug("saveProfileInSession: {} / multiProfile: {}", (Object)saveProfileInSession, (Object)multiProfile);
                            manager.save(saveProfileInSession, profile.get(), multiProfile);
                            updated = true;
                            if (multiProfile) continue;
                            break;
                        }
                        if (updated) {
                            profiles = manager.getAll(loadProfilesFromSession);
                            LOGGER.debug("new profiles: {}", profiles);
                        }
                    }
                    if (CommonHelper.isNotEmpty(profiles)) {
                        LOGGER.debug("authorizers: {}", (Object)authorizers);
                        if (this.authorizationChecker.isAuthorized((WebContext)context, profiles, authorizers, config.getAuthorizers())) {
                            LOGGER.debug("authenticated and authorized -> grant access");
                            return securityGrantedAccessAdapter.adapt(context, profiles, parameters);
                        }
                        LOGGER.debug("forbidden");
                        action = this.forbidden(context, currentClients, profiles, authorizers);
                    } else if (this.startAuthentication(context, currentClients)) {
                        LOGGER.debug("Starting authentication");
                        this.saveRequestedUrl(context, currentClients, config.getClients().getAjaxRequestResolver());
                        action = this.redirectToIdentityProvider(context, currentClients);
                    } else {
                        LOGGER.debug("unauthorized");
                        action = this.unauthorized(context, currentClients);
                    }
                    break block11;
                }
                LOGGER.debug("no matching for this request -> grant access");
                return securityGrantedAccessAdapter.adapt(context, Arrays.asList(new UserProfile[0]), parameters);
            }
            catch (Exception e) {
                return this.handleException(e, httpActionAdapter, context);
            }
        }
        return httpActionAdapter.adapt(action, context);
    }

    protected HttpAction forbidden(C context, List<Client<? extends Credentials>> currentClients, List<UserProfile> profiles, String authorizers) {
        return ForbiddenAction.INSTANCE;
    }

    protected boolean startAuthentication(C context, List<Client<? extends Credentials>> currentClients) {
        return CommonHelper.isNotEmpty(currentClients) && currentClients.get(0) instanceof IndirectClient;
    }

    protected void saveRequestedUrl(C context, List<Client<? extends Credentials>> currentClients, AjaxRequestResolver ajaxRequestResolver) {
        if (ajaxRequestResolver == null || !ajaxRequestResolver.isAjax((WebContext)context)) {
            this.savedRequestHandler.save((WebContext)context);
        }
    }

    protected HttpAction redirectToIdentityProvider(C context, List<Client<? extends Credentials>> currentClients) {
        IndirectClient currentClient = (IndirectClient)currentClients.get(0);
        return currentClient.getRedirectionAction((WebContext)context).get();
    }

    protected HttpAction unauthorized(C context, List<Client<? extends Credentials>> currentClients) {
        return UnauthorizedAction.INSTANCE;
    }

    public ClientFinder getClientFinder() {
        return this.clientFinder;
    }

    public void setClientFinder(ClientFinder clientFinder) {
        this.clientFinder = clientFinder;
    }

    public AuthorizationChecker getAuthorizationChecker() {
        return this.authorizationChecker;
    }

    public void setAuthorizationChecker(AuthorizationChecker authorizationChecker) {
        this.authorizationChecker = authorizationChecker;
    }

    public MatchingChecker getMatchingChecker() {
        return this.matchingChecker;
    }

    public void setMatchingChecker(MatchingChecker matchingChecker) {
        this.matchingChecker = matchingChecker;
    }

    public ProfileStorageDecision getProfileStorageDecision() {
        return this.profileStorageDecision;
    }

    public void setProfileStorageDecision(ProfileStorageDecision profileStorageDecision) {
        this.profileStorageDecision = profileStorageDecision;
    }

    public SavedRequestHandler getSavedRequestHandler() {
        return this.savedRequestHandler;
    }

    public void setSavedRequestHandler(SavedRequestHandler savedRequestHandler) {
        this.savedRequestHandler = savedRequestHandler;
    }

    public String toString() {
        return CommonHelper.toNiceString(this.getClass(), "clientFinder", this.clientFinder, "authorizationChecker", this.authorizationChecker, "matchingChecker", this.matchingChecker, "profileStorageDecision", this.profileStorageDecision, "errorUrl", this.getErrorUrl(), "savedRequestHandler", this.savedRequestHandler);
    }
}

