/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter.rewrite.impl;

import java.util.List;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteEnvironment;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteRuleDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteStepDescriptor;
import org.apache.knox.gateway.filter.rewrite.impl.UrlRewriteStepProcessorHolder;

public class UrlRewriteRuleProcessorHolder
extends UrlRewriteStepProcessorHolder {
    private String ruleName;
    private String scope;

    public void initialize(UrlRewriteEnvironment environment, UrlRewriteRuleDescriptor descriptor) throws Exception {
        super.initialize(environment, (UrlRewriteStepDescriptor)descriptor);
        this.ruleName = descriptor.name();
        if (descriptor.scope() != null) {
            this.scope = descriptor.scope();
        } else {
            List globalRulesServices;
            GatewayConfig gatewayConfig;
            int slashIndex = this.ruleName.indexOf(47);
            if (slashIndex > 0) {
                this.scope = this.ruleName.substring(0, slashIndex);
            }
            if ((gatewayConfig = (GatewayConfig)environment.getAttribute("org.apache.knox.gateway.config")) != null && (globalRulesServices = gatewayConfig.getGlobalRulesServices()).contains(this.scope)) {
                this.scope = "GLOBAL";
            }
        }
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public String getScope() {
        return this.scope;
    }
}

