/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.knox.gateway.filter.AclsAuthorizationMessages;
import org.apache.knox.gateway.filter.InvalidACLException;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.util.IpAddressValidator;

public class AclParser {
    private static AclsAuthorizationMessages log = (AclsAuthorizationMessages)MessagesFactory.get(AclsAuthorizationMessages.class);
    public List<String> users = new ArrayList<String>();
    public List<String> groups = new ArrayList<String>();
    public boolean anyUser = true;
    public boolean anyGroup = true;
    public IpAddressValidator ipv = new IpAddressValidator(null);

    public void parseAcls(String resourceRole, String acls) throws InvalidACLException {
        if (acls != null) {
            String[] parts = acls.split(";");
            if (parts.length != 3) {
                log.invalidAclsFoundForResource(resourceRole);
                throw new InvalidACLException("Invalid ACLs specified for requested resource: " + resourceRole);
            }
            log.aclsFoundForResource(resourceRole);
            this.parseUserAcls(parts);
            this.parseGroupAcls(parts);
            this.parseIpAddressAcls(parts);
        } else {
            log.noAclsFoundForResource(resourceRole);
        }
    }

    private void parseUserAcls(String[] parts) {
        Collections.addAll(this.users, parts[0].split(","));
        if (!this.users.contains("*")) {
            this.anyUser = false;
        }
    }

    private void parseGroupAcls(String[] parts) {
        Collections.addAll(this.groups, parts[1].split(","));
        if (!this.groups.contains("*")) {
            this.anyGroup = false;
        }
    }

    private void parseIpAddressAcls(String[] parts) {
        this.ipv = new IpAddressValidator(parts[2]);
    }
}

