/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.pool;

import java.util.concurrent.TimeUnit;
import org.ldaptive.AbstractConfig;
import org.ldaptive.LdapUtils;

public class PoolConfig
extends AbstractConfig {
    public static final int DEFAULT_MIN_POOL_SIZE = 3;
    public static final int DEFAULT_MAX_POOL_SIZE = 10;
    public static final boolean DEFAULT_VALIDATE_ON_CHECKIN = false;
    public static final boolean DEFAULT_VALIDATE_ON_CHECKOUT = false;
    public static final boolean DEFAULT_VALIDATE_PERIODICALLY = false;
    public static final long DEFAULT_VALIDATE_PERIOD = 1800L;
    public static final long DEFAULT_VALIDATE_TIMEOUT = 5000L;
    private int minPoolSize = 3;
    private int maxPoolSize = 10;
    private boolean validateOnCheckIn = false;
    private boolean validateOnCheckOut = false;
    private boolean validatePeriodically = false;
    private long validatePeriod = 1800L;
    private long validateTimeout = 5000L;

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(int size) {
        this.checkImmutable();
        if (size >= 0) {
            this.logger.trace("setting minPoolSize: {}", (Object)size);
            this.minPoolSize = size;
        }
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int size) {
        this.checkImmutable();
        if (size >= 0) {
            this.logger.trace("setting maxPoolSize: {}", (Object)size);
            this.maxPoolSize = size;
        }
    }

    public boolean isValidateOnCheckIn() {
        return this.validateOnCheckIn;
    }

    public void setValidateOnCheckIn(boolean b) {
        this.checkImmutable();
        this.logger.trace("setting validateOnCheckIn: {}", (Object)b);
        this.validateOnCheckIn = b;
    }

    public boolean isValidateOnCheckOut() {
        return this.validateOnCheckOut;
    }

    public void setValidateOnCheckOut(boolean b) {
        this.checkImmutable();
        this.logger.trace("setting validateOnCheckOut: {}", (Object)b);
        this.validateOnCheckOut = b;
    }

    public boolean isValidatePeriodically() {
        return this.validatePeriodically;
    }

    public void setValidatePeriodically(boolean b) {
        this.checkImmutable();
        this.logger.trace("setting validatePeriodically: {}", (Object)b);
        this.validatePeriodically = b;
    }

    public long getValidatePeriod() {
        return this.validatePeriod;
    }

    public void setValidatePeriod(long time) {
        this.checkImmutable();
        if (time >= 0L) {
            this.logger.trace("setting validatePeriod: {}", (Object)time);
            this.validatePeriod = time;
        }
    }

    public String getValidatePeriodDuration() {
        return LdapUtils.durationEncode(this.validatePeriod, TimeUnit.SECONDS);
    }

    public void setValidatePeriodDuration(String time) {
        this.checkImmutable();
        if (LdapUtils.isDuration(time)) {
            this.setValidatePeriod(LdapUtils.durationDecode(time, TimeUnit.SECONDS));
        } else {
            this.setValidatePeriod(Long.parseLong(time));
        }
    }

    public long getValidateTimeout() {
        return this.validateTimeout;
    }

    public void setValidateTimeout(long time) {
        this.checkImmutable();
        if (time >= -1L) {
            this.logger.trace("setting validateTimeout: {}", (Object)time);
            this.validateTimeout = time;
        }
    }

    public String getValidateTimeoutDuration() {
        return LdapUtils.durationEncode(this.validateTimeout, TimeUnit.MILLISECONDS);
    }

    public void setValidateTimeoutDuration(String time) {
        this.checkImmutable();
        if (LdapUtils.isDuration(time)) {
            this.setValidateTimeout(LdapUtils.durationDecode(time, TimeUnit.MILLISECONDS));
        } else {
            this.setValidateTimeout(Long.parseLong(time));
        }
    }

    public String toString() {
        return String.format("[%s@%d::minPoolSize=%s, maxPoolSize=%s, validateOnCheckIn=%s, validateOnCheckOut=%s, validatePeriodically=%s, validatePeriod=%s, validateTimeout=%s]", this.getClass().getName(), this.hashCode(), this.minPoolSize, this.maxPoolSize, this.validateOnCheckIn, this.validateOnCheckOut, this.validatePeriodically, this.validatePeriod, this.validateTimeout);
    }
}

