/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.i18n.messages.loggers.sout;

import java.text.MessageFormat;
import java.util.Locale;
import org.apache.knox.gateway.i18n.messages.MessageLevel;
import org.apache.knox.gateway.i18n.messages.MessageLogger;

public class SoutMessageLogger
implements MessageLogger {
    private static final String FORMAT_WITHOUT_ID = "{0}: {2}";
    private static final String FORMAT_WITH_ID = "{0}: {2} [{1}]";

    @Override
    public boolean isLoggable(MessageLevel level) {
        return true;
    }

    private static String getFormat(String id) {
        return id == null ? FORMAT_WITHOUT_ID : FORMAT_WITH_ID;
    }

    @Override
    public void log(StackTraceElement caller, MessageLevel level, String id, String message, Throwable thrown) {
        MessageFormat messageFormat = new MessageFormat(SoutMessageLogger.getFormat(id), Locale.ROOT);
        System.out.println(messageFormat.format(new Object[]{level, id, message}));
        if (thrown != null) {
            thrown.printStackTrace();
        }
    }
}

