/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("@angular/cdk/a11y"),require("@angular/cdk/coercion"),require("@angular/cdk/collections"),require("@angular/core"),require("@angular/forms"),require("@angular/material/core")):"function"==typeof define&&define.amd?define(["exports","@angular/cdk/a11y","@angular/cdk/coercion","@angular/cdk/collections","@angular/core","@angular/forms","@angular/material/core"],e):e((t.ng=t.ng||{},t.ng.material=t.ng.material||{},t.ng.material.buttonToggle=t.ng.material.buttonToggle||{}),t.ng.cdk.a11y,t.ng.cdk.coercion,t.ng.cdk.collections,t.ng.core,t.ng.forms,t.ng.material.core)}(this,function(t,e,o,n,r,i,a){"use strict";function l(t,e){function o(){this.constructor=t}u(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}var u=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)e.hasOwnProperty(o)&&(t[o]=e[o])},c=function(){function t(){}return t}(),s=a.mixinDisabled(c),g={provide:i.NG_VALUE_ACCESSOR,useExisting:r.forwardRef(function(){return d}),multi:!0},p=0,h=function(){function t(){}return t}(),d=function(t){function e(e){var o=t.call(this)||this;return o._changeDetector=e,o._controlValueAccessorChangeFn=function(){},o._onTouched=function(){},o._name="mat-button-toggle-group-"+p++,o._vertical=!1,o._value=null,o.valueChange=new r.EventEmitter,o._selected=null,o.change=new r.EventEmitter,o}return l(e,t),Object.defineProperty(e.prototype,"name",{get:function(){return this._name},set:function(t){this._name=t,this._updateButtonToggleNames()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"vertical",{get:function(){return this._vertical},set:function(t){this._vertical=o.coerceBooleanProperty(t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"value",{get:function(){return this._value},set:function(t){this._value!=t&&(this._value=t,this.valueChange.emit(t),this._updateSelectedButtonToggleFromValue())},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"selected",{get:function(){return this._selected},set:function(t){this._selected=t,this.value=t?t.value:null,t&&!t.checked&&(t.checked=!0)},enumerable:!0,configurable:!0}),e.prototype._updateButtonToggleNames=function(){var t=this;this._buttonToggles&&this._buttonToggles.forEach(function(e){e.name=t._name})},e.prototype._updateSelectedButtonToggleFromValue=function(){var t=this,e=null!=this._selected&&this._selected.value==this._value;if(null!=this._buttonToggles&&!e){var o=this._buttonToggles.filter(function(e){return e.value==t._value})[0];o?this.selected=o:null==this.value&&(this.selected=null,this._buttonToggles.forEach(function(t){t.checked=!1}))}},e.prototype._emitChangeEvent=function(){var t=new h;t.source=this._selected,t.value=this._value,this._controlValueAccessorChangeFn(t.value),this.change.emit(t)},e.prototype.writeValue=function(t){this.value=t,this._changeDetector.markForCheck()},e.prototype.registerOnChange=function(t){this._controlValueAccessorChangeFn=t},e.prototype.registerOnTouched=function(t){this._onTouched=t},e.prototype.setDisabledState=function(t){this.disabled=t,this._markButtonTogglesForCheck()},e.prototype._markButtonTogglesForCheck=function(){this._buttonToggles&&this._buttonToggles.forEach(function(t){return t._markForCheck()})},e.decorators=[{type:r.Directive,args:[{selector:"mat-button-toggle-group:not([multiple])",providers:[g],inputs:["disabled"],host:{role:"radiogroup",class:"mat-button-toggle-group","[class.mat-button-toggle-vertical]":"vertical"},exportAs:"matButtonToggleGroup"}]}],e.ctorParameters=function(){return[{type:r.ChangeDetectorRef}]},e.propDecorators={_buttonToggles:[{type:r.ContentChildren,args:[r.forwardRef(function(){return f})]}],name:[{type:r.Input}],vertical:[{type:r.Input}],value:[{type:r.Input}],valueChange:[{type:r.Output}],selected:[{type:r.Input}],change:[{type:r.Output}]},e}(s),b=function(t){function e(){var e=null!==t&&t.apply(this,arguments)||this;return e._vertical=!1,e}return l(e,t),Object.defineProperty(e.prototype,"vertical",{get:function(){return this._vertical},set:function(t){this._vertical=o.coerceBooleanProperty(t)},enumerable:!0,configurable:!0}),e.decorators=[{type:r.Directive,args:[{selector:"mat-button-toggle-group[multiple]",exportAs:"matButtonToggleGroup",inputs:["disabled"],host:{class:"mat-button-toggle-group","[class.mat-button-toggle-vertical]":"vertical",role:"group"}}]}],e.ctorParameters=function(){return[]},e.propDecorators={vertical:[{type:r.Input}]},e}(s),f=function(){function t(t,e,o,n,i,a){var l=this;this._changeDetectorRef=o,this._buttonToggleDispatcher=n,this._elementRef=i,this._focusMonitor=a,this.ariaLabel="",this.ariaLabelledby=null,this._isSingleSelector=!1,this._removeUniqueSelectionListener=function(){},this._checked=!1,this._value=null,this._disabled=!1,this.change=new r.EventEmitter,this.buttonToggleGroup=t,this.buttonToggleGroupMultiple=e,this.buttonToggleGroup?(this._removeUniqueSelectionListener=n.listen(function(t,e){t!=l.id&&e==l.name&&(l.checked=!1,l._changeDetectorRef.markForCheck())}),this._type="radio",this.name=this.buttonToggleGroup.name,this._isSingleSelector=!0):(this._type="checkbox",this._isSingleSelector=!1)}return Object.defineProperty(t.prototype,"inputId",{get:function(){return this.id+"-input"},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"checked",{get:function(){return this._checked},set:function(t){this._isSingleSelector&&t&&(this._buttonToggleDispatcher.notify(this.id,this.name),this._changeDetectorRef.markForCheck()),this._checked=t,t&&this._isSingleSelector&&this.buttonToggleGroup.value!=this.value&&(this.buttonToggleGroup.selected=this)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"value",{get:function(){return this._value},set:function(t){this._value!=t&&(null!=this.buttonToggleGroup&&this.checked&&(this.buttonToggleGroup.value=t),this._value=t)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"disabled",{get:function(){return this._disabled||null!=this.buttonToggleGroup&&this.buttonToggleGroup.disabled||null!=this.buttonToggleGroupMultiple&&this.buttonToggleGroupMultiple.disabled},set:function(t){this._disabled=o.coerceBooleanProperty(t)},enumerable:!0,configurable:!0}),t.prototype.ngOnInit=function(){null==this.id&&(this.id="mat-button-toggle-"+p++),this.buttonToggleGroup&&this._value==this.buttonToggleGroup.value&&(this._checked=!0),this._focusMonitor.monitor(this._elementRef.nativeElement,!0)},t.prototype.focus=function(){this._inputElement.nativeElement.focus()},t.prototype._toggle=function(){this.checked=!this.checked},t.prototype._onInputChange=function(t){if(t.stopPropagation(),this._isSingleSelector){var e=this.buttonToggleGroup.selected!=this;this.checked=!0,this.buttonToggleGroup.selected=this,this.buttonToggleGroup._onTouched(),e&&this.buttonToggleGroup._emitChangeEvent()}else this._toggle();this._emitChangeEvent()},t.prototype._onInputClick=function(t){t.stopPropagation()},t.prototype._emitChangeEvent=function(){var t=new h;t.source=this,t.value=this._value,this.change.emit(t)},t.prototype.ngOnDestroy=function(){this._removeUniqueSelectionListener()},t.prototype._markForCheck=function(){this._changeDetectorRef.markForCheck()},t.decorators=[{type:r.Component,args:[{selector:"mat-button-toggle",template:'<label [attr.for]="inputId" class="mat-button-toggle-label"><input #input class="mat-button-toggle-input cdk-visually-hidden" [type]="_type" [id]="inputId" [checked]="checked" [disabled]="disabled || null" [attr.name]="name" [attr.aria-label]="ariaLabel" [attr.aria-labelledby]="ariaLabelledby" (change)="_onInputChange($event)" (click)="_onInputClick($event)"><div class="mat-button-toggle-label-content"><ng-content></ng-content></div></label><div class="mat-button-toggle-focus-overlay"></div>',styles:[".mat-button-toggle-group,.mat-button-toggle-standalone{box-shadow:0 3px 1px -2px rgba(0,0,0,.2),0 2px 2px 0 rgba(0,0,0,.14),0 1px 5px 0 rgba(0,0,0,.12);position:relative;display:inline-flex;flex-direction:row;border-radius:2px;cursor:pointer;white-space:nowrap;overflow:hidden}.mat-button-toggle-vertical{flex-direction:column}.mat-button-toggle-vertical .mat-button-toggle-label-content{display:block}.mat-button-toggle-disabled .mat-button-toggle-label-content{cursor:default}.mat-button-toggle{white-space:nowrap;position:relative}.mat-button-toggle.cdk-keyboard-focused .mat-button-toggle-focus-overlay,.mat-button-toggle.cdk-program-focused .mat-button-toggle-focus-overlay{opacity:1}.mat-button-toggle-label-content{-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;display:inline-block;line-height:36px;padding:0 16px;cursor:pointer}.mat-button-toggle-label-content>*{vertical-align:middle}.mat-button-toggle-focus-overlay{border-radius:inherit;pointer-events:none;opacity:0;top:0;left:0;right:0;bottom:0;position:absolute}"],encapsulation:r.ViewEncapsulation.None,preserveWhitespaces:!1,exportAs:"matButtonToggle",changeDetection:r.ChangeDetectionStrategy.OnPush,host:{"[class.mat-button-toggle-standalone]":"!buttonToggleGroup && !buttonToggleGroupMultiple","[class.mat-button-toggle-checked]":"checked","[class.mat-button-toggle-disabled]":"disabled",class:"mat-button-toggle","[attr.id]":"id"}}]}],t.ctorParameters=function(){return[{type:d,decorators:[{type:r.Optional}]},{type:b,decorators:[{type:r.Optional}]},{type:r.ChangeDetectorRef},{type:n.UniqueSelectionDispatcher},{type:r.ElementRef},{type:e.FocusMonitor}]},t.propDecorators={ariaLabel:[{type:r.Input,args:["aria-label"]}],ariaLabelledby:[{type:r.Input,args:["aria-labelledby"]}],_inputElement:[{type:r.ViewChild,args:["input"]}],id:[{type:r.Input}],name:[{type:r.Input}],checked:[{type:r.Input}],value:[{type:r.Input}],disabled:[{type:r.Input}],change:[{type:r.Output}]},t}(),m=function(){function t(){}return t.decorators=[{type:r.NgModule,args:[{imports:[a.MatCommonModule,e.A11yModule],exports:[d,b,f,a.MatCommonModule],declarations:[d,b,f],providers:[n.UNIQUE_SELECTION_DISPATCHER_PROVIDER]}]}],t.ctorParameters=function(){return[]},t}();t.MatButtonToggleGroupBase=c,t._MatButtonToggleGroupMixinBase=s,t.MAT_BUTTON_TOGGLE_GROUP_VALUE_ACCESSOR=g,t.MatButtonToggleChange=h,t.MatButtonToggleGroup=d,t.MatButtonToggleGroupMultiple=b,t.MatButtonToggle=f,t.MatButtonToggleModule=m,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=material-button-toggle.umd.min.js.map
