/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.ambari;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONValue;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.apache.knox.gateway.config.ConfigurationException;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;
import org.apache.knox.gateway.topology.discovery.ambari.AmbariServiceDiscoveryMessages;

class RESTInvoker {
    private static final String DEFAULT_USER_ALIAS = "ambari.discovery.user";
    private static final String DEFAULT_PWD_ALIAS = "ambari.discovery.password";
    private static final AmbariServiceDiscoveryMessages log = (AmbariServiceDiscoveryMessages)MessagesFactory.get(AmbariServiceDiscoveryMessages.class);
    private static final int DEFAULT_TIMEOUT = 10000;
    private AliasService aliasService;
    private CloseableHttpClient httpClient;

    RESTInvoker(AliasService aliasService) {
        this(null, aliasService);
    }

    RESTInvoker(GatewayConfig config, AliasService aliasService) {
        this.aliasService = aliasService;
        this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(RESTInvoker.getRequestConfig(config)).build();
    }

    private static RequestConfig getRequestConfig(GatewayConfig config) {
        RequestConfig.Builder builder = RequestConfig.custom();
        if (config != null) {
            builder.setConnectTimeout(config.getHttpClientConnectionTimeout()).setConnectionRequestTimeout(config.getHttpClientConnectionTimeout()).setSocketTimeout(config.getHttpClientSocketTimeout());
        } else {
            builder.setConnectTimeout(10000).setConnectionRequestTimeout(10000).setSocketTimeout(10000);
        }
        return builder.build();
    }

    JSONObject invoke(String url, String username, String passwordAlias) {
        JSONObject result = null;
        try {
            HttpGet request = new HttpGet(url);
            String password = null;
            if (username == null) {
                if (this.aliasService != null) {
                    try {
                        char[] defaultUser = this.aliasService.getPasswordFromAliasForGateway(DEFAULT_USER_ALIAS);
                        if (defaultUser != null) {
                            username = new String(defaultUser);
                        }
                    }
                    catch (AliasServiceException e) {
                        log.aliasServiceUserError(DEFAULT_USER_ALIAS, e.getLocalizedMessage());
                    }
                }
                if (username == null) {
                    log.aliasServiceUserNotFound();
                    throw new ConfigurationException("No username is configured for Ambari service discovery.");
                }
            }
            if (this.aliasService != null) {
                if (passwordAlias == null) {
                    passwordAlias = DEFAULT_PWD_ALIAS;
                }
                try {
                    char[] pwd = this.aliasService.getPasswordFromAliasForGateway(passwordAlias);
                    if (pwd != null) {
                        password = new String(pwd);
                    }
                }
                catch (AliasServiceException e) {
                    log.aliasServicePasswordError(passwordAlias, e.getLocalizedMessage());
                }
            }
            if (password == null) {
                log.aliasServicePasswordNotFound();
                throw new ConfigurationException("No password is configured for Ambari service discovery.");
            }
            String encodedCreds = Base64.getEncoder().encodeToString((username + ":" + password).getBytes(StandardCharsets.UTF_8));
            request.addHeader((Header)new BasicHeader("Authorization", "Basic " + encodedCreds));
            request.addHeader("X-Requested-By", "Knox");
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);){
                if (200 == response.getStatusLine().getStatusCode()) {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        result = (JSONObject)JSONValue.parse((String)EntityUtils.toString((HttpEntity)entity));
                        log.debugJSON(result.toJSONString());
                    } else {
                        log.noJSON(url);
                    }
                } else {
                    log.unexpectedRestResponseStatusCode(url, response.getStatusLine().getStatusCode());
                }
            }
        }
        catch (ConnectTimeoutException e) {
            log.restInvocationTimedOut(url, (Exception)((Object)e));
        }
        catch (IOException e) {
            log.restInvocationError(url, e);
        }
        return result;
    }
}

