/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.trigger;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.directory.api.ldap.model.constants.SchemaConstants;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapOperationErrorException;
import org.apache.directory.api.ldap.model.exception.LdapOtherException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.NormalizerMappingResolver;
import org.apache.directory.api.ldap.model.schema.normalizers.OidNormalizer;
import org.apache.directory.api.ldap.trigger.ActionTime;
import org.apache.directory.api.ldap.trigger.LdapOperation;
import org.apache.directory.api.ldap.trigger.TriggerSpecification;
import org.apache.directory.api.ldap.trigger.TriggerSpecificationParser;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.InterceptorEnum;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.interceptor.BaseInterceptor;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.OperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.sp.StoredProcEngine;
import org.apache.directory.server.core.api.sp.StoredProcExecutionManager;
import org.apache.directory.server.core.api.sp.java.JavaStoredProcEngineConfig;
import org.apache.directory.server.core.api.subtree.SubentryUtils;
import org.apache.directory.server.core.trigger.AddStoredProcedureParameterInjector;
import org.apache.directory.server.core.trigger.DeleteStoredProcedureParameterInjector;
import org.apache.directory.server.core.trigger.ModifyDNStoredProcedureParameterInjector;
import org.apache.directory.server.core.trigger.ModifyStoredProcedureParameterInjector;
import org.apache.directory.server.core.trigger.SimpleTriggerExecutionAuthorizer;
import org.apache.directory.server.core.trigger.StoredProcedureParameterInjector;
import org.apache.directory.server.core.trigger.TriggerExecutionAuthorizer;
import org.apache.directory.server.core.trigger.TriggerSpecCache;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(TriggerInterceptor.class);
    private static final String ENTRY_TRIGGER_ATTR = "entryTriggerSpecification";
    private TriggerSpecCache triggerSpecCache;
    private TriggerSpecificationParser triggerParser;
    private boolean enabled = true;
    private TriggerExecutionAuthorizer triggerExecutionAuthorizer = new SimpleTriggerExecutionAuthorizer();
    private StoredProcExecutionManager manager;
    private static SubentryUtils subentryUtils;

    public TriggerInterceptor() {
        super(InterceptorEnum.TRIGGER_INTERCEPTOR);
    }

    private void addPrescriptiveTriggerSpecs(OperationContext opContext, List<TriggerSpecification> triggerSpecs, Dn dn, Entry entry) throws LdapException {
        Attribute subentries;
        if (entry.contains(this.directoryService.getAtProvider().getObjectClass(), new String[]{"subentry"})) {
            Dn parentDn = dn.getParent();
            CoreSession session = opContext.getSession();
            LookupOperationContext lookupContext = new LookupOperationContext(session, parentDn, SchemaConstants.ALL_ATTRIBUTES_ARRAY);
            lookupContext.setPartition(opContext.getPartition());
            lookupContext.setTransaction(opContext.getTransaction());
            entry = this.directoryService.getPartitionNexus().lookup(lookupContext);
        }
        if ((subentries = entry.get("triggerExecutionSubentries")) == null) {
            return;
        }
        for (Value value : subentries) {
            Dn subentryDn = new Dn(this.directoryService.getSchemaManager(), new String[]{value.getValue()});
            triggerSpecs.addAll(this.triggerSpecCache.getSubentryTriggerSpecs(subentryDn));
        }
    }

    private void addEntryTriggerSpecs(List<TriggerSpecification> triggerSpecs, Entry entry) throws LdapException {
        Attribute entryTrigger = entry.get(ENTRY_TRIGGER_ATTR);
        if (entryTrigger == null) {
            return;
        }
        for (Value value : entryTrigger) {
            TriggerSpecification item;
            String triggerString = value.getValue();
            try {
                item = this.triggerParser.parse(triggerString);
            }
            catch (ParseException e) {
                String msg = I18n.err((I18n)I18n.ERR_72, (Object[])new Object[]{triggerString});
                LOG.error(msg, (Throwable)e);
                throw new LdapOperationErrorException(msg);
            }
            triggerSpecs.add(item);
        }
    }

    public Map<ActionTime, List<TriggerSpecification>> getActionTimeMappedTriggerSpecsForOperation(List<TriggerSpecification> triggerSpecs, LdapOperation ldapOperation) {
        ArrayList<TriggerSpecification> afterTriggerSpecs = new ArrayList<TriggerSpecification>();
        HashMap<ActionTime, List<TriggerSpecification>> triggerSpecMap = new HashMap<ActionTime, List<TriggerSpecification>>();
        for (TriggerSpecification triggerSpec : triggerSpecs) {
            if (!triggerSpec.getLdapOperation().equals((Object)ldapOperation) || !triggerSpec.getActionTime().equals((Object)ActionTime.AFTER)) continue;
            afterTriggerSpecs.add(triggerSpec);
        }
        triggerSpecMap.put(ActionTime.AFTER, afterTriggerSpecs);
        return triggerSpecMap;
    }

    public void init(DirectoryService directoryService) throws LdapException {
        super.init(directoryService);
        this.triggerSpecCache = new TriggerSpecCache(directoryService);
        this.triggerParser = new TriggerSpecificationParser(new NormalizerMappingResolver(){

            public Map<String, OidNormalizer> getNormalizerMapping() throws Exception {
                return TriggerInterceptor.this.schemaManager.getNormalizerMapping();
            }
        });
        JavaStoredProcEngineConfig javaSPEngineConfig = new JavaStoredProcEngineConfig();
        ArrayList<JavaStoredProcEngineConfig> spEngineConfigs = new ArrayList<JavaStoredProcEngineConfig>();
        spEngineConfigs.add(javaSPEngineConfig);
        String spContainer = "ou=Stored Procedures,ou=system";
        this.manager = new StoredProcExecutionManager(spContainer, spEngineConfigs);
        this.enabled = true;
        subentryUtils = new SubentryUtils(directoryService);
    }

    public void add(AddOperationContext addContext) throws LdapException {
        Dn name = addContext.getDn();
        Entry entry = addContext.getEntry();
        if (!this.enabled) {
            this.next(addContext);
            return;
        }
        AddStoredProcedureParameterInjector injector = new AddStoredProcedureParameterInjector((OperationContext)addContext, name, entry);
        ArrayList<TriggerSpecification> triggerSpecs = new ArrayList<TriggerSpecification>();
        this.addPrescriptiveTriggerSpecs((OperationContext)addContext, triggerSpecs, name, entry);
        Map<ActionTime, List<TriggerSpecification>> triggerMap = this.getActionTimeMappedTriggerSpecsForOperation(triggerSpecs, LdapOperation.ADD);
        this.next(addContext);
        this.triggerSpecCache.subentryAdded(name, entry);
        List<TriggerSpecification> afterTriggerSpecs = triggerMap.get(ActionTime.AFTER);
        this.executeTriggers((OperationContext)addContext, afterTriggerSpecs, injector);
    }

    public void delete(DeleteOperationContext deleteContext) throws LdapException {
        Dn name = deleteContext.getDn();
        if (!this.enabled) {
            this.next(deleteContext);
            return;
        }
        Entry deletedEntry = deleteContext.getEntry();
        DeleteStoredProcedureParameterInjector injector = new DeleteStoredProcedureParameterInjector((OperationContext)deleteContext, name);
        ArrayList<TriggerSpecification> triggerSpecs = new ArrayList<TriggerSpecification>();
        this.addPrescriptiveTriggerSpecs((OperationContext)deleteContext, triggerSpecs, name, deletedEntry);
        this.addEntryTriggerSpecs(triggerSpecs, deletedEntry);
        Map<ActionTime, List<TriggerSpecification>> triggerMap = this.getActionTimeMappedTriggerSpecsForOperation(triggerSpecs, LdapOperation.DELETE);
        this.next(deleteContext);
        this.triggerSpecCache.subentryDeleted(name, deletedEntry);
        List<TriggerSpecification> afterTriggerSpecs = triggerMap.get(ActionTime.AFTER);
        this.executeTriggers((OperationContext)deleteContext, afterTriggerSpecs, injector);
    }

    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        if (!this.enabled) {
            this.next(modifyContext);
            return;
        }
        Dn normName = modifyContext.getDn();
        Entry originalEntry = modifyContext.getEntry();
        ModifyStoredProcedureParameterInjector injector = new ModifyStoredProcedureParameterInjector(modifyContext);
        ArrayList<TriggerSpecification> triggerSpecs = new ArrayList<TriggerSpecification>();
        this.addPrescriptiveTriggerSpecs((OperationContext)modifyContext, triggerSpecs, normName, originalEntry);
        this.addEntryTriggerSpecs(triggerSpecs, originalEntry);
        Map<ActionTime, List<TriggerSpecification>> triggerMap = this.getActionTimeMappedTriggerSpecsForOperation(triggerSpecs, LdapOperation.MODIFY);
        this.next(modifyContext);
        this.triggerSpecCache.subentryModified(modifyContext, originalEntry);
        List<TriggerSpecification> afterTriggerSpecs = triggerMap.get(ActionTime.AFTER);
        this.executeTriggers((OperationContext)modifyContext, afterTriggerSpecs, injector);
    }

    public void move(MoveOperationContext moveContext) throws LdapException {
        if (!this.enabled) {
            this.next(moveContext);
            return;
        }
        Rdn rdn = moveContext.getRdn();
        Dn dn = moveContext.getDn();
        Dn newDn = moveContext.getNewDn();
        Dn oldSuperior = moveContext.getOldSuperior();
        Dn newSuperior = moveContext.getNewSuperior();
        Entry movedEntry = moveContext.getOriginalEntry();
        ModifyDNStoredProcedureParameterInjector injector = new ModifyDNStoredProcedureParameterInjector((OperationContext)moveContext, false, rdn, rdn, oldSuperior, newSuperior, dn, newDn);
        ArrayList<TriggerSpecification> exportTriggerSpecs = new ArrayList<TriggerSpecification>();
        this.addPrescriptiveTriggerSpecs((OperationContext)moveContext, exportTriggerSpecs, dn, movedEntry);
        this.addEntryTriggerSpecs(exportTriggerSpecs, movedEntry);
        CoreSession session = moveContext.getSession();
        LookupOperationContext lookupContext = new LookupOperationContext(session, dn, SchemaConstants.ALL_USER_ATTRIBUTES_ARRAY);
        lookupContext.setPartition(moveContext.getPartition());
        lookupContext.setTransaction(moveContext.getTransaction());
        Entry importedEntry = this.directoryService.getPartitionNexus().lookup(lookupContext);
        Entry fakeImportedEntry = subentryUtils.getSubentryAttributes(newDn, importedEntry);
        for (Attribute attribute : importedEntry) {
            fakeImportedEntry.put(new Attribute[]{attribute});
        }
        ArrayList<TriggerSpecification> importTriggerSpecs = new ArrayList<TriggerSpecification>();
        this.addPrescriptiveTriggerSpecs((OperationContext)moveContext, importTriggerSpecs, newDn, fakeImportedEntry);
        Map<ActionTime, List<TriggerSpecification>> exportTriggerMap = this.getActionTimeMappedTriggerSpecsForOperation(exportTriggerSpecs, LdapOperation.MODIFYDN_EXPORT);
        Map<ActionTime, List<TriggerSpecification>> importTriggerMap = this.getActionTimeMappedTriggerSpecsForOperation(importTriggerSpecs, LdapOperation.MODIFYDN_IMPORT);
        this.next(moveContext);
        this.triggerSpecCache.subentryRenamed(dn, newDn);
        List<TriggerSpecification> afterExportTriggerSpecs = exportTriggerMap.get(ActionTime.AFTER);
        List<TriggerSpecification> afterImportTriggerSpecs = importTriggerMap.get(ActionTime.AFTER);
        this.executeTriggers((OperationContext)moveContext, afterExportTriggerSpecs, injector);
        this.executeTriggers((OperationContext)moveContext, afterImportTriggerSpecs, injector);
    }

    public void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        Dn oldDn = moveAndRenameContext.getDn();
        Dn newSuperiorDn = moveAndRenameContext.getNewSuperiorDn();
        Rdn newRdn = moveAndRenameContext.getNewRdn();
        boolean deleteOldRn = moveAndRenameContext.getDeleteOldRdn();
        if (!this.enabled) {
            this.next(moveAndRenameContext);
            return;
        }
        Entry movedEntry = moveAndRenameContext.getOriginalEntry();
        Rdn oldRdn = oldDn.getRdn();
        Dn oldSuperiorDn = oldDn.getParent();
        Dn oldDN = oldDn;
        Dn newDn = moveAndRenameContext.getNewDn();
        ModifyDNStoredProcedureParameterInjector injector = new ModifyDNStoredProcedureParameterInjector((OperationContext)moveAndRenameContext, deleteOldRn, oldRdn, newRdn, oldSuperiorDn, newSuperiorDn, oldDN, newDn);
        ArrayList<TriggerSpecification> exportTriggerSpecs = new ArrayList<TriggerSpecification>();
        this.addPrescriptiveTriggerSpecs((OperationContext)moveAndRenameContext, exportTriggerSpecs, oldDn, movedEntry);
        this.addEntryTriggerSpecs(exportTriggerSpecs, movedEntry);
        CoreSession session = moveAndRenameContext.getSession();
        LookupOperationContext lookupContext = new LookupOperationContext(session, oldDn, SchemaConstants.ALL_USER_ATTRIBUTES_ARRAY);
        lookupContext.setPartition(moveAndRenameContext.getPartition());
        lookupContext.setTransaction(moveAndRenameContext.getTransaction());
        Entry importedEntry = this.directoryService.getPartitionNexus().lookup(lookupContext);
        Entry fakeImportedEntry = subentryUtils.getSubentryAttributes(newDn, importedEntry);
        for (Attribute attribute : importedEntry) {
            fakeImportedEntry.put(new Attribute[]{attribute});
        }
        ArrayList<TriggerSpecification> importTriggerSpecs = new ArrayList<TriggerSpecification>();
        this.addPrescriptiveTriggerSpecs((OperationContext)moveAndRenameContext, importTriggerSpecs, newDn, fakeImportedEntry);
        Map<ActionTime, List<TriggerSpecification>> exportTriggerMap = this.getActionTimeMappedTriggerSpecsForOperation(exportTriggerSpecs, LdapOperation.MODIFYDN_EXPORT);
        Map<ActionTime, List<TriggerSpecification>> importTriggerMap = this.getActionTimeMappedTriggerSpecsForOperation(importTriggerSpecs, LdapOperation.MODIFYDN_IMPORT);
        this.next(moveAndRenameContext);
        this.triggerSpecCache.subentryRenamed(oldDN, newDn);
        List<TriggerSpecification> afterExportTriggerSpecs = exportTriggerMap.get(ActionTime.AFTER);
        List<TriggerSpecification> afterImportTriggerSpecs = importTriggerMap.get(ActionTime.AFTER);
        this.executeTriggers((OperationContext)moveAndRenameContext, afterExportTriggerSpecs, injector);
        this.executeTriggers((OperationContext)moveAndRenameContext, afterImportTriggerSpecs, injector);
    }

    public void rename(RenameOperationContext renameContext) throws LdapException {
        Dn oldSuperiorDn;
        Dn name = renameContext.getDn();
        Rdn newRdn = renameContext.getNewRdn();
        boolean deleteOldRn = renameContext.getDeleteOldRdn();
        if (!this.enabled) {
            this.next(renameContext);
            return;
        }
        Entry renamedEntry = ((ClonedServerEntry)renameContext.getEntry()).getClonedEntry();
        Rdn oldRdn = name.getRdn();
        Dn newSuperiorDn = oldSuperiorDn = name.getParent();
        Dn oldDn = name;
        Dn newDn = name;
        newDn = newDn.add(newRdn);
        ModifyDNStoredProcedureParameterInjector injector = new ModifyDNStoredProcedureParameterInjector((OperationContext)renameContext, deleteOldRn, oldRdn, newRdn, oldSuperiorDn, newSuperiorDn, oldDn, newDn);
        ArrayList<TriggerSpecification> triggerSpecs = new ArrayList<TriggerSpecification>();
        this.addPrescriptiveTriggerSpecs((OperationContext)renameContext, triggerSpecs, name, renamedEntry);
        this.addEntryTriggerSpecs(triggerSpecs, renamedEntry);
        Map<ActionTime, List<TriggerSpecification>> triggerMap = this.getActionTimeMappedTriggerSpecsForOperation(triggerSpecs, LdapOperation.MODIFYDN_RENAME);
        this.next(renameContext);
        this.triggerSpecCache.subentryRenamed(name, newDn);
        List<TriggerSpecification> afterTriggerSpecs = triggerMap.get(ActionTime.AFTER);
        this.executeTriggers((OperationContext)renameContext, afterTriggerSpecs, injector);
    }

    private Object executeTriggers(OperationContext opContext, List<TriggerSpecification> triggerSpecs, StoredProcedureParameterInjector injector) throws LdapException {
        Object result = null;
        for (TriggerSpecification triggerSpec : triggerSpecs) {
            if (!this.triggerExecutionAuthorizer.hasPermission(opContext)) continue;
            result = this.executeTrigger(opContext, triggerSpec, injector);
        }
        return result;
    }

    private Object executeTrigger(OperationContext opContext, TriggerSpecification tsec, StoredProcedureParameterInjector injector) throws LdapException {
        ArrayList<Object> returnValues = new ArrayList<Object>();
        List spSpecs = tsec.getSPSpecs();
        for (TriggerSpecification.SPSpec spSpec : spSpecs) {
            ArrayList<Object> arguments = new ArrayList<Object>();
            arguments.addAll(injector.getArgumentsToInject(opContext, spSpec.getParameters()));
            Object[] values = arguments.toArray();
            Object returnValue = this.executeProcedure(opContext, spSpec.getName(), values);
            returnValues.add(returnValue);
        }
        return returnValues;
    }

    private Object executeProcedure(OperationContext opContext, String procedure, Object[] values) throws LdapException {
        try {
            Entry spUnit = this.manager.findStoredProcUnit(opContext.getSession(), procedure);
            StoredProcEngine engine = this.manager.getStoredProcEngineInstance(spUnit);
            return engine.invokeProcedure(opContext.getSession(), procedure, values);
        }
        catch (Exception e) {
            LdapOtherException lne = new LdapOtherException(e.getMessage(), (Throwable)e);
            lne.initCause((Throwable)e);
            throw lne;
        }
    }
}

