/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiHdfsReplicationResult;
import com.cloudera.api.swagger.model.ApiHiveReplicationError;
import com.cloudera.api.swagger.model.ApiHiveTable;
import com.cloudera.api.swagger.model.ApiHiveUDF;
import com.cloudera.api.swagger.model.ApiImpalaUDF;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Detailed information about a Hive replication job.")
public class ApiHiveReplicationResult {
    @SerializedName(value="phase")
    private String phase = null;
    @SerializedName(value="tableCount")
    private BigDecimal tableCount = null;
    @SerializedName(value="tables")
    private List<ApiHiveTable> tables = null;
    @SerializedName(value="impalaUDFCount")
    private BigDecimal impalaUDFCount = null;
    @SerializedName(value="hiveUDFCount")
    private BigDecimal hiveUDFCount = null;
    @SerializedName(value="impalaUDFs")
    private List<ApiImpalaUDF> impalaUDFs = null;
    @SerializedName(value="hiveUDFs")
    private List<ApiHiveUDF> hiveUDFs = null;
    @SerializedName(value="errorCount")
    private BigDecimal errorCount = null;
    @SerializedName(value="errors")
    private List<ApiHiveReplicationError> errors = null;
    @SerializedName(value="dataReplicationResult")
    private ApiHdfsReplicationResult dataReplicationResult = null;
    @SerializedName(value="dryRun")
    private Boolean dryRun = null;
    @SerializedName(value="runAsUser")
    private String runAsUser = null;
    @SerializedName(value="runOnSourceAsUser")
    private String runOnSourceAsUser = null;
    @SerializedName(value="statsAvailable")
    private Boolean statsAvailable = null;
    @SerializedName(value="dbProcessed")
    private BigDecimal dbProcessed = null;
    @SerializedName(value="tableProcessed")
    private BigDecimal tableProcessed = null;
    @SerializedName(value="partitionProcessed")
    private BigDecimal partitionProcessed = null;
    @SerializedName(value="functionProcessed")
    private BigDecimal functionProcessed = null;
    @SerializedName(value="indexProcessed")
    private BigDecimal indexProcessed = null;
    @SerializedName(value="statsProcessed")
    private BigDecimal statsProcessed = null;
    @SerializedName(value="dbExpected")
    private BigDecimal dbExpected = null;
    @SerializedName(value="tableExpected")
    private BigDecimal tableExpected = null;
    @SerializedName(value="partitionExpected")
    private BigDecimal partitionExpected = null;
    @SerializedName(value="functionExpected")
    private BigDecimal functionExpected = null;
    @SerializedName(value="indexExpected")
    private BigDecimal indexExpected = null;
    @SerializedName(value="statsExpected")
    private BigDecimal statsExpected = null;

    public ApiHiveReplicationResult phase(String phase) {
        this.phase = phase;
        return this;
    }

    @ApiModelProperty(value="Phase the replication is in. <p/> If the replication job is still active, this will contain a string describing the current phase. This will be one of: EXPORT, DATA or IMPORT, for, respectively, exporting the source metastore information, replicating table data (if configured), and importing metastore information in the target. <p/> This value will not be present if the replication is not active. <p/> Available since API v4.")
    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public ApiHiveReplicationResult tableCount(BigDecimal tableCount) {
        this.tableCount = tableCount;
        return this;
    }

    @ApiModelProperty(value="Number of tables that were successfully replicated. Available since API v4.")
    public BigDecimal getTableCount() {
        return this.tableCount;
    }

    public void setTableCount(BigDecimal tableCount) {
        this.tableCount = tableCount;
    }

    public ApiHiveReplicationResult tables(List<ApiHiveTable> tables) {
        this.tables = tables;
        return this;
    }

    public ApiHiveReplicationResult addTablesItem(ApiHiveTable tablesItem) {
        if (this.tables == null) {
            this.tables = new ArrayList<ApiHiveTable>();
        }
        this.tables.add(tablesItem);
        return this;
    }

    @ApiModelProperty(value="The list of tables successfully replicated. <p/> Since API v4, this is only available in the full view.")
    public List<ApiHiveTable> getTables() {
        return this.tables;
    }

    public void setTables(List<ApiHiveTable> tables) {
        this.tables = tables;
    }

    public ApiHiveReplicationResult impalaUDFCount(BigDecimal impalaUDFCount) {
        this.impalaUDFCount = impalaUDFCount;
        return this;
    }

    @ApiModelProperty(value="Number of impala UDFs that were successfully replicated. Available since API v6.")
    public BigDecimal getImpalaUDFCount() {
        return this.impalaUDFCount;
    }

    public void setImpalaUDFCount(BigDecimal impalaUDFCount) {
        this.impalaUDFCount = impalaUDFCount;
    }

    public ApiHiveReplicationResult hiveUDFCount(BigDecimal hiveUDFCount) {
        this.hiveUDFCount = hiveUDFCount;
        return this;
    }

    @ApiModelProperty(value="Number of hive UDFs that were successfully replicated. Available since API v14.")
    public BigDecimal getHiveUDFCount() {
        return this.hiveUDFCount;
    }

    public void setHiveUDFCount(BigDecimal hiveUDFCount) {
        this.hiveUDFCount = hiveUDFCount;
    }

    public ApiHiveReplicationResult impalaUDFs(List<ApiImpalaUDF> impalaUDFs) {
        this.impalaUDFs = impalaUDFs;
        return this;
    }

    public ApiHiveReplicationResult addImpalaUDFsItem(ApiImpalaUDF impalaUDFsItem) {
        if (this.impalaUDFs == null) {
            this.impalaUDFs = new ArrayList<ApiImpalaUDF>();
        }
        this.impalaUDFs.add(impalaUDFsItem);
        return this;
    }

    @ApiModelProperty(value="The list of Impala UDFs successfully replicated. Available since API v6 in the full view.")
    public List<ApiImpalaUDF> getImpalaUDFs() {
        return this.impalaUDFs;
    }

    public void setImpalaUDFs(List<ApiImpalaUDF> impalaUDFs) {
        this.impalaUDFs = impalaUDFs;
    }

    public ApiHiveReplicationResult hiveUDFs(List<ApiHiveUDF> hiveUDFs) {
        this.hiveUDFs = hiveUDFs;
        return this;
    }

    public ApiHiveReplicationResult addHiveUDFsItem(ApiHiveUDF hiveUDFsItem) {
        if (this.hiveUDFs == null) {
            this.hiveUDFs = new ArrayList<ApiHiveUDF>();
        }
        this.hiveUDFs.add(hiveUDFsItem);
        return this;
    }

    @ApiModelProperty(value="The list of Impala UDFs successfully replicated. Available since API v6 in the full view.")
    public List<ApiHiveUDF> getHiveUDFs() {
        return this.hiveUDFs;
    }

    public void setHiveUDFs(List<ApiHiveUDF> hiveUDFs) {
        this.hiveUDFs = hiveUDFs;
    }

    public ApiHiveReplicationResult errorCount(BigDecimal errorCount) {
        this.errorCount = errorCount;
        return this;
    }

    @ApiModelProperty(value="Number of errors detected during replication job. Available since API v4.")
    public BigDecimal getErrorCount() {
        return this.errorCount;
    }

    public void setErrorCount(BigDecimal errorCount) {
        this.errorCount = errorCount;
    }

    public ApiHiveReplicationResult errors(List<ApiHiveReplicationError> errors) {
        this.errors = errors;
        return this;
    }

    public ApiHiveReplicationResult addErrorsItem(ApiHiveReplicationError errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<ApiHiveReplicationError>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    @ApiModelProperty(value="List of errors encountered during replication. <p/> Since API v4, this is only available in the full view.")
    public List<ApiHiveReplicationError> getErrors() {
        return this.errors;
    }

    public void setErrors(List<ApiHiveReplicationError> errors) {
        this.errors = errors;
    }

    public ApiHiveReplicationResult dataReplicationResult(ApiHdfsReplicationResult dataReplicationResult) {
        this.dataReplicationResult = dataReplicationResult;
        return this;
    }

    @ApiModelProperty(value="Result of table data replication, if performed.")
    public ApiHdfsReplicationResult getDataReplicationResult() {
        return this.dataReplicationResult;
    }

    public void setDataReplicationResult(ApiHdfsReplicationResult dataReplicationResult) {
        this.dataReplicationResult = dataReplicationResult;
    }

    public ApiHiveReplicationResult dryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    @ApiModelProperty(value="Whether this was a dry run.")
    public Boolean getDryRun() {
        return this.dryRun;
    }

    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    public ApiHiveReplicationResult runAsUser(String runAsUser) {
        this.runAsUser = runAsUser;
        return this;
    }

    @ApiModelProperty(value="Name of the of proxy user, if any. Available since API v11.")
    public String getRunAsUser() {
        return this.runAsUser;
    }

    public void setRunAsUser(String runAsUser) {
        this.runAsUser = runAsUser;
    }

    public ApiHiveReplicationResult runOnSourceAsUser(String runOnSourceAsUser) {
        this.runOnSourceAsUser = runOnSourceAsUser;
        return this;
    }

    @ApiModelProperty(value="Name of the source proxy user, if any. Available since API v18.")
    public String getRunOnSourceAsUser() {
        return this.runOnSourceAsUser;
    }

    public void setRunOnSourceAsUser(String runOnSourceAsUser) {
        this.runOnSourceAsUser = runOnSourceAsUser;
    }

    public ApiHiveReplicationResult statsAvailable(Boolean statsAvailable) {
        this.statsAvailable = statsAvailable;
        return this;
    }

    @ApiModelProperty(value="Whether stats are available to display or not. Available since API v19.")
    public Boolean getStatsAvailable() {
        return this.statsAvailable;
    }

    public void setStatsAvailable(Boolean statsAvailable) {
        this.statsAvailable = statsAvailable;
    }

    public ApiHiveReplicationResult dbProcessed(BigDecimal dbProcessed) {
        this.dbProcessed = dbProcessed;
        return this;
    }

    @ApiModelProperty(value="Number of Db's Imported/Exported. Available since API v19.")
    public BigDecimal getDbProcessed() {
        return this.dbProcessed;
    }

    public void setDbProcessed(BigDecimal dbProcessed) {
        this.dbProcessed = dbProcessed;
    }

    public ApiHiveReplicationResult tableProcessed(BigDecimal tableProcessed) {
        this.tableProcessed = tableProcessed;
        return this;
    }

    @ApiModelProperty(value="Number of Tables Imported/Exported. Available since API v19.")
    public BigDecimal getTableProcessed() {
        return this.tableProcessed;
    }

    public void setTableProcessed(BigDecimal tableProcessed) {
        this.tableProcessed = tableProcessed;
    }

    public ApiHiveReplicationResult partitionProcessed(BigDecimal partitionProcessed) {
        this.partitionProcessed = partitionProcessed;
        return this;
    }

    @ApiModelProperty(value="Number of Partitions Imported/Exported. Available since API v19.")
    public BigDecimal getPartitionProcessed() {
        return this.partitionProcessed;
    }

    public void setPartitionProcessed(BigDecimal partitionProcessed) {
        this.partitionProcessed = partitionProcessed;
    }

    public ApiHiveReplicationResult functionProcessed(BigDecimal functionProcessed) {
        this.functionProcessed = functionProcessed;
        return this;
    }

    @ApiModelProperty(value="Number of Functions Imported/Exported. Available since API v19.")
    public BigDecimal getFunctionProcessed() {
        return this.functionProcessed;
    }

    public void setFunctionProcessed(BigDecimal functionProcessed) {
        this.functionProcessed = functionProcessed;
    }

    public ApiHiveReplicationResult indexProcessed(BigDecimal indexProcessed) {
        this.indexProcessed = indexProcessed;
        return this;
    }

    @ApiModelProperty(value="Number of Indexes Imported/Exported. Available since API v19.")
    public BigDecimal getIndexProcessed() {
        return this.indexProcessed;
    }

    public void setIndexProcessed(BigDecimal indexProcessed) {
        this.indexProcessed = indexProcessed;
    }

    public ApiHiveReplicationResult statsProcessed(BigDecimal statsProcessed) {
        this.statsProcessed = statsProcessed;
        return this;
    }

    @ApiModelProperty(value="Number of Table and Partitions Statistics Imported/Exported. Available since API v19.")
    public BigDecimal getStatsProcessed() {
        return this.statsProcessed;
    }

    public void setStatsProcessed(BigDecimal statsProcessed) {
        this.statsProcessed = statsProcessed;
    }

    public ApiHiveReplicationResult dbExpected(BigDecimal dbExpected) {
        this.dbExpected = dbExpected;
        return this;
    }

    @ApiModelProperty(value="Number of Db's Expected. Available since API v19.")
    public BigDecimal getDbExpected() {
        return this.dbExpected;
    }

    public void setDbExpected(BigDecimal dbExpected) {
        this.dbExpected = dbExpected;
    }

    public ApiHiveReplicationResult tableExpected(BigDecimal tableExpected) {
        this.tableExpected = tableExpected;
        return this;
    }

    @ApiModelProperty(value="Number of Tables Expected. Available since API v19.")
    public BigDecimal getTableExpected() {
        return this.tableExpected;
    }

    public void setTableExpected(BigDecimal tableExpected) {
        this.tableExpected = tableExpected;
    }

    public ApiHiveReplicationResult partitionExpected(BigDecimal partitionExpected) {
        this.partitionExpected = partitionExpected;
        return this;
    }

    @ApiModelProperty(value="Number of Partitions Expected. Available since API v19.")
    public BigDecimal getPartitionExpected() {
        return this.partitionExpected;
    }

    public void setPartitionExpected(BigDecimal partitionExpected) {
        this.partitionExpected = partitionExpected;
    }

    public ApiHiveReplicationResult functionExpected(BigDecimal functionExpected) {
        this.functionExpected = functionExpected;
        return this;
    }

    @ApiModelProperty(value="Number of Functions Expected. Available since API v19.")
    public BigDecimal getFunctionExpected() {
        return this.functionExpected;
    }

    public void setFunctionExpected(BigDecimal functionExpected) {
        this.functionExpected = functionExpected;
    }

    public ApiHiveReplicationResult indexExpected(BigDecimal indexExpected) {
        this.indexExpected = indexExpected;
        return this;
    }

    @ApiModelProperty(value="Number of Indexes Expected. Available since API v19.")
    public BigDecimal getIndexExpected() {
        return this.indexExpected;
    }

    public void setIndexExpected(BigDecimal indexExpected) {
        this.indexExpected = indexExpected;
    }

    public ApiHiveReplicationResult statsExpected(BigDecimal statsExpected) {
        this.statsExpected = statsExpected;
        return this;
    }

    @ApiModelProperty(value="Number of Table and Partition Statistics Expected. Available since API v19.")
    public BigDecimal getStatsExpected() {
        return this.statsExpected;
    }

    public void setStatsExpected(BigDecimal statsExpected) {
        this.statsExpected = statsExpected;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiHiveReplicationResult apiHiveReplicationResult = (ApiHiveReplicationResult)o;
        return Objects.equals(this.phase, apiHiveReplicationResult.phase) && Objects.equals(this.tableCount, apiHiveReplicationResult.tableCount) && Objects.equals(this.tables, apiHiveReplicationResult.tables) && Objects.equals(this.impalaUDFCount, apiHiveReplicationResult.impalaUDFCount) && Objects.equals(this.hiveUDFCount, apiHiveReplicationResult.hiveUDFCount) && Objects.equals(this.impalaUDFs, apiHiveReplicationResult.impalaUDFs) && Objects.equals(this.hiveUDFs, apiHiveReplicationResult.hiveUDFs) && Objects.equals(this.errorCount, apiHiveReplicationResult.errorCount) && Objects.equals(this.errors, apiHiveReplicationResult.errors) && Objects.equals(this.dataReplicationResult, apiHiveReplicationResult.dataReplicationResult) && Objects.equals(this.dryRun, apiHiveReplicationResult.dryRun) && Objects.equals(this.runAsUser, apiHiveReplicationResult.runAsUser) && Objects.equals(this.runOnSourceAsUser, apiHiveReplicationResult.runOnSourceAsUser) && Objects.equals(this.statsAvailable, apiHiveReplicationResult.statsAvailable) && Objects.equals(this.dbProcessed, apiHiveReplicationResult.dbProcessed) && Objects.equals(this.tableProcessed, apiHiveReplicationResult.tableProcessed) && Objects.equals(this.partitionProcessed, apiHiveReplicationResult.partitionProcessed) && Objects.equals(this.functionProcessed, apiHiveReplicationResult.functionProcessed) && Objects.equals(this.indexProcessed, apiHiveReplicationResult.indexProcessed) && Objects.equals(this.statsProcessed, apiHiveReplicationResult.statsProcessed) && Objects.equals(this.dbExpected, apiHiveReplicationResult.dbExpected) && Objects.equals(this.tableExpected, apiHiveReplicationResult.tableExpected) && Objects.equals(this.partitionExpected, apiHiveReplicationResult.partitionExpected) && Objects.equals(this.functionExpected, apiHiveReplicationResult.functionExpected) && Objects.equals(this.indexExpected, apiHiveReplicationResult.indexExpected) && Objects.equals(this.statsExpected, apiHiveReplicationResult.statsExpected);
    }

    public int hashCode() {
        return Objects.hash(this.phase, this.tableCount, this.tables, this.impalaUDFCount, this.hiveUDFCount, this.impalaUDFs, this.hiveUDFs, this.errorCount, this.errors, this.dataReplicationResult, this.dryRun, this.runAsUser, this.runOnSourceAsUser, this.statsAvailable, this.dbProcessed, this.tableProcessed, this.partitionProcessed, this.functionProcessed, this.indexProcessed, this.statsProcessed, this.dbExpected, this.tableExpected, this.partitionExpected, this.functionExpected, this.indexExpected, this.statsExpected);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiHiveReplicationResult {\n");
        sb.append("    phase: ").append(this.toIndentedString(this.phase)).append("\n");
        sb.append("    tableCount: ").append(this.toIndentedString(this.tableCount)).append("\n");
        sb.append("    tables: ").append(this.toIndentedString(this.tables)).append("\n");
        sb.append("    impalaUDFCount: ").append(this.toIndentedString(this.impalaUDFCount)).append("\n");
        sb.append("    hiveUDFCount: ").append(this.toIndentedString(this.hiveUDFCount)).append("\n");
        sb.append("    impalaUDFs: ").append(this.toIndentedString(this.impalaUDFs)).append("\n");
        sb.append("    hiveUDFs: ").append(this.toIndentedString(this.hiveUDFs)).append("\n");
        sb.append("    errorCount: ").append(this.toIndentedString(this.errorCount)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    dataReplicationResult: ").append(this.toIndentedString(this.dataReplicationResult)).append("\n");
        sb.append("    dryRun: ").append(this.toIndentedString(this.dryRun)).append("\n");
        sb.append("    runAsUser: ").append(this.toIndentedString(this.runAsUser)).append("\n");
        sb.append("    runOnSourceAsUser: ").append(this.toIndentedString(this.runOnSourceAsUser)).append("\n");
        sb.append("    statsAvailable: ").append(this.toIndentedString(this.statsAvailable)).append("\n");
        sb.append("    dbProcessed: ").append(this.toIndentedString(this.dbProcessed)).append("\n");
        sb.append("    tableProcessed: ").append(this.toIndentedString(this.tableProcessed)).append("\n");
        sb.append("    partitionProcessed: ").append(this.toIndentedString(this.partitionProcessed)).append("\n");
        sb.append("    functionProcessed: ").append(this.toIndentedString(this.functionProcessed)).append("\n");
        sb.append("    indexProcessed: ").append(this.toIndentedString(this.indexProcessed)).append("\n");
        sb.append("    statsProcessed: ").append(this.toIndentedString(this.statsProcessed)).append("\n");
        sb.append("    dbExpected: ").append(this.toIndentedString(this.dbExpected)).append("\n");
        sb.append("    tableExpected: ").append(this.toIndentedString(this.tableExpected)).append("\n");
        sb.append("    partitionExpected: ").append(this.toIndentedString(this.partitionExpected)).append("\n");
        sb.append("    functionExpected: ").append(this.toIndentedString(this.functionExpected)).append("\n");
        sb.append("    indexExpected: ").append(this.toIndentedString(this.indexExpected)).append("\n");
        sb.append("    statsExpected: ").append(this.toIndentedString(this.statsExpected)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

