/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.container;

import java.io.File;
import java.net.URL;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.container.WebContainer;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.asset.AssetUtil;
import org.jboss.shrinkwrap.impl.base.asset.ServiceProviderAsset;
import org.jboss.shrinkwrap.impl.base.container.ContainerBase;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebContainerBase<T extends Archive<T>>
extends ContainerBase<T>
implements WebContainer<T> {
    protected WebContainerBase(Class<T> actualType, Archive<?> archive) {
        super(actualType, archive);
    }

    protected abstract ArchivePath getWebPath();

    protected abstract ArchivePath getWebInfPath();

    protected abstract ArchivePath getServiceProvidersPath();

    public T setWebXML(String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        return this.setWebXML((Asset)new ClassLoaderAsset(resourceName));
    }

    public T setWebXML(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.setWebXML((Asset)new FileAsset(resource));
    }

    public T setWebXML(URL resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.setWebXML((Asset)new UrlAsset(resource));
    }

    public T setWebXML(Asset resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.addAsWebInfResource(resource, "web.xml");
    }

    public T setWebXML(Package resourcePackage, String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        String classloaderResourceName = AssetUtil.getClassLoaderResourceName(resourcePackage, resourceName);
        return this.setWebXML((Asset)new ClassLoaderAsset(classloaderResourceName));
    }

    public T addAsWebResource(String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        return this.addAsWebResource((Asset)new ClassLoaderAsset(resourceName), AssetUtil.getNameForClassloaderResource(resourceName));
    }

    public T addAsWebResource(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.addAsWebResource((Asset)new FileAsset(resource), resource.getName());
    }

    public T addAsWebResource(String resourceName, String target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addAsWebResource((Asset)new ClassLoaderAsset(resourceName), target);
    }

    public T addAsWebResource(File resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addAsWebResource((Asset)new FileAsset(resource), target);
    }

    public T addAsWebResource(URL resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addAsWebResource((Asset)new UrlAsset(resource), target);
    }

    public T addAsWebResource(Asset resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addAsWebResource(resource, (ArchivePath)new BasicPath(target));
    }

    public T addAsWebResource(String resourceName, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addAsWebResource((Asset)new ClassLoaderAsset(resourceName), target);
    }

    public T addAsWebResource(File resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addAsWebResource((Asset)new FileAsset(resource), target);
    }

    public T addAsWebResource(URL resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addAsWebResource((Asset)new UrlAsset(resource), target);
    }

    public T addAsWebResource(Asset resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        BasicPath location = new BasicPath(this.getWebPath(), target);
        return this.add(resource, location);
    }

    public T addAsWebResources(Package resourcePackage, String ... resourceNames) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNullAndNoNullValues(resourceNames, "ResourceNames must be specified and can not container null values");
        for (String resourceName : resourceNames) {
            this.addAsWebResource(resourcePackage, resourceName);
        }
        return this.covarientReturn();
    }

    public T addAsWebResource(Package resourcePackage, String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        String classloaderResourceName = AssetUtil.getClassLoaderResourceName(resourcePackage, resourceName);
        ArchivePath target = ArchivePaths.create((String)classloaderResourceName);
        return this.addAsWebResource(resourcePackage, resourceName, target);
    }

    public T addAsWebResource(Package resourcePackage, String resourceName, String target) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        return this.addAsWebResource(resourcePackage, resourceName, ArchivePaths.create((String)target));
    }

    public T addAsWebResource(Package resourcePackage, String resourceName, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        String classloaderResourceName = AssetUtil.getClassLoaderResourceName(resourcePackage, resourceName);
        ClassLoaderAsset resource = new ClassLoaderAsset(classloaderResourceName);
        return this.addAsWebResource((Asset)resource, target);
    }

    public T addAsWebInfResource(String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        return this.addAsWebInfResource((Asset)new ClassLoaderAsset(resourceName), AssetUtil.getNameForClassloaderResource(resourceName));
    }

    public T addAsWebInfResource(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.addAsWebInfResource((Asset)new FileAsset(resource), resource.getName());
    }

    public T addAsWebInfResource(String resourceName, String target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addAsWebInfResource((Asset)new ClassLoaderAsset(resourceName), target);
    }

    public T addAsWebInfResource(File resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNullOrEmpty(target, "Target should be specified");
        return this.addAsWebInfResource((Asset)new FileAsset(resource), target);
    }

    public T addAsWebInfResource(URL resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNullOrEmpty(target, "Target should be specified");
        return this.addAsWebInfResource((Asset)new UrlAsset(resource), target);
    }

    public T addAsWebInfResource(Asset resource, String target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNullOrEmpty(target, "Target should be specified");
        return this.addAsWebInfResource(resource, ArchivePaths.create((String)target));
    }

    public T addAsWebInfResource(String resourceName, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addAsWebInfResource((Asset)new ClassLoaderAsset(resourceName), target);
    }

    public T addAsWebInfResource(File resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addAsWebInfResource((Asset)new FileAsset(resource), target);
    }

    public T addAsWebInfResource(URL resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        return this.addAsWebInfResource((Asset)new UrlAsset(resource), target);
    }

    public T addAsWebInfResource(Asset resource, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        Validate.notNull(target, "Target should be specified");
        BasicPath location = new BasicPath(this.getWebInfPath(), target);
        return this.add(resource, location);
    }

    public T addAsWebInfResources(Package resourcePackage, String ... resourceNames) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNullAndNoNullValues(resourceNames, "ResourceNames must be specified and can not container null values");
        for (String resourceName : resourceNames) {
            this.addAsWebInfResource(resourcePackage, resourceName);
        }
        return this.covarientReturn();
    }

    public T addAsWebInfResource(Package resourcePackage, String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        String classloaderResourceName = AssetUtil.getClassLoaderResourceName(resourcePackage, resourceName);
        ArchivePath target = ArchivePaths.create((String)classloaderResourceName);
        return this.addAsWebInfResource(resourcePackage, resourceName, target);
    }

    public T addAsWebInfResource(Package resourcePackage, String resourceName, String target) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNullOrEmpty(resourceName, "ResourceName must be specified");
        Validate.notNullOrEmpty(target, "Target must be specified");
        return this.addAsWebInfResource(resourcePackage, resourceName, ArchivePaths.create((String)target));
    }

    public T addAsWebInfResource(Package resourcePackage, String resourceName, ArchivePath target) throws IllegalArgumentException {
        Validate.notNull(resourcePackage, "ResourcePackage must be specified");
        Validate.notNullOrEmpty(resourceName, "ResourceName must be specified");
        Validate.notNull(target, "Target must be specified");
        String classloaderResourceName = AssetUtil.getClassLoaderResourceName(resourcePackage, resourceName);
        ClassLoaderAsset resource = new ClassLoaderAsset(classloaderResourceName);
        return this.addAsWebInfResource((Asset)resource, target);
    }

    @Override
    public T addAsServiceProvider(Class<?> serviceInterface, Class<?> ... serviceImpls) throws IllegalArgumentException {
        Validate.notNull(serviceInterface, "ServiceInterface must be specified");
        Validate.notNullAndNoNullValues(serviceImpls, "ServiceImpls must be specified and can not contain null values");
        ServiceProviderAsset asset = new ServiceProviderAsset(serviceImpls);
        BasicPath path = new BasicPath(this.getServiceProvidersPath(), serviceInterface.getName());
        return this.add((Asset)asset, path);
    }

    @Override
    public T addAsServiceProvider(String serviceInterface, String ... serviceImpls) throws IllegalArgumentException {
        Validate.notNull(serviceInterface, "ServiceInterface must be specified");
        Validate.notNullAndNoNullValues(serviceImpls, "ServiceImpls must be specified and can not contain null values");
        ServiceProviderAsset asset = new ServiceProviderAsset(serviceImpls);
        BasicPath path = new BasicPath(this.getServiceProvidersPath(), serviceInterface);
        return this.add((Asset)asset, path);
    }

    @Override
    public T addAsServiceProviderAndClasses(Class<?> serviceInterface, Class<?> ... serviceImpls) throws IllegalArgumentException {
        Validate.notNull(serviceInterface, "ServiceInterface must be specified");
        Validate.notNullAndNoNullValues(serviceImpls, "ServiceImpls must be specified and can not contain null values");
        this.addAsServiceProvider(serviceInterface, serviceImpls);
        this.addClass(serviceInterface);
        return this.addClasses(serviceImpls);
    }
}

