/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.cursor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.server.core.api.partition.PartitionTxn;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrCursor<V>
extends AbstractIndexCursor<V> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger((String)Loggers.CURSOR_LOG.getName());
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private static final String UNSUPPORTED_MSG = I18n.err((I18n)I18n.ERR_722, (Object[])new Object[0]);
    private final List<Cursor<IndexEntry<V, String>>> cursors;
    private final List<Evaluator<? extends ExprNode>> evaluators;
    private final List<Set<String>> blacklists;
    private int cursorIndex = -1;
    private IndexEntry<V, String> prefetched;

    public OrCursor(PartitionTxn partitionTxn, List<Cursor<IndexEntry<V, String>>> cursors, List<Evaluator<? extends ExprNode>> evaluators) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating OrCursor {}", (Object)this);
        }
        if (cursors.size() <= 1) {
            throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_723, (Object[])new Object[0]));
        }
        this.cursors = cursors;
        this.evaluators = evaluators;
        this.blacklists = new ArrayList<Set<String>>();
        this.partitionTxn = partitionTxn;
        for (int i = 0; i < cursors.size(); ++i) {
            this.blacklists.add(new HashSet());
        }
        this.cursorIndex = 0;
    }

    @Override
    protected String getUnsupportedMessage() {
        return UNSUPPORTED_MSG;
    }

    public void beforeFirst() throws LdapException, CursorException {
        this.checkNotClosed();
        this.cursorIndex = 0;
        this.cursors.get(this.cursorIndex).beforeFirst();
        this.setAvailable(false);
        this.prefetched = null;
    }

    public void afterLast() throws LdapException, CursorException {
        this.checkNotClosed();
        this.cursorIndex = this.cursors.size() - 1;
        this.cursors.get(this.cursorIndex).afterLast();
        this.setAvailable(false);
        this.prefetched = null;
    }

    public boolean first() throws LdapException, CursorException {
        this.beforeFirst();
        return this.setAvailable(this.next());
    }

    public boolean last() throws LdapException, CursorException {
        this.afterLast();
        return this.setAvailable(this.previous());
    }

    private boolean isBlackListed(String id) {
        return this.blacklists.get(this.cursorIndex).contains(id);
    }

    private void blackListIfDuplicate(PartitionTxn partitionTxn, IndexEntry<?, String> indexEntry) throws LdapException {
        for (int ii = 0; ii < this.evaluators.size(); ++ii) {
            if (ii == this.cursorIndex || !this.evaluators.get(ii).evaluate(partitionTxn, indexEntry)) continue;
            this.blacklists.get(ii).add(indexEntry.getId());
        }
    }

    @Override
    public boolean previous() throws LdapException, CursorException {
        IndexEntry candidate;
        while (this.cursors.get(this.cursorIndex).previous()) {
            this.checkNotClosed();
            candidate = (IndexEntry)this.cursors.get(this.cursorIndex).get();
            if (this.isBlackListed((String)candidate.getId())) continue;
            this.blackListIfDuplicate(this.partitionTxn, candidate);
            this.prefetched = candidate;
            return this.setAvailable(true);
        }
        while (this.cursorIndex > 0) {
            this.checkNotClosed();
            --this.cursorIndex;
            this.cursors.get(this.cursorIndex).afterLast();
            while (this.cursors.get(this.cursorIndex).previous()) {
                this.checkNotClosed();
                candidate = (IndexEntry)this.cursors.get(this.cursorIndex).get();
                if (this.isBlackListed((String)candidate.getId())) continue;
                this.blackListIfDuplicate(this.partitionTxn, candidate);
                this.prefetched = candidate;
                return this.setAvailable(true);
            }
        }
        this.prefetched = null;
        return this.setAvailable(false);
    }

    @Override
    public boolean next() throws LdapException, CursorException {
        IndexEntry candidate;
        while (this.cursors.get(this.cursorIndex).next()) {
            this.checkNotClosed();
            candidate = (IndexEntry)this.cursors.get(this.cursorIndex).get();
            if (this.isBlackListed((String)candidate.getId())) continue;
            this.blackListIfDuplicate(this.partitionTxn, candidate);
            this.prefetched = candidate;
            return this.setAvailable(true);
        }
        while (this.cursorIndex < this.cursors.size() - 1) {
            this.checkNotClosed();
            ++this.cursorIndex;
            this.cursors.get(this.cursorIndex).beforeFirst();
            while (this.cursors.get(this.cursorIndex).next()) {
                this.checkNotClosed();
                candidate = (IndexEntry)this.cursors.get(this.cursorIndex).get();
                if (this.isBlackListed((String)candidate.getId())) continue;
                this.blackListIfDuplicate(this.partitionTxn, candidate);
                this.prefetched = candidate;
                return this.setAvailable(true);
            }
        }
        this.prefetched = null;
        return this.setAvailable(false);
    }

    public IndexEntry<V, String> get() throws CursorException {
        this.checkNotClosed();
        if (this.available()) {
            return this.prefetched;
        }
        throw new InvalidCursorPositionException(I18n.err((I18n)I18n.ERR_708, (Object[])new Object[0]));
    }

    public void close() throws IOException {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing OrCursor {}", (Object)this);
        }
        super.close();
        for (Cursor<IndexEntry<V, String>> cursor : this.cursors) {
            cursor.close();
        }
    }

    public void close(Exception cause) throws IOException {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing OrCursor {}", (Object)this);
        }
        super.close(cause);
        for (Cursor<IndexEntry<V, String>> cursor : this.cursors) {
            cursor.close(cause);
        }
    }

    private String dumpEvaluators(String tabs) {
        StringBuilder sb = new StringBuilder();
        for (Evaluator<? extends ExprNode> evaluator : this.evaluators) {
            sb.append(evaluator.toString(tabs + "  >>"));
        }
        return sb.toString();
    }

    private String dumpCursors(String tabs) {
        StringBuilder sb = new StringBuilder();
        for (Cursor<IndexEntry<V, String>> cursor : this.cursors) {
            sb.append(cursor.toString(tabs + "  "));
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("OrCursor (");
        if (this.available()) {
            sb.append("available)");
        } else {
            sb.append("absent)");
        }
        sb.append("#").append(this.cursorIndex).append(" : \n");
        if (this.evaluators != null && !this.evaluators.isEmpty()) {
            sb.append(this.dumpEvaluators(tabs));
        }
        if (this.cursors != null && !this.cursors.isEmpty()) {
            sb.append(this.dumpCursors(tabs)).append('\n');
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

