/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.decorators.LdapResultDecorator;
import org.apache.directory.api.ldap.codec.decorators.ResponseDecorator;
import org.apache.directory.api.ldap.model.message.ExtendedResponse;
import org.apache.directory.api.util.Strings;

public class ExtendedResponseDecorator<R extends ExtendedResponse>
extends ResponseDecorator<R>
implements ExtendedResponse {
    private byte[] responseNameBytes;
    private int extendedResponseLength;
    protected byte[] responseValue;

    public ExtendedResponseDecorator(LdapApiService codec, R decoratedMessage) {
        super(codec, decoratedMessage);
    }

    public String getResponseName() {
        return ((ExtendedResponse)this.getDecorated()).getResponseName();
    }

    public void setResponseName(String oid) {
        ((ExtendedResponse)this.getDecorated()).setResponseName(oid);
    }

    public byte[] getResponseValue() {
        return this.responseValue;
    }

    public void setResponseValue(byte[] responseValue) {
        this.responseValue = responseValue;
    }

    public int computeLength() {
        byte[] encodedValue;
        int ldapResultLength;
        this.extendedResponseLength = ldapResultLength = ((LdapResultDecorator)this.getLdapResult()).computeLength();
        String id = this.getResponseName();
        if (!Strings.isEmpty((String)id)) {
            this.responseNameBytes = Strings.getBytesUtf8((String)id);
            int idLength = this.responseNameBytes.length;
            this.extendedResponseLength += 1 + TLV.getNbBytes((int)idLength) + idLength;
        }
        if ((encodedValue = this.getResponseValue()) != null) {
            this.extendedResponseLength += 1 + TLV.getNbBytes((int)encodedValue.length) + encodedValue.length;
        }
        return 1 + TLV.getNbBytes((int)this.extendedResponseLength) + this.extendedResponseLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            byte[] encodedValue;
            buffer.put((byte)120);
            buffer.put(TLV.getBytes((int)this.extendedResponseLength));
            ((LdapResultDecorator)this.getLdapResult()).encode(buffer);
            if (this.responseNameBytes != null) {
                buffer.put((byte)-118);
                buffer.put(TLV.getBytes((int)this.responseNameBytes.length));
                if (this.responseNameBytes.length != 0) {
                    buffer.put(this.responseNameBytes);
                }
            }
            if ((encodedValue = this.getResponseValue()) != null) {
                buffer.put((byte)-117);
                buffer.put(TLV.getBytes((int)encodedValue.length));
                if (encodedValue.length != 0) {
                    buffer.put(encodedValue);
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_08212_PDU_BUFFER_TOO_SMALL, (Object[])new Object[0]), (Exception)boe);
        }
        return buffer;
    }
}

