/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Associates a hostname with its corresponding certificate and private key")
public class ApiHostCertInfo {
    @SerializedName(value="hostname")
    private String hostname = null;
    @SerializedName(value="certificate")
    private String certificate = null;
    @SerializedName(value="key")
    private String key = null;

    public ApiHostCertInfo hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    @ApiModelProperty(value="The FQDN of a host in the deployment.")
    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public ApiHostCertInfo certificate(String certificate) {
        this.certificate = certificate;
        return this;
    }

    @ApiModelProperty(example="host-cert.pem", value="The certificate for this host in PEM format.")
    public String getCertificate() {
        return this.certificate;
    }

    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    public ApiHostCertInfo key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(example="host-key.pem", value="The private key for this host in PEM format.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiHostCertInfo apiHostCertInfo = (ApiHostCertInfo)o;
        return Objects.equals(this.hostname, apiHostCertInfo.hostname) && Objects.equals(this.certificate, apiHostCertInfo.certificate) && Objects.equals(this.key, apiHostCertInfo.key);
    }

    public int hashCode() {
        return Objects.hash(this.hostname, this.certificate, this.key);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiHostCertInfo {\n");
        sb.append("    hostname: ").append(this.toIndentedString(this.hostname)).append("\n");
        sb.append("    certificate: ").append(this.toIndentedString(this.certificate)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

