/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.mavibot;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.mavibot.btree.Tuple;
import org.apache.directory.mavibot.btree.util.TupleReaderWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdifTupleReaderWriter<E>
implements TupleReaderWriter<Dn, E> {
    private LdifReader reader = null;
    private static final Logger LOG = LoggerFactory.getLogger(LdifTupleReaderWriter.class);
    private String ldifFile;
    private RandomAccessFile raf;
    private SchemaManager schemaManager;

    public LdifTupleReaderWriter(String ldifFile, SchemaManager schemaManager) {
        this.ldifFile = ldifFile;
        this.schemaManager = schemaManager;
        try {
            this.raf = new RandomAccessFile(ldifFile, "r");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Tuple<Dn, E> readSortedTuple(DataInputStream in) {
        try {
            if (in.available() > 0) {
                Tuple t = new Tuple();
                t.setKey((Object)new Dn(new String[]{in.readUTF()}));
                String[] tokens = in.readUTF().split(":");
                long offset = Long.valueOf(tokens[0]);
                int length = Integer.valueOf(tokens[1]);
                this.raf.seek(offset);
                byte[] data = new byte[length];
                this.raf.read(data, 0, length);
                LdifReader reader = new LdifReader();
                LdifEntry ldifEntry = (LdifEntry)reader.parseLdif(new String(data)).get(0);
                DefaultEntry entry = new DefaultEntry(this.schemaManager, ldifEntry.getEntry());
                t.setValue((Object)entry);
                return t;
            }
        }
        catch (Exception e) {
            LOG.error("Failed to read a sorted tuple", (Throwable)e);
        }
        return null;
    }

    public Tuple<Dn, E> readUnsortedTuple(DataInputStream in) {
        try {
            if (this.reader == null) {
                this.reader = new LdifReader((InputStream)in);
            }
        }
        catch (Exception e) {
            String msg = "Failed to open the LDIF input stream";
            LOG.error(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        Tuple t = null;
        if (this.reader.hasNext()) {
            LdifEntry ldifEntry = this.reader.next();
            if (ldifEntry == null) {
                throw new IllegalStateException("Received null entry while parsing, check the LDIF file for possible incorrect/corrupted entries");
            }
            t = new Tuple();
            t.setKey((Object)ldifEntry.getDn());
            t.setValue((Object)(ldifEntry.getOffset() + ":" + ldifEntry.getLengthBeforeParsing()));
        }
        return t;
    }

    public void storeSortedTuple(Tuple<Dn, E> t, DataOutputStream out) throws IOException {
        out.writeUTF(((Dn)t.getKey()).getName());
        out.writeUTF((String)t.getValue());
    }
}

