/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter.rewrite.impl.xml;

import org.apache.commons.digester3.Digester;
import org.apache.commons.digester3.Rule;
import org.apache.commons.digester3.SetPropertiesRule;
import org.apache.commons.digester3.binder.AbstractRulesModule;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFilterContentDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFilterDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFilterGroupDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFlowDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteFunctionDescriptorFactory;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteRuleDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteRulesDescriptor;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteRulesDescriptorFactory;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteStepDescriptorFactory;
import org.apache.knox.gateway.filter.rewrite.impl.UrlRewriteFilterApplyDescriptorImpl;
import org.apache.knox.gateway.filter.rewrite.impl.UrlRewriteFilterBufferDescriptorImpl;
import org.apache.knox.gateway.filter.rewrite.impl.UrlRewriteFilterDetectDescriptorImpl;
import org.apache.knox.gateway.filter.rewrite.impl.UrlRewriteFilterScopeDescriptorImpl;
import org.apache.knox.gateway.filter.rewrite.impl.xml.XmlRewriteRulesTags;
import org.xml.sax.Attributes;

public class XmlRewriteRulesDigester
extends AbstractRulesModule
implements XmlRewriteRulesTags {
    protected void configure() {
        this.forPattern("rules").addRule((Rule)new RulesFactory());
        this.forPattern("rules").addRule((Rule)new SetPropertiesRule());
        for (String name : UrlRewriteFunctionDescriptorFactory.getNames()) {
            this.forPattern("rules/functions/" + name).addRule((Rule)new FunctionFactory());
            this.forPattern("rules/functions/" + name).addRule((Rule)new SetPropertiesRule());
        }
        this.forPattern("rules/rule").addRule((Rule)new RuleFactory());
        this.forPattern("rules/rule").addRule((Rule)new SetPropertiesRule());
        for (String type : UrlRewriteStepDescriptorFactory.getTypes()) {
            this.forPattern("*/" + type).addRule((Rule)new StepFactory());
            this.forPattern("*/" + type).addRule((Rule)new SetPropertiesRule());
        }
        this.forPattern("rules/filter").addRule((Rule)new FilterFactory());
        this.forPattern("rules/filter").addRule((Rule)new SetPropertiesRule());
        this.forPattern("rules/filter/content").addRule((Rule)new FilterContentFactory());
        this.forPattern("rules/filter/content").addRule((Rule)new SetPropertiesRule());
        this.forPattern("rules/filter/content/*/apply").addRule((Rule)new FilterApplyFactory());
        this.forPattern("rules/filter/content/*/apply").addRule((Rule)new SetPropertiesRule());
        this.forPattern("rules/filter/content/scope").addRule((Rule)new FilterScopeFactory());
        this.forPattern("rules/filter/content/scope").addRule((Rule)new SetPropertiesRule());
        this.forPattern("rules/filter/content/buffer").addRule((Rule)new FilterBufferFactory());
        this.forPattern("rules/filter/content/buffer").addRule((Rule)new SetPropertiesRule());
        this.forPattern("rules/filter/content/buffer/detect").addRule((Rule)new FilterDetectFactory());
        this.forPattern("rules/filter/content/buffer/detect").addRule((Rule)new SetPropertiesRule());
    }

    private static abstract class FactoryRule
    extends Rule {
        private FactoryRule() {
        }

        protected abstract Object create(String var1, String var2, Attributes var3);

        public void begin(String namespace, String name, Attributes attributes) throws Exception {
            this.getDigester().push(this.create(namespace, name, attributes));
        }

        public void end(String namespace, String name) throws Exception {
            this.getDigester().pop();
        }
    }

    private static class FilterDetectFactory
    extends FactoryRule {
        private FilterDetectFactory() {
        }

        @Override
        public Object create(String namespace, String name, Attributes attributes) {
            UrlRewriteFilterGroupDescriptor parent = (UrlRewriteFilterGroupDescriptor)this.getDigester().peek();
            UrlRewriteFilterDetectDescriptorImpl child = new UrlRewriteFilterDetectDescriptorImpl();
            child.path(attributes.getValue("path"));
            parent.addSelector(child);
            return child;
        }
    }

    private static class FilterBufferFactory
    extends FactoryRule {
        private FilterBufferFactory() {
        }

        @Override
        public Object create(String namespace, String name, Attributes attributes) {
            UrlRewriteFilterGroupDescriptor parent = (UrlRewriteFilterGroupDescriptor)this.getDigester().peek();
            UrlRewriteFilterBufferDescriptorImpl child = new UrlRewriteFilterBufferDescriptorImpl();
            child.path(attributes.getValue("path"));
            parent.addSelector(child);
            return child;
        }
    }

    private static class FilterScopeFactory
    extends FactoryRule {
        private FilterScopeFactory() {
        }

        @Override
        public Object create(String namespace, String name, Attributes attributes) {
            UrlRewriteFilterGroupDescriptor parent = (UrlRewriteFilterGroupDescriptor)this.getDigester().peek();
            UrlRewriteFilterScopeDescriptorImpl child = new UrlRewriteFilterScopeDescriptorImpl();
            child.path(attributes.getValue("path"));
            parent.addSelector(child);
            return child;
        }
    }

    private static class FilterApplyFactory
    extends FactoryRule {
        private FilterApplyFactory() {
        }

        @Override
        public Object create(String namespace, String name, Attributes attributes) {
            UrlRewriteFilterGroupDescriptor parent = (UrlRewriteFilterGroupDescriptor)this.getDigester().peek();
            UrlRewriteFilterApplyDescriptorImpl child = new UrlRewriteFilterApplyDescriptorImpl();
            child.path(attributes.getValue("path"));
            parent.addSelector(child);
            return child;
        }
    }

    private static class FilterContentFactory
    extends FactoryRule {
        private FilterContentFactory() {
        }

        @Override
        public Object create(String namespace, String name, Attributes attributes) {
            UrlRewriteFilterDescriptor parent = (UrlRewriteFilterDescriptor)this.getDigester().peek();
            UrlRewriteFilterContentDescriptor descriptor = parent.addContent(attributes.getValue("type"));
            if (attributes.getValue("asType") != null) {
                descriptor = descriptor.asType(attributes.getValue("asType"));
            }
            return descriptor;
        }
    }

    private static class FilterFactory
    extends FactoryRule {
        private FilterFactory() {
        }

        @Override
        public Object create(String namespace, String name, Attributes attributes) {
            UrlRewriteRulesDescriptor parent = (UrlRewriteRulesDescriptor)this.getDigester().peek();
            return parent.addFilter(attributes.getValue("name"));
        }
    }

    private static class FunctionFactory
    extends FactoryRule {
        private FunctionFactory() {
        }

        @Override
        public Object create(String namespace, String name, Attributes attributes) {
            UrlRewriteRulesDescriptor rules = (UrlRewriteRulesDescriptor)this.getDigester().peek();
            return rules.addFunction(name);
        }
    }

    private static class StepFactory
    extends FactoryRule {
        private StepFactory() {
        }

        @Override
        public Object create(String namespace, String name, Attributes attributes) {
            UrlRewriteFlowDescriptor flow = (UrlRewriteFlowDescriptor)this.getDigester().peek();
            return flow.addStep(name);
        }
    }

    private static class RuleFactory
    extends Rule {
        private RuleFactory() {
        }

        public void begin(String namespace, String name, Attributes attributes) throws Exception {
            Digester digester = this.getDigester();
            UrlRewriteRulesDescriptor rules = (UrlRewriteRulesDescriptor)digester.peek();
            UrlRewriteRuleDescriptor rule = rules.newRule();
            this.getDigester().push((Object)rule);
        }

        public void end(String namespace, String name) throws Exception {
            Digester digester = this.getDigester();
            UrlRewriteRuleDescriptor rule = (UrlRewriteRuleDescriptor)digester.pop();
            UrlRewriteRulesDescriptor rules = (UrlRewriteRulesDescriptor)digester.peek();
            rules.addRule(rule);
        }
    }

    private static class RulesFactory
    extends FactoryRule {
        private RulesFactory() {
        }

        @Override
        public Object create(String namespace, String name, Attributes attributes) {
            return UrlRewriteRulesDescriptorFactory.create();
        }
    }
}

