/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.websockets;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.websockets.MessageEventCallback;
import org.apache.knox.gateway.websockets.ProxyInboundClient;
import org.apache.knox.gateway.websockets.WebsocketLogMessages;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;

public class ProxyWebSocketAdapter
extends WebSocketAdapter {
    private static final WebsocketLogMessages LOG = (WebsocketLogMessages)MessagesFactory.get(WebsocketLogMessages.class);
    private final URI backend;
    private org.eclipse.jetty.websocket.api.Session frontendSession;
    private Session backendSession;
    private WebSocketContainer container;
    private ExecutorService pool;
    private ClientEndpointConfig clientConfig;

    public ProxyWebSocketAdapter(URI backend, ExecutorService pool) {
        this(backend, pool, null);
    }

    public ProxyWebSocketAdapter(URI backend, ExecutorService pool, ClientEndpointConfig clientConfig) {
        this.backend = backend;
        this.pool = pool;
        this.clientConfig = clientConfig;
    }

    public void onWebSocketConnect(org.eclipse.jetty.websocket.api.Session frontEndSession) {
        this.container = ContainerProvider.getWebSocketContainer();
        ProxyInboundClient backendSocket = new ProxyInboundClient(this.getMessageCallback());
        try {
            this.backendSession = this.container.connectToServer((Endpoint)backendSocket, this.clientConfig, this.backend);
            LOG.onConnectionOpen(this.backend.toString());
        }
        catch (DeploymentException e) {
            LOG.connectionFailed((Exception)((Object)e));
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            LOG.connectionFailed(e);
            throw new RuntimeIOException((Throwable)e);
        }
        super.onWebSocketConnect(frontEndSession);
        this.frontendSession = frontEndSession;
    }

    public void onWebSocketBinary(byte[] payload, int offset, int length) {
        if (this.isNotConnected()) {
            return;
        }
        throw new UnsupportedOperationException("Websocket support for binary messages is not supported at this time.");
    }

    public void onWebSocketText(String message) {
        if (this.isNotConnected()) {
            return;
        }
        LOG.logMessage("[From Frontend --->]" + message);
        try {
            this.backendSession.getBasicRemote().sendText(message);
        }
        catch (IOException e) {
            LOG.connectionFailed(e);
        }
    }

    public void onWebSocketClose(int statusCode, String reason) {
        super.onWebSocketClose(statusCode, reason);
        this.pool.execute(new Runnable(){

            @Override
            public void run() {
                ProxyWebSocketAdapter.this.closeQuietly();
            }
        });
        LOG.onConnectionClose(this.backend.toString());
    }

    public void onWebSocketError(Throwable t) {
        this.cleanupOnError(t);
    }

    private void cleanupOnError(Throwable t) {
        LOG.onError(t.toString());
        if (t.toString().contains("exceeds maximum size")) {
            if (this.frontendSession != null && !this.frontendSession.isOpen()) {
                this.frontendSession.close(1009, t.getMessage());
            }
        } else {
            if (this.frontendSession != null && !this.frontendSession.isOpen()) {
                this.frontendSession.close(1011, t.getMessage());
            }
            this.pool.execute(new Runnable(){

                @Override
                public void run() {
                    ProxyWebSocketAdapter.this.closeQuietly();
                }
            });
        }
    }

    private MessageEventCallback getMessageCallback() {
        return new MessageEventCallback(){

            @Override
            public void doCallback(String message) {
            }

            @Override
            public void onConnectionOpen(Object session) {
            }

            @Override
            public void onConnectionClose(CloseReason reason) {
                try {
                    ProxyWebSocketAdapter.this.frontendSession.close(reason.getCloseCode().getCode(), reason.getReasonPhrase());
                }
                catch (Throwable throwable) {
                    ProxyWebSocketAdapter.this.pool.execute(new Runnable(){

                        @Override
                        public void run() {
                            ProxyWebSocketAdapter.this.closeQuietly();
                        }
                    });
                    throw throwable;
                }
                ProxyWebSocketAdapter.this.pool.execute(new /* invalid duplicate definition of identical inner class */);
            }

            @Override
            public void onError(Throwable cause) {
                ProxyWebSocketAdapter.this.cleanupOnError(cause);
            }

            @Override
            public void onMessageText(String message, Object session) {
                RemoteEndpoint remote = ProxyWebSocketAdapter.this.getRemote();
                LOG.logMessage("[From Backend <---]" + message);
                try {
                    remote.sendString(message);
                    if (remote.getBatchMode() == BatchMode.ON) {
                        remote.flush();
                    }
                }
                catch (IOException e) {
                    LOG.connectionFailed(e);
                    throw new RuntimeIOException((Throwable)e);
                }
            }

            @Override
            public void onMessageBinary(byte[] message, boolean last, Object session) {
                throw new UnsupportedOperationException("Websocket support for binary messages is not supported at this time.");
            }
        };
    }

    private void closeQuietly() {
        try {
            if (this.backendSession != null && !this.backendSession.isOpen()) {
                this.backendSession.close();
            }
        }
        catch (IOException e) {
            LOG.connectionFailed(e);
        }
        if (this.container instanceof LifeCycle) {
            try {
                ((LifeCycle)this.container).stop();
            }
            catch (Exception e) {
                LOG.connectionFailed(e);
            }
        }
        if (this.frontendSession != null && !this.frontendSession.isOpen()) {
            this.frontendSession.close();
        }
    }
}

