/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.i18n.messages.loggers.jdk;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.knox.gateway.i18n.messages.MessageLevel;
import org.apache.knox.gateway.i18n.messages.MessageLogger;

final class JdkMessageLogger
implements MessageLogger {
    private final Logger logger;

    JdkMessageLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public final boolean isLoggable(MessageLevel level) {
        return this.logger.isLoggable(JdkMessageLogger.toLevel(level));
    }

    @Override
    public final void log(StackTraceElement caller, MessageLevel level, String id, String message, Throwable thrown) {
        LogRecord record = new LogRecord(JdkMessageLogger.toLevel(level), message);
        record.setSourceClassName(caller.getClassName());
        record.setSourceMethodName(caller.getMethodName());
        if (thrown != null) {
            record.setThrown(thrown);
        }
        this.logger.log(record);
    }

    private static final Level toLevel(MessageLevel level) {
        switch (level) {
            case FATAL: {
                return Level.SEVERE;
            }
            case ERROR: {
                return Level.SEVERE;
            }
            case WARN: {
                return Level.WARNING;
            }
            case INFO: {
                return Level.INFO;
            }
            case DEBUG: {
                return Level.FINE;
            }
            case TRACE: {
                return Level.FINEST;
            }
        }
        return Level.OFF;
    }
}

