/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.webappsec.filter;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CSRFPreventionFilter
implements Filter {
    private static final String CUSTOM_HEADER_PARAM = "csrf.customheader";
    private static final String CUSTOM_METHODS_TO_IGNORE_PARAM = "csrf.methodstoignore";
    private String headerName = "X-XSRF-Header";
    private String mti = "GET,OPTIONS,HEAD";
    private Set<String> methodsToIgnore = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        String customMTI;
        String customHeader = filterConfig.getInitParameter(CUSTOM_HEADER_PARAM);
        if (customHeader != null) {
            this.headerName = customHeader;
        }
        if ((customMTI = filterConfig.getInitParameter(CUSTOM_METHODS_TO_IGNORE_PARAM)) != null) {
            this.mti = customMTI;
        }
        String[] methods = this.mti.split(",");
        this.methodsToIgnore = new HashSet<String>();
        this.methodsToIgnore.addAll(Arrays.asList(methods));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (this.methodsToIgnore.contains(httpRequest.getMethod()) || httpRequest.getHeader(this.headerName) != null) {
            chain.doFilter(request, response);
        } else {
            ((HttpServletResponse)response).sendError(400, "Missing Required Header for Vulnerability Protection");
        }
    }

    public void destroy() {
    }
}

