/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.entry;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.AbstractValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.ldap.model.schema.comparators.ByteArrayComparator;
import org.apache.directory.api.util.Strings;

public class BinaryValue
extends AbstractValue<byte[]> {
    public static final long serialVersionUID = 2L;

    BinaryValue(AttributeType attributeType) {
        if (attributeType != null) {
            if (attributeType.getSyntax() == null) {
                throw new IllegalArgumentException(I18n.err(I18n.ERR_04445, new Object[0]));
            }
            if (attributeType.getSyntax().isHumanReadable()) {
                LOG.warn("Treating a value of a human readible attribute {} as binary: ", (Object)attributeType.getName());
            }
            this.attributeType = attributeType;
        }
    }

    public BinaryValue(byte[] value) {
        if (value != null) {
            this.upValue = new byte[value.length];
            this.normalizedValue = new byte[value.length];
            System.arraycopy(value, 0, this.upValue, 0, value.length);
            System.arraycopy(value, 0, this.normalizedValue, 0, value.length);
        } else {
            this.upValue = null;
            this.normalizedValue = null;
        }
    }

    public BinaryValue(AttributeType attributeType, byte[] value) throws LdapInvalidAttributeValueException {
        this(value);
        this.apply(attributeType);
    }

    @Override
    public byte[] getNormValue() {
        if (this.isNull()) {
            return null;
        }
        byte[] copy = new byte[((byte[])this.normalizedValue).length];
        System.arraycopy(this.normalizedValue, 0, copy, 0, ((byte[])this.normalizedValue).length);
        return copy;
    }

    @Override
    public int compareTo(Value<byte[]> value) {
        if (this.isNull()) {
            if (value == null || value.isNull()) {
                return 0;
            }
            return -1;
        }
        if (value == null || value.isNull()) {
            return 1;
        }
        BinaryValue binaryValue = (BinaryValue)value;
        if (this.attributeType != null) {
            try {
                LdapComparator comparator = this.getLdapComparator();
                if (comparator != null) {
                    return comparator.compare(this.getNormReference(), binaryValue.getNormReference());
                }
                return new ByteArrayComparator(null).compare((byte[])this.getNormReference(), (byte[])binaryValue.getNormReference());
            }
            catch (LdapException e) {
                String msg = I18n.err(I18n.ERR_04443, Arrays.toString((byte[])this.getReference()), value);
                LOG.error(msg, e);
                throw new IllegalStateException(msg, e);
            }
        }
        return new ByteArrayComparator(null).compare(this.getNormValue(), binaryValue.getNormValue());
    }

    public int hashCode() {
        if (this.h == 0) {
            if (this.isNull()) {
                return 0;
            }
            byte[] normalizedValue = (byte[])this.getNormReference();
            this.h = Arrays.hashCode(normalizedValue);
        }
        return this.h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BinaryValue)) {
            return false;
        }
        BinaryValue other = (BinaryValue)obj;
        if (this.attributeType != null) {
            if (other.attributeType != null) {
                if (this.attributeType.getOid().equals(other.getAttributeType().getOid())) {
                    if (this.isNull()) {
                        return other.isNull();
                    }
                    if (Arrays.equals((byte[])this.upValue, (byte[])other.upValue)) {
                        return true;
                    }
                    try {
                        LdapComparator comparator = this.getLdapComparator();
                        if (comparator == null) {
                            return Arrays.equals((byte[])this.getNormReference(), (byte[])other.getNormReference());
                        }
                        return comparator.compare(this.getNormReference(), other.getNormReference()) == 0;
                    }
                    catch (LdapException ne) {
                        return false;
                    }
                }
                return false;
            }
            if (this.isNull()) {
                return other.isNull();
            }
            try {
                LdapComparator comparator = this.getLdapComparator();
                MatchingRule equality = this.getAttributeType().getEquality();
                if (equality == null) {
                    return Arrays.equals((byte[])this.getNormReference(), (byte[])other.getNormReference());
                }
                Normalizer normalizer = equality.getNormalizer();
                BinaryValue otherValue = (BinaryValue)normalizer.normalize(other);
                if (comparator == null) {
                    return Arrays.equals((byte[])this.getNormReference(), (byte[])otherValue.getNormReference());
                }
                return comparator.compare(this.getNormReference(), otherValue.getNormReference()) == 0;
            }
            catch (LdapException ne) {
                return false;
            }
        }
        if (other.attributeType != null) {
            if (this.isNull()) {
                return other.isNull();
            }
            try {
                LdapComparator comparator = other.getLdapComparator();
                MatchingRule equality = other.getAttributeType().getEquality();
                if (equality == null) {
                    return Arrays.equals((byte[])this.getNormReference(), (byte[])other.getNormReference());
                }
                Normalizer normalizer = equality.getNormalizer();
                BinaryValue thisValue = (BinaryValue)normalizer.normalize(this);
                if (comparator == null) {
                    return Arrays.equals((byte[])thisValue.getNormReference(), (byte[])other.getNormReference());
                }
                return comparator.compare(thisValue.getNormReference(), other.getNormReference()) == 0;
            }
            catch (LdapException ne) {
                return false;
            }
        }
        if (this.isNull()) {
            return other.isNull();
        }
        return Arrays.equals((byte[])this.getNormReference(), (byte[])other.getNormReference());
    }

    @Override
    public BinaryValue clone() {
        BinaryValue clone = (BinaryValue)super.clone();
        if (this.normalizedValue != null) {
            clone.normalizedValue = new byte[((byte[])this.normalizedValue).length];
            System.arraycopy(this.normalizedValue, 0, clone.normalizedValue, 0, ((byte[])this.normalizedValue).length);
        }
        if (this.upValue != null) {
            clone.upValue = new byte[((byte[])this.upValue).length];
            System.arraycopy(this.upValue, 0, clone.upValue, 0, ((byte[])this.upValue).length);
        }
        return clone;
    }

    @Override
    public byte[] getValue() {
        if (this.upValue == null) {
            return null;
        }
        byte[] copy = new byte[((byte[])this.upValue).length];
        System.arraycopy(this.upValue, 0, copy, 0, ((byte[])this.upValue).length);
        return copy;
    }

    @Override
    public boolean isHumanReadable() {
        return false;
    }

    @Override
    public int length() {
        return this.upValue != null ? ((byte[])this.upValue).length : 0;
    }

    @Override
    public byte[] getBytes() {
        return this.getValue();
    }

    @Override
    public String getString() {
        return Strings.utf8ToString((byte[])this.upValue);
    }

    public static BinaryValue deserialize(ObjectInput in) throws IOException, ClassNotFoundException {
        BinaryValue value = new BinaryValue((AttributeType)null);
        value.readExternal(in);
        return value;
    }

    public static BinaryValue deserialize(AttributeType attributeType, ObjectInput in) throws IOException, ClassNotFoundException {
        BinaryValue value = new BinaryValue(attributeType);
        value.readExternal(in);
        return value;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        block16: {
            boolean normalized;
            boolean isHR = in.readBoolean();
            if (isHR) {
                throw new IOException("The serialized value is not a Binary value");
            }
            int upLength = in.readInt();
            if (upLength >= 0) {
                this.upValue = new byte[upLength];
                in.readFully((byte[])this.upValue);
            }
            if (normalized = in.readBoolean()) {
                int normalizedLength = in.readInt();
                if (normalizedLength >= 0) {
                    this.normalizedValue = new byte[normalizedLength];
                    in.readFully((byte[])this.normalizedValue);
                }
            } else {
                if (this.attributeType != null) {
                    try {
                        this.normalizedValue = this.attributeType.getEquality().getNormalizer().normalize(this).getBytes();
                        MatchingRule equality = this.attributeType.getEquality();
                        if (equality == null) {
                            if (upLength >= 0) {
                                this.normalizedValue = new byte[upLength];
                                System.arraycopy(this.upValue, 0, this.normalizedValue, 0, upLength);
                            }
                        } else {
                            Normalizer normalizer = equality.getNormalizer();
                            if (normalizer != null) {
                                this.normalizedValue = normalizer.normalize(this).getBytes();
                            } else if (upLength >= 0) {
                                this.normalizedValue = new byte[upLength];
                                System.arraycopy(this.upValue, 0, this.normalizedValue, 0, upLength);
                            }
                        }
                        break block16;
                    }
                    catch (LdapException le) {
                        if (upLength >= 0) {
                            this.normalizedValue = new byte[upLength];
                            System.arraycopy(this.upValue, 0, this.normalizedValue, 0, upLength);
                        }
                        break block16;
                    }
                }
                if (upLength >= 0) {
                    this.normalizedValue = new byte[upLength];
                    System.arraycopy(this.upValue, 0, this.normalizedValue, 0, upLength);
                }
            }
        }
        this.h = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(false);
        if (this.upValue != null) {
            out.writeInt(((byte[])this.upValue).length);
            if (((byte[])this.upValue).length > 0) {
                out.write((byte[])this.upValue, 0, ((byte[])this.upValue).length);
            }
        } else {
            out.writeInt(-1);
        }
        if (this.attributeType != null) {
            out.writeBoolean(true);
            if (this.normalizedValue != null) {
                out.writeInt(((byte[])this.normalizedValue).length);
                if (((byte[])this.normalizedValue).length > 0) {
                    out.write((byte[])this.normalizedValue, 0, ((byte[])this.normalizedValue).length);
                }
            } else {
                out.writeInt(-1);
            }
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.h);
        out.flush();
    }

    public String toString() {
        if (this.upValue == null) {
            return "null";
        }
        if (((byte[])this.upValue).length > 16) {
            byte[] copy = new byte[16];
            System.arraycopy(this.upValue, 0, copy, 0, 16);
            return Strings.dumpBytes(copy) + "...";
        }
        return Strings.dumpBytes((byte[])this.upValue);
    }
}

