/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import java.security.Principal;
import java.security.PublicKey;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import org.apache.karaf.jaas.boot.principal.ClientPrincipal;
import org.apache.karaf.jaas.modules.publickey.PublickeyCallback;
import org.apache.sshd.common.AttributeStore;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarafJaasAuthenticator
implements PasswordAuthenticator,
PublickeyAuthenticator {
    public static final AttributeStore.AttributeKey<Subject> SUBJECT_ATTRIBUTE_KEY = new AttributeStore.AttributeKey();
    private final Logger LOGGER = LoggerFactory.getLogger(KarafJaasAuthenticator.class);
    private String realm;
    private String role;
    private Class<?>[] roleClasses;

    public KarafJaasAuthenticator(String realm, String role, Class<?>[] roleClasses) {
        this.realm = realm;
        this.role = role;
        this.roleClasses = roleClasses;
    }

    public boolean authenticate(String username, String password, ServerSession session) {
        CallbackHandler callbackHandler = callbacks -> {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    ((NameCallback)callback).setName(username);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    ((PasswordCallback)callback).setPassword(password.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callback);
            }
        };
        return this.doLogin(session, callbackHandler);
    }

    public boolean authenticate(String username, PublicKey key, ServerSession session) {
        CallbackHandler callbackHandler = callbacks -> {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    ((NameCallback)callback).setName(username);
                    continue;
                }
                if (callback instanceof PublickeyCallback) {
                    ((PublickeyCallback)callback).setPublicKey(key);
                    continue;
                }
                throw new UnsupportedCallbackException(callback);
            }
        };
        return this.doLogin(session, callbackHandler);
    }

    private boolean doLogin(ServerSession session, CallbackHandler callbackHandler) {
        try {
            Subject subject = new Subject();
            subject.getPrincipals().add((Principal)new ClientPrincipal("ssh", session.getClientAddress().toString()));
            LoginContext loginContext = new LoginContext(this.realm, subject, callbackHandler);
            loginContext.login();
            this.assertRolePresent(subject);
            session.setAttribute(SUBJECT_ATTRIBUTE_KEY, (Object)subject);
            return true;
        }
        catch (Exception e) {
            this.LOGGER.debug("User authentication failed with " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private void assertRolePresent(Subject subject) throws FailedLoginException {
        boolean hasCorrectRole = this.role == null || this.role.isEmpty() || this.roleClasses.length == 0;
        int roleCount = 0;
        for (Principal principal : subject.getPrincipals()) {
            for (Class<?> roleClass : this.roleClasses) {
                if (!roleClass.isInstance(principal)) continue;
                if (!hasCorrectRole) {
                    hasCorrectRole = this.role.equals(principal.getName());
                }
                ++roleCount;
            }
        }
        if (roleCount == 0) {
            throw new FailedLoginException("User doesn't have role defined");
        }
        if (!hasCorrectRole) {
            throw new FailedLoginException("User doesn't have the required role " + this.role);
        }
    }
}

