/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.command.completers;

import java.util.LinkedList;
import java.util.List;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.karaf.jaas.config.JaasRealm;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.CommandLine;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.support.completers.StringsCompleter;

@Service
public class LoginModuleNameCompleter
implements Completer {
    @Reference
    private List<JaasRealm> realms;

    public int complete(Session session, CommandLine commandLine, List<String> candidates) {
        StringsCompleter delegate = new StringsCompleter();
        try {
            if (this.realms != null && !this.realms.isEmpty()) {
                for (JaasRealm realm : this.realms) {
                    List<String> moduleClassNames = this.findLoginModuleClassNames(realm);
                    if (moduleClassNames == null || moduleClassNames.isEmpty()) continue;
                    delegate.getStrings().addAll(moduleClassNames);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return delegate.complete(session, commandLine, candidates);
    }

    private List<String> findLoginModuleClassNames(JaasRealm realm) {
        LinkedList<String> moduleClassNames = new LinkedList<String>();
        for (AppConfigurationEntry entry : realm.getEntries()) {
            String moduleClass = (String)entry.getOptions().get("org.apache.karaf.jaas.module");
            if (moduleClass == null) continue;
            moduleClassNames.add(moduleClass);
        }
        return moduleClassNames;
    }
}

