/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.utils.json;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSONParser {
    private static final Pattern KEY_VALUE_PATTERN = Pattern.compile("^\\s*[\"](.+?)[\"]\\s*[:]\\s*(.+)$");
    private final Object parsed;

    public JSONParser(CharSequence json) {
        String str = json.toString();
        str = str.trim().replace('\n', ' ').replace('\r', ' ');
        this.parsed = JSONParser.parseObject(str);
    }

    public JSONParser(InputStream is) throws IOException {
        this(JSONParser.readStreamAsString(is));
    }

    public Map<String, Object> getParsed() {
        if (this.parsed instanceof Map) {
            return (Map)this.parsed;
        }
        return null;
    }

    public List<Object> getParsedList() {
        if (this.parsed instanceof List) {
            return (List)this.parsed;
        }
        return null;
    }

    private static Pair<String, Object> parseKeyValue(String jsonKeyValue) {
        Matcher matcher = KEY_VALUE_PATTERN.matcher(jsonKeyValue);
        if (!matcher.matches() || matcher.groupCount() < 2) {
            throw new IllegalArgumentException("Malformatted JSON key-value pair: " + jsonKeyValue);
        }
        return new Pair<String, Object>(JSONParser.unEscapeString(matcher.group(1)), JSONParser.parseValue(matcher.group(2)));
    }

    private static Object parseValue(String jsonValue) {
        jsonValue = jsonValue.trim();
        switch (jsonValue.charAt(0)) {
            case '\"': {
                if (!jsonValue.endsWith("\"")) {
                    throw new IllegalArgumentException("Malformatted JSON string: " + jsonValue);
                }
                return JSONParser.unEscapeString(jsonValue.substring(1, jsonValue.length() - 1));
            }
            case '[': {
                ArrayList<Object> entries = new ArrayList<Object>();
                for (String v : JSONParser.parseListValuesRaw(jsonValue)) {
                    entries.add(JSONParser.parseValue(v));
                }
                return entries;
            }
            case '{': {
                return JSONParser.parseObject(jsonValue);
            }
            case 'F': 
            case 'T': 
            case 'f': 
            case 't': {
                return Boolean.parseBoolean(jsonValue);
            }
            case 'N': 
            case 'n': {
                return null;
            }
        }
        if (jsonValue.contains(".")) {
            return Double.parseDouble(jsonValue);
        }
        return Long.parseLong(jsonValue);
    }

    private static String unEscapeString(String s) {
        StringBuilder sb = new StringBuilder(s);
        block8: for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != '\\' || sb.length() <= i + 1) continue;
            sb.deleteCharAt(i);
            char nextChar = sb.charAt(i);
            switch (nextChar) {
                case 'b': {
                    sb.setCharAt(i, '\b');
                    continue block8;
                }
                case 'f': {
                    sb.setCharAt(i, '\f');
                    continue block8;
                }
                case 'n': {
                    sb.setCharAt(i, '\n');
                    continue block8;
                }
                case 'r': {
                    sb.setCharAt(i, '\r');
                    continue block8;
                }
                case 't': {
                    sb.setCharAt(i, '\t');
                    continue block8;
                }
                case 'u': {
                    if (sb.length() <= i + 4) continue block8;
                    int uc = Integer.parseInt(sb.substring(i + 1, i + 5), 16);
                    sb.replace(i, i + 5, "" + (char)uc);
                }
            }
        }
        return sb.toString();
    }

    private static Object parseObject(String jsonObject) {
        if (jsonObject.startsWith("[") && jsonObject.endsWith("]")) {
            ArrayList<Object> values = new ArrayList<Object>();
            for (String val : JSONParser.parseListValuesRaw(jsonObject)) {
                values.add(JSONParser.parseValue(val));
            }
            return values;
        }
        if (!jsonObject.startsWith("{") || !jsonObject.endsWith("}")) {
            throw new IllegalArgumentException("Malformatted JSON object: " + jsonObject);
        }
        HashMap values = new HashMap();
        if ((jsonObject = jsonObject.substring(1, jsonObject.length() - 1).trim()).length() == 0) {
            return values;
        }
        String lastParsedObject = "[START OF DOC]";
        for (String element : JSONParser.parseKeyValueListRaw(jsonObject)) {
            try {
                Pair<String, Object> pair = JSONParser.parseKeyValue(element);
                values.put(pair.key, pair.value);
                lastParsedObject = jsonObject;
            }
            catch (Throwable t) {
                throw new IllegalArgumentException("An error occured after: " + lastParsedObject, t);
            }
        }
        return values;
    }

    private static List<String> parseKeyValueListRaw(String jsonKeyValueList) {
        if (jsonKeyValueList.trim().length() == 0) {
            return Collections.emptyList();
        }
        jsonKeyValueList = jsonKeyValueList + ",";
        ArrayList<String> elements = new ArrayList<String>();
        int start = 0;
        Stack<Scope> scopeStack = new Stack<Scope>();
        block6: for (int i = 0; i < jsonKeyValueList.length(); ++i) {
            char curChar = jsonKeyValueList.charAt(i);
            switch (curChar) {
                case '\"': {
                    if (i > 0 && jsonKeyValueList.charAt(i - 1) == '\\') continue block6;
                    if (!scopeStack.empty() && scopeStack.peek() == Scope.QUOTE) {
                        scopeStack.pop();
                        continue block6;
                    }
                    scopeStack.push(Scope.QUOTE);
                    continue block6;
                }
                case '[': 
                case '{': {
                    if ((scopeStack.empty() ? null : (Scope)((Object)scopeStack.peek())) == Scope.QUOTE) continue block6;
                    scopeStack.push(Scope.getScope(curChar));
                    continue block6;
                }
                case ']': 
                case '}': {
                    Scope curScope;
                    Scope scope = curScope = scopeStack.empty() ? null : (Scope)((Object)scopeStack.peek());
                    if (curScope == Scope.QUOTE) continue block6;
                    Scope newScope = Scope.getScope(curChar);
                    if (curScope == newScope) {
                        scopeStack.pop();
                        continue block6;
                    }
                    throw new IllegalArgumentException("Unbalanced closing " + curChar + " in: " + jsonKeyValueList);
                }
                case ',': {
                    if (!scopeStack.empty()) continue block6;
                    elements.add(jsonKeyValueList.substring(start, i));
                    start = i + 1;
                }
            }
        }
        return elements;
    }

    private static List<String> parseListValuesRaw(String jsonList) {
        if (!jsonList.startsWith("[") || !jsonList.endsWith("]")) {
            throw new IllegalArgumentException("Malformatted JSON list: " + jsonList);
        }
        jsonList = jsonList.substring(1, jsonList.length() - 1);
        return JSONParser.parseKeyValueListRaw(jsonList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readStream(InputStream is) throws IOException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] bytes = new byte[65536];
            int length = 0;
            int offset = 0;
            while ((length = is.read(bytes, offset, bytes.length - offset)) != -1) {
                if ((offset += length) != bytes.length) continue;
                baos.write(bytes, 0, bytes.length);
                offset = 0;
            }
            if (offset != 0) {
                baos.write(bytes, 0, offset);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            is.close();
        }
    }

    private static String readStreamAsString(InputStream is) throws IOException {
        byte[] bytes = JSONParser.readStream(is);
        if (bytes.length < 5) {
            throw new IllegalArgumentException("Malformatted JSON");
        }
        int offset = 0;
        if (bytes[0] == -1 && bytes[1] == -2 || bytes[0] == -2 && bytes[1] == -1) {
            offset = 2;
        }
        String encoding = bytes[offset + 2] == 0 ? (bytes[offset + 1] != 0 ? "UTF-16" : "UTF-32") : (bytes[offset + 1] == 0 ? "UTF-16" : "UTF-8");
        return new String(bytes, encoding);
    }

    static class Pair<K, V> {
        final K key;
        final V value;

        Pair(K k, V v) {
            this.key = k;
            this.value = v;
        }
    }

    private static enum Scope {
        QUOTE,
        CURLY,
        BRACKET;


        static Scope getScope(char c) {
            switch (c) {
                case '\"': {
                    return QUOTE;
                }
                case '[': 
                case ']': {
                    return BRACKET;
                }
                case '{': 
                case '}': {
                    return CURLY;
                }
            }
            return null;
        }
    }
}

