/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.console;

import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.gogo.runtime.CommandProcessorImpl;
import org.apache.felix.gogo.runtime.CommandProxy;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Function;
import org.apache.felix.service.threadio.ThreadIO;
import org.apache.karaf.shell.api.console.Command;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Parser;
import org.apache.karaf.shell.api.console.Registry;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.api.console.SessionFactory;
import org.apache.karaf.shell.api.console.Terminal;
import org.apache.karaf.shell.impl.console.CommandWrapper;
import org.apache.karaf.shell.impl.console.ConsoleSessionImpl;
import org.apache.karaf.shell.impl.console.HeadlessSessionImpl;
import org.apache.karaf.shell.impl.console.RegistryImpl;
import org.apache.karaf.shell.impl.console.commands.ExitCommand;
import org.apache.karaf.shell.impl.console.commands.SubShellCommand;
import org.apache.karaf.shell.impl.console.commands.help.HelpCommand;

public class SessionFactoryImpl
extends RegistryImpl
implements SessionFactory,
Registry {
    final CommandProcessorImpl commandProcessor;
    final ThreadIO threadIO;
    final Map<String, SubShellCommand> subshells = new HashMap<String, SubShellCommand>();
    boolean closed;

    public SessionFactoryImpl(ThreadIO threadIO) {
        super(null);
        this.threadIO = threadIO;
        this.commandProcessor = new CommandProcessorImpl(threadIO);
        this.register(new ExitCommand());
        new HelpCommand(this);
        this.register(new ProcessorCommand("addCommand", "Add a command"));
        this.register(new ProcessorCommand("removeCommand", "Remove a command"));
        this.register(new ProcessorCommand("eval", "Evaluate"));
    }

    public CommandProcessorImpl getCommandProcessor() {
        return this.commandProcessor;
    }

    @Override
    public Registry getRegistry() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(Object service) {
        Map map = this.services;
        synchronized (map) {
            if (service instanceof Command) {
                Command command = (Command)service;
                String scope = command.getScope();
                String name = command.getName();
                if (!"*".equals(scope)) {
                    if (!this.subshells.containsKey(scope)) {
                        SubShellCommand subShell = new SubShellCommand(scope);
                        this.subshells.put(scope, subShell);
                        this.register(subShell);
                    }
                    this.subshells.get(scope).increment();
                }
                this.commandProcessor.addCommand(scope, (Object)this.wrap(command), name);
            }
            super.register(service);
        }
    }

    protected Function wrap(Command command) {
        return new CommandWrapper(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(Object service) {
        Map map = this.services;
        synchronized (map) {
            super.unregister(service);
            if (service instanceof Command) {
                Command command = (Command)service;
                String scope = command.getScope();
                String name = command.getName();
                this.commandProcessor.removeCommand(scope, name);
                if (!"*".equals(scope) && this.subshells.get(scope).decrement() == 0) {
                    SubShellCommand subShell = this.subshells.remove(scope);
                    this.unregister(subShell);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session create(InputStream in, PrintStream out, PrintStream err, Terminal term, String encoding, Runnable closeCallback) {
        CommandProcessorImpl commandProcessorImpl = this.commandProcessor;
        synchronized (commandProcessorImpl) {
            if (this.closed) {
                throw new IllegalStateException("SessionFactory has been closed");
            }
            ConsoleSessionImpl session = new ConsoleSessionImpl(this, this.commandProcessor, this.threadIO, in, out, err, term, encoding, closeCallback);
            return session;
        }
    }

    @Override
    public Session create(InputStream in, PrintStream out, PrintStream err) {
        return this.create(in, out, err, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session create(InputStream in, PrintStream out, PrintStream err, Session parent) {
        CommandProcessorImpl commandProcessorImpl = this.commandProcessor;
        synchronized (commandProcessorImpl) {
            if (this.closed) {
                throw new IllegalStateException("SessionFactory has been closed");
            }
            HeadlessSessionImpl session = new HeadlessSessionImpl(this, this.commandProcessor, in, out, err, parent);
            return session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        CommandProcessorImpl commandProcessorImpl = this.commandProcessor;
        synchronized (commandProcessorImpl) {
            this.closed = true;
            this.commandProcessor.stop();
        }
    }

    private class ProcessorCommand
    implements Command {
        private final String name;
        private final String desc;

        public ProcessorCommand(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        @Override
        public String getScope() {
            return "shell";
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        @Override
        public Completer getCompleter(boolean scoped) {
            return null;
        }

        @Override
        public Parser getParser() {
            return null;
        }

        @Override
        public Object execute(Session session, List<Object> arguments) throws Exception {
            CommandSession cmdSession = (CommandSession)session.get(".commandSession");
            return new CommandProxy(SessionFactoryImpl.this.commandProcessor, this.name).execute(cmdSession, arguments);
        }
    }
}

