/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.sql.DataSource;
import org.apache.karaf.jaas.boot.principal.GroupPrincipal;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.jaas.modules.AbstractKarafLoginModule;
import org.apache.karaf.jaas.modules.jdbc.JDBCUtils;
import org.apache.karaf.jaas.modules.properties.PropertiesLoginModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCLoginModule
extends AbstractKarafLoginModule {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(PropertiesLoginModule.class);
    public static final String PASSWORD_QUERY = "query.password";
    public static final String USER_QUERY = "query.user";
    public static final String ROLE_QUERY = "query.role";
    public static final String INSERT_USER_STATEMENT = "insert.user";
    public static final String INSERT_ROLE_STATEMENT = "insert.role";
    public static final String DELETE_ROLE_STATEMENT = "delete.role";
    public static final String DELETE_ROLES_STATEMENT = "delete.roles";
    public static final String DELETE_USER_STATEMENT = "delete.user";
    private String datasourceURL;
    protected String passwordQuery = "SELECT PASSWORD FROM USERS WHERE USERNAME=?";
    protected String roleQuery = "SELECT ROLE FROM ROLES WHERE USERNAME=?";

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, options);
        this.datasourceURL = (String)options.get("datasource");
        if (this.datasourceURL == null || this.datasourceURL.trim().length() == 0) {
            LOGGER.error("No datasource was specified ");
        } else if (!this.datasourceURL.startsWith("jndi:") && !this.datasourceURL.startsWith("osgi:")) {
            LOGGER.error("Invalid datasource lookup protocol");
        }
        if (options.containsKey(PASSWORD_QUERY)) {
            this.passwordQuery = (String)options.get(PASSWORD_QUERY);
        }
        if (options.containsKey(ROLE_QUERY)) {
            this.roleQuery = (String)options.get(ROLE_QUERY);
        }
    }

    @Override
    public boolean login() throws LoginException {
        block26: {
            Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
            try {
                this.callbackHandler.handle(callbacks);
            }
            catch (IOException ioe) {
                throw new LoginException(ioe.getMessage());
            }
            catch (UnsupportedCallbackException uce) {
                throw new LoginException(uce.getMessage() + " not available to obtain information from user");
            }
            this.user = ((NameCallback)callbacks[0]).getName();
            char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
            if (tmpPassword == null) {
                tmpPassword = new char[]{};
            }
            String password = new String(tmpPassword);
            this.principals = new HashSet();
            try {
                DataSource datasource = JDBCUtils.createDatasource(this.bundleContext, this.datasourceURL);
                try (Connection connection = datasource.getConnection();){
                    List<String> passwords = JDBCUtils.rawSelect(connection, this.passwordQuery, this.user);
                    if (passwords.isEmpty()) {
                        if (!this.detailedLoginExcepion) {
                            throw new LoginException("login failed");
                        }
                        throw new LoginException("User " + this.user + " does not exist");
                    }
                    if (!this.checkPassword(password, passwords.get(0))) {
                        if (!this.detailedLoginExcepion) {
                            throw new LoginException("login failed");
                        }
                        throw new LoginException("Password for " + this.user + " does not match");
                    }
                    this.principals.add(new UserPrincipal(this.user));
                    if (this.roleQuery != null && !"".equals(this.roleQuery.trim())) {
                        List<String> roles = JDBCUtils.rawSelect(connection, this.roleQuery, this.user);
                        for (String role : roles) {
                            if (role.startsWith("_g_:")) {
                                this.principals.add(new GroupPrincipal(role.substring("_g_:".length())));
                                for (String r : JDBCUtils.rawSelect(connection, this.roleQuery, role)) {
                                    this.principals.add(new RolePrincipal(r));
                                }
                                continue;
                            }
                            this.principals.add(new RolePrincipal(role));
                        }
                        break block26;
                    }
                    LOGGER.debug("No roleQuery specified so no roles have been retrieved for the authenticated user");
                }
            }
            catch (Exception ex) {
                throw new LoginException("Error has occurred while retrieving credentials from database:" + ex.getMessage());
            }
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        if (this.debug) {
            LOGGER.debug("logout");
        }
        return true;
    }
}

