/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.specs.activation;

import java.util.HashMap;
import java.util.Map;
import javax.activation.CommandInfo;
import javax.activation.DataContentHandler;
import javax.activation.MailcapCommandMap;
import org.osgi.framework.Bundle;

public class OsgiMailcapCommandMap
extends MailcapCommandMap {
    private Bundle currentBundle;
    private Map<CommandInfo, Bundle> bundles = new HashMap<CommandInfo, Bundle>();

    public void addMailcap(String line, Bundle bundle) {
        this.currentBundle = bundle;
        this.addMailcap(line);
    }

    protected void addCommand(Map commandList, String mimeType, CommandInfo command) {
        super.addCommand(commandList, mimeType, command);
        if (this.currentBundle != null) {
            this.bundles.put(command, this.currentBundle);
        }
    }

    public DataContentHandler createDataContentHandler(String mimeType) {
        CommandInfo info = this.getCommand(mimeType, "content-handler");
        if (info == null) {
            return null;
        }
        Bundle bundle = this.bundles.get(info);
        if (bundle != null) {
            try {
                return (DataContentHandler)bundle.loadClass(info.getCommandClass()).newInstance();
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                return null;
            }
            catch (InstantiationException e) {
                return null;
            }
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        try {
            return (DataContentHandler)cl.loadClass(info.getCommandClass()).newInstance();
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InstantiationException e) {
            return null;
        }
    }
}

