/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import kafka.server.CachedControllerId;
import kafka.server.KRaftCachedControllerId$;
import kafka.server.MetadataCache;
import kafka.server.metadata.ConfigRepository;
import kafka.utils.Logging;
import org.apache.kafka.admin.BrokerMetadata;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.DescribeClientQuotasRequestData;
import org.apache.kafka.common.message.DescribeClientQuotasResponseData;
import org.apache.kafka.common.message.DescribeTopicPartitionsResponseData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsRequestData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.LeaderAndIsr;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.server.common.FinalizedFeatures;
import org.apache.kafka.server.common.KRaftVersion;
import org.apache.kafka.server.common.MetadataVersion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.Breaks$;

@ScalaSignature(bytes="\u0006\u0005\r\u0015h\u0001\u0002\u001c8\u0001yB\u0001b\u0015\u0001\u0003\u0006\u0004%\t\u0001\u0016\u0005\t1\u0002\u0011\t\u0011)A\u0005+\"A\u0011\f\u0001BC\u0002\u0013\u0005!\f\u0003\u0005r\u0001\t\u0005\t\u0015!\u0003\\\u0011\u0015\u0011\b\u0001\"\u0001t\u0011\u001d9\b\u00011A\u0005\naD\u0001b \u0001A\u0002\u0013%\u0011\u0011\u0001\u0005\b\u0003\u001b\u0001\u0001\u0015)\u0003z\u0011\u001d\t9\u0002\u0001C\u0005\u00033Aq!a\u0016\u0001\t\u0003\tI\u0006C\u0004\u0002\\\u0001!I!!\u0018\t\u000f\u0005\r\u0007\u0001\"\u0003\u0002F\"9\u0011q\u001e\u0001\u0005\n\u0005E\bb\u0002B\u0003\u0001\u0011%!q\u0001\u0005\b\u0005/\u0001A\u0011\u0002B\r\u0011\u001d\u0011y\u0002\u0001C\u0005\u0005CAqA!\u000e\u0001\t\u0003\u00129\u0004C\u0005\u0003\\\u0001\t\n\u0011\"\u0001\u0003^!I!1\u000f\u0001\u0012\u0002\u0013\u0005!Q\f\u0005\b\u0005k\u0002A\u0011\u0001B<\u0011\u001d\u0011I\n\u0001C!\u00057CqA!(\u0001\t\u0003\u0012y\nC\u0004\u0003,\u0002!\tE!,\t\u000f\t]\u0006\u0001\"\u0011\u0003:\"9!\u0011\u0019\u0001\u0005B\t\r\u0007b\u0002Bd\u0001\u0011\u0005!\u0011\u001a\u0005\b\u0005\u001b\u0004A\u0011\u0001Bh\u0011\u001d\u0011\u0019\u000e\u0001C!\u0005+DqAa5\u0001\t\u0013\u0011I\u000fC\u0004\u0003n\u0002!\tEa<\t\u000f\tU\b\u0001\"\u0011\u0003x\"9!Q \u0001\u0005B\t}\bbBB\u0002\u0001\u0011\u00053Q\u0001\u0005\b\u0007+\u0001A\u0011IB\f\u0011\u001d\u0019i\u0002\u0001C!\u0007?Aqaa\n\u0001\t\u0003\u001aI\u0003C\u0004\u0004.\u0001!\tea\f\t\u000f\rM\u0002\u0001\"\u0011\u00046!91Q\b\u0001\u0005B\r}\u0002bBB&\u0001\u0011\u00053Q\n\u0005\b\u0007/\u0002A\u0011IB-\u0011\u001d\u0019Y\u0006\u0001C\u0005\u0007;Bqa!\u0019\u0001\t\u0003\u0019\u0019\u0007C\u0004\u0004p\u0001!\te!\u001d\t\u000f\r}\u0004\u0001\"\u0011\u0004\u0002\"91q\u0010\u0001\u0005B\r\u0015\u0005bBBE\u0001\u0011\u000511\u0012\u0005\b\u0007#\u0003A\u0011AA-\u0011\u001d\u0019\u0019\n\u0001C!\u0007+Cqaa+\u0001\t\u0003\u0019i\u000bC\u0004\u0004@\u0002!\ta!1\t\u000f\rE\u0007\u0001\"\u0011\u0004T\"911\u001c\u0001\u0005B\ru'AE&SC\u001a$X*\u001a;bI\u0006$\u0018mQ1dQ\u0016T!\u0001O\u001d\u0002\u00115,G/\u00193bi\u0006T!AO\u001e\u0002\rM,'O^3s\u0015\u0005a\u0014!B6bM.\f7\u0001A\n\u0006\u0001}*\u0015j\u0014\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0002\u0005\u0006)1oY1mC&\u0011A)\u0011\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0019;U\"A\u001d\n\u0005!K$!D'fi\u0006$\u0017\r^1DC\u000eDW\r\u0005\u0002K\u001b6\t1J\u0003\u0002Mw\u0005)Q\u000f^5mg&\u0011aj\u0013\u0002\b\u0019><w-\u001b8h!\t\u0001\u0016+D\u00018\u0013\t\u0011vG\u0001\tD_:4\u0017n\u001a*fa>\u001c\u0018\u000e^8ss\u0006A!M]8lKJLE-F\u0001V!\t\u0001e+\u0003\u0002X\u0003\n\u0019\u0011J\u001c;\u0002\u0013\t\u0014xn[3s\u0013\u0012\u0004\u0013\u0001F6sC\u001a$h+\u001a:tS>t7+\u001e9qY&,'/F\u0001\\!\ra6-Z\u0007\u0002;*\u0011alX\u0001\tMVt7\r^5p]*\u0011\u0001-Y\u0001\u0005kRLGNC\u0001c\u0003\u0011Q\u0017M^1\n\u0005\u0011l&\u0001C*vaBd\u0017.\u001a:\u0011\u0005\u0019|W\"A4\u000b\u0005!L\u0017AB2p[6|gN\u0003\u0002;U*\u0011Ah\u001b\u0006\u0003Y6\fa!\u00199bG\",'\"\u00018\u0002\u0007=\u0014x-\u0003\u0002qO\na1JU1giZ+'o]5p]\u0006)2N]1giZ+'o]5p]N+\b\u000f\u001d7jKJ\u0004\u0013A\u0002\u001fj]&$h\bF\u0002ukZ\u0004\"\u0001\u0015\u0001\t\u000bM+\u0001\u0019A+\t\u000be+\u0001\u0019A.\u0002\u001b}\u001bWO\u001d:f]RLU.Y4f+\u0005I\bC\u0001>~\u001b\u0005Y(B\u0001?k\u0003\u0015IW.Y4f\u0013\tq8PA\u0007NKR\fG-\u0019;b\u00136\fw-Z\u0001\u0012?\u000e,(O]3oi&k\u0017mZ3`I\u0015\fH\u0003BA\u0002\u0003\u0013\u00012\u0001QA\u0003\u0013\r\t9!\u0011\u0002\u0005+:LG\u000f\u0003\u0005\u0002\f\u001d\t\t\u00111\u0001z\u0003\rAH%M\u0001\u000f?\u000e,(O]3oi&k\u0017mZ3!Q\rA\u0011\u0011\u0003\t\u0004\u0001\u0006M\u0011bAA\u000b\u0003\nAao\u001c7bi&dW-\u0001\rnCf\u0014WMR5mi\u0016\u0014\u0018\t\\5wKJ+\u0007\u000f\\5dCN$\"\"a\u0007\u00020\u0005E\u00121HA'!\u0019\ti\"a\b\u0002$5\tq,C\u0002\u0002\"}\u0013A\u0001T5tiB!\u0011QEA\u0016\u001b\t\t9CC\u0002\u0002*\u0005\fA\u0001\\1oO&!\u0011QFA\u0014\u0005\u001dIe\u000e^3hKJDQ\u0001`\u0005A\u0002eDq!a\r\n\u0001\u0004\t)$A\u0004ce>\\WM]:\u0011\t\u0001\u000b9$V\u0005\u0004\u0003s\t%!B!se\u0006L\bbBA\u001f\u0013\u0001\u0007\u0011qH\u0001\rY&\u001cH/\u001a8fe:\u000bW.\u001a\t\u0005\u0003\u0003\nI%\u0004\u0002\u0002D)!\u0011QIA$\u0003\u001dqW\r^<pe.T!\u0001\u001b6\n\t\u0005-\u00131\t\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.\u001a\u0005\b\u0003\u001fJ\u0001\u0019AA)\u0003i1\u0017\u000e\u001c;feVs\u0017M^1jY\u0006\u0014G.Z#oIB|\u0017N\u001c;t!\r\u0001\u00151K\u0005\u0004\u0003+\n%a\u0002\"p_2,\u0017M\\\u0001\rGV\u0014(/\u001a8u\u00136\fw-\u001a\u000b\u0002s\u0006!r-\u001a;QCJ$\u0018\u000e^5p]6+G/\u00193bi\u0006$B\"a\u0018\u0002$\u0006\u0015\u0016\u0011XA^\u0003\u007f\u0003R\u0001QA1\u0003KJ1!a\u0019B\u0005\u0019y\u0005\u000f^5p]B1\u0011qMA<\u0003{rA!!\u001b\u0002t9!\u00111NA9\u001b\t\tiGC\u0002\u0002pu\na\u0001\u0010:p_Rt\u0014\"\u0001\"\n\u0007\u0005U\u0014)A\u0004qC\u000e\\\u0017mZ3\n\t\u0005e\u00141\u0010\u0002\t\u0013R,'/\u0019;pe*\u0019\u0011QO!\u0011\t\u0005}\u0014Q\u0014\b\u0005\u0003\u0003\u000b9J\u0004\u0003\u0002\u0004\u0006Me\u0002BAC\u0003#sA!a\"\u0002\u0010:!\u0011\u0011RAG\u001d\u0011\tY'a#\n\u00039L!\u0001\\7\n\u0005qZ\u0017B\u00015k\u0013\u0011\t)*a\u0012\u0002\u000f5,7o]1hK&!\u0011\u0011TAN\u0003QiU\r^1eCR\f'+Z:q_:\u001cX\rR1uC*!\u0011QSA$\u0013\u0011\ty*!)\u000335+G/\u00193bi\u0006\u0014Vm\u001d9p]N,\u0007+\u0019:uSRLwN\u001c\u0006\u0005\u00033\u000bY\nC\u0003}\u0017\u0001\u0007\u0011\u0010C\u0004\u0002(.\u0001\r!!+\u0002\u0013Q|\u0007/[2OC6,\u0007\u0003BAV\u0003gsA!!,\u00020B\u0019\u00111N!\n\u0007\u0005E\u0016)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003k\u000b9L\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003c\u000b\u0005bBA\u001f\u0017\u0001\u0007\u0011q\b\u0005\b\u0003{[\u0001\u0019AA)\u0003e)'O]8s+:\fg/Y5mC\ndW-\u00128ea>Lg\u000e^:\t\u000f\u0005\u00057\u00021\u0001\u0002R\u0005IRM\u001d:peVs\u0017M^1jY\u0006\u0014G.\u001a'jgR,g.\u001a:t\u00031:W\r\u001e)beRLG/[8o\u001b\u0016$\u0018\rZ1uC\u001a{'\u000fR3tGJL'-\u001a+pa&\u001c'+Z:q_:\u001cX\r\u0006\u0007\u0002H\u0006\u0005\u00181]As\u0003O\fY\u000f\u0005\u0004A\u0003\u0013\fi-V\u0005\u0004\u0003\u0017\f%A\u0002+va2,'\u0007E\u0003A\u0003C\ny\r\u0005\u0004\u0002h\u0005E\u00171[\u0005\u0005\u0003C\tY\b\u0005\u0003\u0002V\u0006mg\u0002BAA\u0003/LA!!7\u0002\u001c\u0006\u0019C)Z:de&\u0014W\rV8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d*fgB|gn]3ECR\f\u0017\u0002BAo\u0003?\u0014\u0001\u0006R3tGJL'-\u001a+pa&\u001c\u0007+\u0019:uSRLwN\\:SKN\u0004xN\\:f!\u0006\u0014H/\u001b;j_:TA!!7\u0002\u001c\")A\u0010\u0004a\u0001s\"9\u0011q\u0015\u0007A\u0002\u0005%\u0006bBA\u001f\u0019\u0001\u0007\u0011q\b\u0005\u0007\u0003Sd\u0001\u0019A+\u0002\u0015M$\u0018M\u001d;J]\u0012,\u0007\u0010\u0003\u0004\u0002n2\u0001\r!V\u0001\t[\u0006D8i\\;oi\u0006\u0011r-\u001a;PM\u001ad\u0017N\\3SKBd\u0017nY1t)!\tY\"a=\u0002v\n\r\u0001\"\u0002?\u000e\u0001\u0004I\bbBA|\u001b\u0001\u0007\u0011\u0011`\u0001\na\u0006\u0014H/\u001b;j_:\u0004B!a?\u0002\u00006\u0011\u0011Q \u0006\u0003q)LAA!\u0001\u0002~\n)\u0002+\u0019:uSRLwN\u001c*fO&\u001cHO]1uS>t\u0007bBA\u001f\u001b\u0001\u0007\u0011qH\u0001\u0011SN\u0014V\r\u001d7jG\u0006|eM\u001a7j]\u0016$\u0002\"!\u0015\u0003\n\t-!Q\u0002\u0005\b\u0003ot\u0001\u0019AA}\u0011\u001d\tiD\u0004a\u0001\u0003\u007fAqAa\u0004\u000f\u0001\u0004\u0011\t\"\u0001\u0004ce>\\WM\u001d\t\u0005\u0003w\u0014\u0019\"\u0003\u0003\u0003\u0016\u0005u(A\u0005\"s_.,'OU3hSN$(/\u0019;j_:\fQ#[:SKBd\u0017nY1J]>3g\r\\5oK\u0012K'\u000f\u0006\u0004\u0002R\tm!Q\u0004\u0005\b\u0005\u001fy\u0001\u0019\u0001B\t\u0011\u001d\t9p\u0004a\u0001\u0003s\f\u0001cZ3u\u00032Lg/Z#oIB|\u0017N\u001c;\u0015\u0011\t\r\"Q\u0006B\u0018\u0005g\u0001R\u0001QA1\u0005K\u0001BAa\n\u0003*5\u0011\u0011qI\u0005\u0005\u0005W\t9E\u0001\u0003O_\u0012,\u0007\"\u0002?\u0011\u0001\u0004I\bB\u0002B\u0019!\u0001\u0007Q+\u0001\u0002jI\"9\u0011Q\b\tA\u0002\u0005}\u0012\u0001E4fiR{\u0007/[2NKR\fG-\u0019;b))\u0011IDa\u0013\u0003V\t]#\u0011\f\t\u0007\u0005w\u0011\tE!\u0012\u000e\u0005\tu\"b\u0001B \u0003\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t\r#Q\b\u0002\u0004'\u0016\f\b\u0003BA@\u0005\u000fJAA!\u0013\u0002\"\n)R*\u001a;bI\u0006$\u0018MU3ta>t7/\u001a+pa&\u001c\u0007b\u0002B'#\u0001\u0007!qJ\u0001\u0007i>\u0004\u0018nY:\u0011\r\tm\"\u0011KAU\u0013\u0011\u0011\u0019F!\u0010\u0003\u0007M+G\u000fC\u0004\u0002>E\u0001\r!a\u0010\t\u0013\u0005u\u0016\u0003%AA\u0002\u0005E\u0003\"CAa#A\u0005\t\u0019AA)\u0003i9W\r\u001e+pa&\u001cW*\u001a;bI\u0006$\u0018\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011yF\u000b\u0003\u0002R\t\u00054F\u0001B2!\u0011\u0011)Ga\u001c\u000e\u0005\t\u001d$\u0002\u0002B5\u0005W\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t5\u0014)\u0001\u0006b]:|G/\u0019;j_:LAA!\u001d\u0003h\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00025\u001d,G\u000fV8qS\u000elU\r^1eCR\fG\u0005Z3gCVdG\u000f\n\u001b\u0002Q\u001d,G\u000fV8qS\u000elU\r^1eCR\fgi\u001c:EKN\u001c'/\u001b2f)>\u0004\u0018n\u0019*fgB|gn]3\u0015\u0019\te$\u0011\u0011BC\u0005\u000f\u0013\tJ!&\u0011\t\tm$QP\u0007\u0003\u00037KAAa \u0002\u001c\n\u0019C)Z:de&\u0014W\rV8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d*fgB|gn]3ECR\f\u0007b\u0002B')\u0001\u0007!1\u0011\t\u0007\u0003O\n9(!+\t\u000f\u0005uB\u00031\u0001\u0002@!9!\u0011\u0012\u000bA\u0002\t-\u0015\u0001\u0007;pa&\u001c\u0007+\u0019:uSRLwN\\*uCJ$\u0018J\u001c3fqB1\u0001I!$\u0002*VK1Aa$B\u0005%1UO\\2uS>t\u0017\u0007\u0003\u0004\u0003\u0014R\u0001\r!V\u0001\u001a[\u0006D\u0018.\\;n\u001dVl'-\u001a:PMB\u000b'\u000f^5uS>t7\u000fC\u0004\u0003\u0018R\u0001\r!!\u0015\u00025%<gn\u001c:f)>\u0004\u0018nY:XSRDW\t_2faRLwN\\:\u0002\u0019\u001d,G/\u00117m)>\u0004\u0018nY:\u0015\u0005\t=\u0013AE4fiR{\u0007/[2QCJ$\u0018\u000e^5p]N$BA!)\u0003*B1!1\bB)\u0005G\u0003BAa\n\u0003&&!!qUA$\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Dq!a*\u0017\u0001\u0004\tI+\u0001\u0006hKR$v\u000e]5d\u0013\u0012$BAa,\u00036B!!q\u0005BY\u0013\u0011\u0011\u0019,a\u0012\u0003\tU+\u0018\u000e\u001a\u0005\b\u0003O;\u0002\u0019AAU\u000319W\r\u001e+pa&\u001cg*Y7f)\u0011\u0011YL!0\u0011\u000b\u0001\u000b\t'!+\t\u000f\t}\u0006\u00041\u0001\u00030\u00069Ao\u001c9jG&#\u0017A\u00045bg\u0006c\u0017N^3Ce>\\WM\u001d\u000b\u0005\u0003#\u0012)\rC\u0003T3\u0001\u0007Q+\u0001\bjg\n\u0013xn[3s\r\u0016t7-\u001a3\u0015\t\u0005E#1\u001a\u0005\u0006'j\u0001\r!V\u0001\u0015SN\u0014%o\\6feNCW\u000f\u001e;j]\u001e$un\u001e8\u0015\t\u0005E#\u0011\u001b\u0005\u0006'n\u0001\r!V\u0001\u0010O\u0016$\u0018\t\\5wK\n\u0013xn[3sgR\u0011!q\u001b\t\u0007\u0003O\u0012IN!8\n\t\tm\u00171\u0010\u0002\t\u0013R,'/\u00192mKB!!q\u001cBs\u001b\t\u0011\tOC\u0002\u0003d*\fQ!\u00193nS:LAAa:\u0003b\nq!I]8lKJlU\r^1eCR\fG\u0003\u0002Bl\u0005WDQ\u0001`\u000fA\u0002e\f!cZ3u\u00032Lg/\u001a\"s_.,'OT8eKR1!1\u0005By\u0005gDQa\u0015\u0010A\u0002UCq!!\u0010\u001f\u0001\u0004\ty$A\nhKR\fE.\u001b<f\u0005J|7.\u001a:O_\u0012,7\u000f\u0006\u0003\u0003z\nm\bC\u0002B\u001e\u0005\u0003\u0012)\u0003C\u0004\u0002>}\u0001\r!a\u0010\u0002\u001d\u001d,GO\u0011:pW\u0016\u0014hj\u001c3fgR!!\u0011`B\u0001\u0011\u001d\ti\u0004\ta\u0001\u0003\u007f\tqbZ3u\u0019\u0016\fG-\u001a:B]\u0012L5O\u001d\u000b\u0007\u0007\u000f\u0019ya!\u0005\u0011\u000b\u0001\u000b\tg!\u0003\u0011\t\u0005m81B\u0005\u0005\u0007\u001b\tiP\u0001\u0007MK\u0006$WM]!oI&\u001b(\u000fC\u0004\u0002(\u0006\u0002\r!!+\t\r\rM\u0011\u00051\u0001V\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t)\u0011\u0019Iba\u0007\u0011\t\u0001\u000b\t'\u0016\u0005\b\u0003O\u0013\u0003\u0019AAU\u0003=!x\u000e]5d\u001d\u0006lWm\u001d+p\u0013\u0012\u001cHCAB\u0011!!\tiba\t\u0002*\n=\u0016bAB\u0013?\n\u0019Q*\u00199\u0002\u001fQ|\u0007/[2JIN$vNT1nKN$\"aa\u000b\u0011\u0011\u0005u11\u0005BX\u0003S\u000b1\u0002^8qS\u000eLE-\u00138g_R\u00111\u0011\u0007\t\b\u0001\u0006%7\u0011EB\u0016\u0003i9W\r\u001e)beRLG/[8o\u0019\u0016\fG-\u001a:F]\u0012\u0004x.\u001b8u)!\u0011\u0019ca\u000e\u0004:\rm\u0002bBATM\u0001\u0007\u0011\u0011\u0016\u0005\u0007\u0007'1\u0003\u0019A+\t\u000f\u0005ub\u00051\u0001\u0002@\u0005ar-\u001a;QCJ$\u0018\u000e^5p]J+\u0007\u000f\\5dC\u0016sG\r]8j]R\u001cHCBB!\u0007\u000b\u001aI\u0005E\u0004\u0003<\r\rSK!\n\n\t\r\u0015\"Q\b\u0005\b\u0007\u000f:\u0003\u0019\u0001BR\u0003\t!\b\u000fC\u0004\u0002>\u001d\u0002\r!a\u0010\u0002\u001f\u001d,GoQ8oiJ|G\u000e\\3s\u0013\u0012,\"aa\u0014\u0011\u000b\u0001\u000b\tg!\u0015\u0011\u0007\u0019\u001b\u0019&C\u0002\u0004Ve\u0012!cQ1dQ\u0016$7i\u001c8ue>dG.\u001a:JI\u00061r-\u001a;SC:$w.\\!mSZ,'I]8lKJLE-\u0006\u0002\u0004\u001a\u0005!r-\u001a;SC:$w.\\!mSZ,'I]8lKJ$Ba!\u0007\u0004`!)AP\u000ba\u0001s\u0006\u0019r-\u001a;BY&4XM\u0011:pW\u0016\u0014X\t]8dQR!1QMB7!\u0015\u0001\u0015\u0011MB4!\r\u00015\u0011N\u0005\u0004\u0007W\n%\u0001\u0002'p]\u001eDQaU\u0016A\u0002U\u000b!cZ3u\u00072,8\u000f^3s\u001b\u0016$\u0018\rZ1uCR111OB=\u0007{\u0002BAa\n\u0004v%!1qOA$\u0005\u001d\u0019E.^:uKJDqaa\u001f-\u0001\u0004\tI+A\u0005dYV\u001cH/\u001a:JI\"9\u0011Q\b\u0017A\u0002\u0005}\u0012\u0001C2p]R\f\u0017N\\:\u0015\t\u0005E31\u0011\u0005\b\u0003Ok\u0003\u0019AAU)\u0011\t\tfa\"\t\u000f\r\u001dc\u00061\u0001\u0003$\u0006A1/\u001a;J[\u0006<W\r\u0006\u0003\u0002\u0004\r5\u0005BBBH_\u0001\u0007\u00110\u0001\u0005oK^LU.Y4f\u0003!9W\r^%nC\u001e,\u0017AB2p]\u001aLw\r\u0006\u0003\u0004\u0018\u000eu\u0005\u0003BA\u000f\u00073K1aa'`\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\b\u0007?\u000b\u0004\u0019ABQ\u00039\u0019wN\u001c4jOJ+7o\\;sG\u0016\u0004Baa)\u0004(6\u00111Q\u0015\u0006\u0005\u0007'\u000b9%\u0003\u0003\u0004*\u000e\u0015&AD\"p]\u001aLwMU3t_V\u00148-Z\u0001\u0015I\u0016\u001c8M]5cK\u000ec\u0017.\u001a8u#V|G/Y:\u0015\t\r=6Q\u0017\t\u0005\u0005w\u001a\t,\u0003\u0003\u00044\u0006m%\u0001\t#fg\u000e\u0014\u0018NY3DY&,g\u000e^)v_R\f7OU3ta>t7/\u001a#bi\u0006Dqaa.3\u0001\u0004\u0019I,A\u0004sKF,Xm\u001d;\u0011\t\tm41X\u0005\u0005\u0007{\u000bYJA\u0010EKN\u001c'/\u001b2f\u00072LWM\u001c;Rk>$\u0018m\u001d*fcV,7\u000f\u001e#bi\u0006\f\u0001\u0004Z3tGJL'-Z*de\u0006l7I]3eK:$\u0018.\u00197t)\u0011\u0019\u0019m!3\u0011\t\tm4QY\u0005\u0005\u0007\u000f\fYJ\u0001\u0015EKN\u001c'/\u001b2f+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\\:SKN\u0004xN\\:f\t\u0006$\u0018\rC\u0004\u00048N\u0002\raa3\u0011\t\tm4QZ\u0005\u0005\u0007\u001f\fYJA\u0014EKN\u001c'/\u001b2f+N,'oU2sC6\u001c%/\u001a3f]RL\u0017\r\\:SKF,Xm\u001d;ECR\f\u0017aD7fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8\u0015\u0005\rU\u0007c\u00014\u0004X&\u00191\u0011\\4\u0003\u001f5+G/\u00193bi\u00064VM]:j_:\f\u0001BZ3biV\u0014Xm\u001d\u000b\u0003\u0007?\u00042AZBq\u0013\r\u0019\u0019o\u001a\u0002\u0012\r&t\u0017\r\\5{K\u00124U-\u0019;ve\u0016\u001c\b")
public class KRaftMetadataCache
implements MetadataCache,
Logging,
ConfigRepository {
    private final int brokerId;
    private final Supplier<KRaftVersion> kraftVersionSupplier;
    private volatile MetadataImage _currentImage;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public Properties topicConfig(String topicName) {
        return ConfigRepository.topicConfig$(this, topicName);
    }

    @Override
    public Properties brokerConfig(int brokerId) {
        return ConfigRepository.brokerConfig$(this, brokerId);
    }

    @Override
    public Properties groupConfig(String groupName) {
        return ConfigRepository.groupConfig$(this, groupName);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public Supplier<KRaftVersion> kraftVersionSupplier() {
        return this.kraftVersionSupplier;
    }

    private MetadataImage _currentImage() {
        return this._currentImage;
    }

    private void _currentImage_$eq(MetadataImage x$1) {
        this._currentImage = x$1;
    }

    private java.util.List<Integer> maybeFilterAliveReplicas(MetadataImage image, int[] brokers, ListenerName listenerName, boolean filterUnavailableEndpoints) {
        if (!filterUnavailableEndpoints) {
            return Replicas.toList((int[])brokers);
        }
        ArrayList<Integer> res = new ArrayList<Integer>(brokers.length);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(brokers), (Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Option$.MODULE$.apply((Object)image.cluster().broker(brokerId)).foreach((Function1 & Serializable)b -> {
            if (!b.fenced() && b.listeners().containsKey(listenerName.value())) {
                return BoxesRunTime.boxToBoolean((boolean)res.add(Predef$.MODULE$.int2Integer(brokerId)));
            }
            return BoxedUnit.UNIT;
        }));
        return res;
    }

    public MetadataImage currentImage() {
        return this._currentImage();
    }

    private Option<Iterator<MetadataResponseData.MetadataResponsePartition>> getPartitionMetadata(MetadataImage image, String topicName, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        Option option = Option$.MODULE$.apply((Object)image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            return new Some((Object)((IterableOnce)CollectionConverters$.MODULE$.SetHasAsScala(topic.partitions().entrySet()).asScala().map((Function1 & Serializable)entry -> {
                Integer partitionId = (Integer)entry.getKey();
                PartitionRegistration partition = (PartitionRegistration)entry.getValue();
                java.util.List<Integer> filteredReplicas = this.maybeFilterAliveReplicas(image, partition.replicas, listenerName, errorUnavailableEndpoints);
                java.util.List<Integer> filteredIsr = this.maybeFilterAliveReplicas(image, partition.isr, listenerName, errorUnavailableEndpoints);
                java.util.List<Integer> offlineReplicas = this.getOfflineReplicas(image, partition, listenerName);
                Option<Node> maybeLeader = this.getAliveEndpoint(image, partition.leader, listenerName);
                if (None$.MODULE$.equals(maybeLeader)) {
                    Errors errors;
                    if (!image.cluster().brokers().containsKey(BoxesRunTime.boxToInteger((int)partition.leader))) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> "Error while fetching metadata for " + topicName + "-" + partitionId + ": leader not available");
                        errors = Errors.LEADER_NOT_AVAILABLE;
                    } else {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> "Error while fetching metadata for " + topicName + "-" + partitionId + ": listener " + listenerName + " not found on leader " + partition$1.leader);
                        errors = errorUnavailableListeners ? Errors.LISTENER_NOT_FOUND : Errors.LEADER_NOT_AVAILABLE;
                    }
                    Errors error = errors;
                    return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex(Predef$.MODULE$.Integer2int(partitionId)).setLeaderId(-1).setLeaderEpoch(partition.leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                }
                if (maybeLeader instanceof Some) {
                    Errors errors;
                    Node leader = (Node)((Some)maybeLeader).value();
                    if (filteredReplicas.size() < partition.replicas.length) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> "Error while fetching metadata for " + topicName + "-" + partitionId + ": replica information not available for following brokers " + Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.intArrayOps(partition$1.replicas), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredReplicas.contains(x$1)))).mkString(","));
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else if (filteredIsr.size() < partition.isr.length) {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> "Error while fetching metadata for " + topicName + "-" + partitionId + ": in sync replica information not available for following brokers " + Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.intArrayOps(partition$1.isr), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredIsr.contains(x$1)))).mkString(","));
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else {
                        errors = Errors.NONE;
                    }
                    Errors error = errors;
                    return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex(Predef$.MODULE$.Integer2int(partitionId)).setLeaderId(leader.id()).setLeaderEpoch(partition.leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                }
                throw new MatchError(maybeLeader);
            })).iterator());
        }
        throw new MatchError((Object)option);
    }

    private Tuple2<Option<List<DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition>>, Object> getPartitionMetadataForDescribeTopicResponse(MetadataImage image, String topicName, ListenerName listenerName, int startIndex, int maxCount) {
        Option option = Option$.MODULE$.apply((Object)image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return new Tuple2((Object)None$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)-1));
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            ListBuffer result = new ListBuffer();
            java.util.Set partitions = topic.partitions().keySet();
            int upperIndex = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(topic.partitions().size()), startIndex + maxCount);
            int nextIndex = upperIndex < partitions.size() ? upperIndex : -1;
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(startIndex), upperIndex).foreach((Function1 & Serializable)partitionId -> KRaftMetadataCache.$anonfun$getPartitionMetadataForDescribeTopicResponse$1(this, topic, image, listenerName, result, topicName, BoxesRunTime.unboxToInt((Object)partitionId)));
            return new Tuple2((Object)new Some((Object)result.toList()), (Object)BoxesRunTime.boxToInteger((int)nextIndex));
        }
        throw new MatchError((Object)option);
    }

    private java.util.List<Integer> getOfflineReplicas(MetadataImage image, PartitionRegistration partition, ListenerName listenerName) {
        ArrayList<Integer> offlineReplicas = new ArrayList<Integer>(0);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(partition.replicas), (Function1 & Serializable)brokerId -> KRaftMetadataCache.$anonfun$getOfflineReplicas$1(this, image, offlineReplicas, partition, listenerName, BoxesRunTime.unboxToInt((Object)brokerId)));
        return offlineReplicas;
    }

    private boolean isReplicaOffline(PartitionRegistration partition, ListenerName listenerName, BrokerRegistration broker) {
        return broker.fenced() || !broker.listeners().containsKey(listenerName.value()) || this.isReplicaInOfflineDir(broker, partition);
    }

    private boolean isReplicaInOfflineDir(BrokerRegistration broker, PartitionRegistration partition) {
        return !broker.hasOnlineDir(partition.directory(broker.id()));
    }

    private Option<Node> getAliveEndpoint(MetadataImage image, int id, ListenerName listenerName) {
        return Option$.MODULE$.apply((Object)image.cluster().broker(id)).flatMap((Function1 & Serializable)x$1 -> OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(x$1.node(listenerName.value()))));
    }

    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        MetadataImage image = this._currentImage();
        return (Seq)topics.toSeq().flatMap((Function1 & Serializable)topic -> this.getPartitionMetadata(image, (String)topic, listenerName, errorUnavailableEndpoints, errorUnavailableListeners).map((Function1 & Serializable)partitionMetadata -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setName(topic).setTopicId((Uuid)Option$.MODULE$.apply((Object)image.topics().getTopic(topic).id()).getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID)).setIsInternal(Topic.isInternal((String)topic)).setPartitions(CollectionConverters$.MODULE$.BufferHasAsJava(partitionMetadata.toBuffer()).asJava())));
    }

    @Override
    public boolean getTopicMetadata$default$3() {
        return false;
    }

    @Override
    public boolean getTopicMetadata$default$4() {
        return false;
    }

    public DescribeTopicPartitionsResponseData getTopicMetadataForDescribeTopicResponse(Iterator<String> topics, ListenerName listenerName, Function1<String, Object> topicPartitionStartIndex, int maximumNumberOfPartitions, boolean ignoreTopicsWithExceptions) {
        MetadataImage image = this._currentImage();
        IntRef remaining = IntRef.create((int)maximumNumberOfPartitions);
        DescribeTopicPartitionsResponseData result = new DescribeTopicPartitionsResponseData();
        Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable)() -> topics.foreach((Function1 & Serializable)topicName -> {
            if (remaining$1.elem > 0) {
                void var9_9;
                Tuple2<Option<List<DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition>>, Object> tuple2 = this.getPartitionMetadataForDescribeTopicResponse(image, (String)topicName, listenerName, BoxesRunTime.unboxToInt((Object)topicPartitionStartIndex.apply(topicName)), remaining$1.elem);
                if (tuple2 == null) {
                    throw new MatchError(null);
                }
                Option partitionResponse = (Option)tuple2._1();
                int n = tuple2._2$mcI$sp();
                var9_9.map((Function1 & Serializable)partitions -> {
                    KRaftMetadataCache.$anonfun$getTopicMetadataForDescribeTopicResponse$3(topicName, image, result, n, remaining, partitions);
                    return BoxedUnit.UNIT;
                });
                if (!ignoreTopicsWithExceptions && var9_9.isEmpty()) {
                    Errors errors;
                    try {
                        Topic.validate((String)topicName);
                        errors = Errors.UNKNOWN_TOPIC_OR_PARTITION;
                    }
                    catch (InvalidTopicException invalidTopicException) {
                        errors = Errors.INVALID_TOPIC_EXCEPTION;
                    }
                    Errors error = errors;
                    return BoxesRunTime.boxToBoolean((boolean)result.topics().add((ImplicitLinkedHashCollection.Element)new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic().setErrorCode(error.code()).setName(topicName).setTopicId(this.getTopicId((String)topicName)).setIsInternal(Topic.isInternal((String)topicName))));
                }
                return BoxedUnit.UNIT;
            }
            if (remaining$1.elem == 0) {
                result.setNextCursor(new DescribeTopicPartitionsResponseData.Cursor().setTopicName(topicName).setPartitionIndex(0));
                throw Breaks$.MODULE$.break();
            }
            return BoxedUnit.UNIT;
        }));
        return result;
    }

    @Override
    public Set<String> getAllTopics() {
        return CollectionConverters$.MODULE$.SetHasAsScala(this._currentImage().topics().topicsByName().keySet()).asScala();
    }

    @Override
    public Set<TopicPartition> getTopicPartitions(String topicName) {
        Option option = Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return (Set)Set$.MODULE$.empty();
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            return (Set)CollectionConverters$.MODULE$.SetHasAsScala(topic.partitions().keySet()).asScala().map((Function1 & Serializable)x$3 -> new TopicPartition(topicName, Predef$.MODULE$.Integer2int(x$3)));
        }
        throw new MatchError((Object)option);
    }

    @Override
    public Uuid getTopicId(String topicName) {
        return (Uuid)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)this._currentImage().topics().topicsByName()).asScala().get((Object)topicName).map((Function1 & Serializable)x$4 -> x$4.id()).getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID);
    }

    @Override
    public Option<String> getTopicName(Uuid topicId) {
        return CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)this._currentImage().topics().topicsById()).asScala().get((Object)topicId).map((Function1 & Serializable)x$5 -> x$5.name());
    }

    @Override
    public boolean hasAliveBroker(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId))).count((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)KRaftMetadataCache.$anonfun$hasAliveBroker$1(x$6))) == 1;
    }

    public boolean isBrokerFenced(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId))).count((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.fenced())) == 1;
    }

    public boolean isBrokerShuttingDown(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId))).count((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.inControlledShutdown())) == 1;
    }

    @Override
    public Iterable<BrokerMetadata> getAliveBrokers() {
        return this.getAliveBrokers(this._currentImage());
    }

    private Iterable<BrokerMetadata> getAliveBrokers(MetadataImage image) {
        return (Iterable)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(image.cluster().brokers().values()).asScala().filterNot((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.fenced()))).map((Function1 & Serializable)b -> new BrokerMetadata(b.id(), b.rack()));
    }

    @Override
    public Option<Node> getAliveBrokerNode(int brokerId, ListenerName listenerName) {
        return Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId)).filterNot((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.fenced())).flatMap((Function1 & Serializable)x$11 -> OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(x$11.node(listenerName.value()))));
    }

    public Seq<Node> getAliveBrokerNodes(ListenerName listenerName) {
        return ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this._currentImage().cluster().brokers().values()).asScala().filterNot((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.fenced()))).flatMap((Function1 & Serializable)x$13 -> OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(x$13.node(listenerName.value()))))).toSeq();
    }

    public Seq<Node> getBrokerNodes(ListenerName listenerName) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this._currentImage().cluster().brokers().values()).asScala().flatMap((Function1 & Serializable)x$14 -> OptionConverters.RichOptional$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptional(x$14.node(listenerName.value()))))).toSeq();
    }

    @Override
    public Option<LeaderAndIsr> getLeaderAndIsr(String topicName, int partitionId) {
        return Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName)).flatMap((Function1 & Serializable)topic -> Option$.MODULE$.apply(topic.partitions().get(BoxesRunTime.boxToInteger((int)partitionId)))).flatMap((Function1 & Serializable)partition -> new Some((Object)new LeaderAndIsr(partition.leader, partition.leaderEpoch, Arrays.asList((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(partition.isr), (Function1 & Serializable)i -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(Integer.class))), partition.leaderRecoveryState, partition.partitionEpoch)));
    }

    @Override
    public Option<Object> numPartitions(String topicName) {
        return Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName)).map((Function1 & Serializable)topic -> BoxesRunTime.boxToInteger((int)KRaftMetadataCache.$anonfun$numPartitions$1(topic)));
    }

    @Override
    public java.util.Map<String, Uuid> topicNamesToIds() {
        return this._currentImage().topics().topicNameToIdView();
    }

    @Override
    public java.util.Map<Uuid, String> topicIdsToNames() {
        return this._currentImage().topics().topicIdToNameView();
    }

    @Override
    public Tuple2<java.util.Map<String, Uuid>, java.util.Map<Uuid, String>> topicIdInfo() {
        MetadataImage image = this._currentImage();
        return new Tuple2((Object)image.topics().topicNameToIdView(), (Object)image.topics().topicIdToNameView());
    }

    @Override
    public Option<Node> getPartitionLeaderEndpoint(String topicName, int partitionId, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        Option option = Option$.MODULE$.apply((Object)image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            Option option2 = Option$.MODULE$.apply(topic.partitions().get(BoxesRunTime.boxToInteger((int)partitionId)));
            if (None$.MODULE$.equals(option2)) {
                return None$.MODULE$;
            }
            if (option2 instanceof Some) {
                PartitionRegistration partition = (PartitionRegistration)((Some)option2).value();
                Option option3 = Option$.MODULE$.apply((Object)image.cluster().broker(partition.leader));
                if (None$.MODULE$.equals(option3)) {
                    return new Some((Object)Node.noNode());
                }
                if (option3 instanceof Some) {
                    BrokerRegistration broker = (BrokerRegistration)((Some)option3).value();
                    return new Some((Object)broker.node(listenerName.value()).orElse(Node.noNode()));
                }
                throw new MatchError((Object)option3);
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError((Object)option);
    }

    @Override
    public Map<Object, Node> getPartitionReplicaEndpoints(TopicPartition tp, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        scala.collection.mutable.HashMap result = new scala.collection.mutable.HashMap();
        Option$.MODULE$.apply((Object)image.topics().getTopic(tp.topic())).foreach((Function1 & Serializable)topic -> {
            KRaftMetadataCache.$anonfun$getPartitionReplicaEndpoints$1(tp, image, listenerName, result, topic);
            return BoxedUnit.UNIT;
        });
        return result;
    }

    @Override
    public Option<CachedControllerId> getControllerId() {
        return this.getRandomAliveBroker(this._currentImage()).map((Function1)KRaftCachedControllerId$.MODULE$);
    }

    @Override
    public Option<Object> getRandomAliveBrokerId() {
        return this.getRandomAliveBroker(this._currentImage());
    }

    private Option<Object> getRandomAliveBroker(MetadataImage image) {
        List aliveBrokers = this.getAliveBrokers(image).toList();
        if (aliveBrokers.isEmpty()) {
            return None$.MODULE$;
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)((BrokerMetadata)aliveBrokers.apply((int)ThreadLocalRandom.current().nextInt((int)aliveBrokers.size()))).id));
    }

    public Option<Object> getAliveBrokerEpoch(int brokerId) {
        return Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId)).filterNot((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)x$15.fenced())).map((Function1 & Serializable)brokerRegistration -> BoxesRunTime.boxToLong((long)brokerRegistration.epoch()));
    }

    @Override
    public Cluster getClusterMetadata(String clusterId, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        HashMap nodes = new HashMap();
        image.cluster().brokers().values().forEach(broker -> {
            if (!broker.fenced()) {
                OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(broker.node(listenerName.value()))).foreach((Function1 & Serializable)node -> nodes.put(Predef$.MODULE$.int2Integer(broker.id()), node));
                return;
            }
        });
        ArrayList partitionInfos = new ArrayList();
        HashSet internalTopics = new HashSet();
        image.topics().topicsByName().values().forEach(topic -> topic.partitions().forEach((key, value) -> {
            partitionInfos.add(new PartitionInfo(topic.name(), Predef$.MODULE$.Integer2int(key), KRaftMetadataCache.node$1(value.leader, nodes), (Node[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(value.replicas), (Function1 & Serializable)replica -> KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)replica), nodes), ClassTag$.MODULE$.apply(Node.class)), (Node[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(value.isr), (Function1 & Serializable)replica -> KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)replica), nodes), ClassTag$.MODULE$.apply(Node.class)), (Node[])((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.getOfflineReplicas(image, (PartitionRegistration)value, listenerName)).asScala().map((Function1 & Serializable)replica -> KRaftMetadataCache.node$1(Predef$.MODULE$.Integer2int(replica), nodes))).toArray(ClassTag$.MODULE$.apply(Node.class))));
            if (Topic.isInternal((String)topic.name())) {
                internalTopics.add(topic.name());
                return;
            }
        }));
        Node controllerNode = KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)this.getRandomAliveBroker(image).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1)), nodes);
        return new Cluster(clusterId, nodes.values(), partitionInfos, Collections.emptySet(), internalTopics, controllerNode);
    }

    @Override
    public boolean contains(String topicName) {
        return this._currentImage().topics().topicsByName().containsKey((Object)topicName);
    }

    @Override
    public boolean contains(TopicPartition tp) {
        Option option = Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(tp.topic()));
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            return ((TopicImage)((Some)option).value()).partitions().containsKey(BoxesRunTime.boxToInteger((int)tp.partition()));
        }
        throw new MatchError((Object)option);
    }

    public void setImage(MetadataImage newImage) {
        this._currentImage_$eq(newImage);
    }

    public MetadataImage getImage() {
        return this._currentImage();
    }

    @Override
    public Properties config(ConfigResource configResource) {
        return this._currentImage().configs().configProperties(configResource);
    }

    public DescribeClientQuotasResponseData describeClientQuotas(DescribeClientQuotasRequestData request) {
        return this._currentImage().clientQuotas().describe(request);
    }

    public DescribeUserScramCredentialsResponseData describeScramCredentials(DescribeUserScramCredentialsRequestData request) {
        return this._currentImage().scram().describe(request);
    }

    @Override
    public MetadataVersion metadataVersion() {
        return this._currentImage().features().metadataVersionOrThrow();
    }

    @Override
    public FinalizedFeatures features() {
        MetadataImage image = this._currentImage();
        HashMap<String, Short> finalizedFeatures = new HashMap<String, Short>(image.features().finalizedVersions());
        short kraftVersionLevel = this.kraftVersionSupplier().get().featureLevel();
        if (kraftVersionLevel > 0) {
            finalizedFeatures.put("kraft.version", Predef$.MODULE$.short2Short(kraftVersionLevel));
        }
        return new FinalizedFeatures(image.features().metadataVersionOrThrow(), finalizedFeatures, image.highestOffsetAndEpoch().offset(), true);
    }

    public static final /* synthetic */ Object $anonfun$getPartitionMetadataForDescribeTopicResponse$1(KRaftMetadataCache $this, TopicImage topic$1, MetadataImage image$3, ListenerName listenerName$3, ListBuffer result$1, String topicName$2, int partitionId) {
        PartitionRegistration partitionRegistration = (PartitionRegistration)topic$1.partitions().get(BoxesRunTime.boxToInteger((int)partitionId));
        if (partitionRegistration != null) {
            java.util.List<Integer> filteredReplicas = $this.maybeFilterAliveReplicas(image$3, partitionRegistration.replicas, listenerName$3, false);
            java.util.List<Integer> filteredIsr = $this.maybeFilterAliveReplicas(image$3, partitionRegistration.isr, listenerName$3, false);
            java.util.List<Integer> offlineReplicas = $this.getOfflineReplicas(image$3, partitionRegistration, listenerName$3);
            Option<Node> maybeLeader = $this.getAliveEndpoint(image$3, partitionRegistration.leader, listenerName$3);
            if (None$.MODULE$.equals(maybeLeader)) {
                return (ListBuffer)result$1.append((Object)new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition().setPartitionIndex(partitionId).setLeaderId(-1).setLeaderEpoch(partitionRegistration.leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas).setEligibleLeaderReplicas(Replicas.toList((int[])partitionRegistration.elr)).setLastKnownElr(Replicas.toList((int[])partitionRegistration.lastKnownElr)));
            }
            if (maybeLeader instanceof Some) {
                Node leader = (Node)((Some)maybeLeader).value();
                return (ListBuffer)result$1.append((Object)new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition().setPartitionIndex(partitionId).setLeaderId(leader.id()).setLeaderEpoch(partitionRegistration.leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas).setEligibleLeaderReplicas(Replicas.toList((int[])partitionRegistration.elr)).setLastKnownElr(Replicas.toList((int[])partitionRegistration.lastKnownElr)));
            }
            throw new MatchError(maybeLeader);
        }
        $this.warn((Function0<String>)(Function0 & Serializable)() -> "The partition " + partitionId + " does not exist for " + topicName$2);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$getOfflineReplicas$1(KRaftMetadataCache $this, MetadataImage image$4, ArrayList offlineReplicas$1, PartitionRegistration partition$2, ListenerName listenerName$4, int brokerId) {
        Option option = Option$.MODULE$.apply((Object)image$4.cluster().broker(brokerId));
        if (None$.MODULE$.equals(option)) {
            return BoxesRunTime.boxToBoolean((boolean)offlineReplicas$1.add(Predef$.MODULE$.int2Integer(brokerId)));
        }
        if (option instanceof Some) {
            BrokerRegistration broker = (BrokerRegistration)((Some)option).value();
            if ($this.isReplicaOffline(partition$2, listenerName$4, broker)) {
                return BoxesRunTime.boxToBoolean((boolean)offlineReplicas$1.add(Predef$.MODULE$.int2Integer(brokerId)));
            }
            return BoxedUnit.UNIT;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ void $anonfun$getTopicMetadataForDescribeTopicResponse$3(String topicName$3, MetadataImage image$6, DescribeTopicPartitionsResponseData result$2, int nextPartition$1, IntRef remaining$1, List partitions) {
        DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic response = new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic().setErrorCode(Errors.NONE.code()).setName(topicName$3).setTopicId((Uuid)Option$.MODULE$.apply((Object)image$6.topics().getTopic(topicName$3).id()).getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID)).setIsInternal(Topic.isInternal((String)topicName$3)).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)partitions).asJava());
        result$2.topics().add((ImplicitLinkedHashCollection.Element)response);
        if (nextPartition$1 != -1) {
            result$2.setNextCursor(new DescribeTopicPartitionsResponseData.Cursor().setTopicName(topicName$3).setPartitionIndex(nextPartition$1));
            throw Breaks$.MODULE$.break();
        }
        remaining$1.elem -= partitions.size();
    }

    public static final /* synthetic */ boolean $anonfun$hasAliveBroker$1(BrokerRegistration x$6) {
        return !x$6.fenced();
    }

    public static final /* synthetic */ int $anonfun$numPartitions$1(TopicImage topic) {
        return topic.partitions().size();
    }

    public static final /* synthetic */ void $anonfun$getPartitionReplicaEndpoints$1(TopicPartition tp$1, MetadataImage image$7, ListenerName listenerName$11, scala.collection.mutable.HashMap result$3, TopicImage topic) {
        Option$.MODULE$.apply(topic.partitions().get(BoxesRunTime.boxToInteger((int)tp$1.partition()))).foreach((Function1 & Serializable)partition -> {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(partition.replicas), (Function1)(JFunction1.mcVI.sp & Serializable)replicaId -> {
                BrokerRegistration broker = image$7.cluster().broker(replicaId);
                if (broker != null && !broker.fenced()) {
                    broker.node(listenerName$11.value()).ifPresent(node -> {
                        if (!node.isEmpty()) {
                            result$3.put((Object)BoxesRunTime.boxToInteger((int)replicaId), node);
                            return;
                        }
                    });
                    return;
                }
            });
            return BoxedUnit.UNIT;
        });
    }

    private static final Node node$1(int id, HashMap nodes$1) {
        return (Node)Option$.MODULE$.apply(nodes$1.get(BoxesRunTime.boxToInteger((int)id))).getOrElse((Function0 & Serializable)() -> Node.noNode());
    }

    public KRaftMetadataCache(int brokerId, Supplier<KRaftVersion> kraftVersionSupplier) {
        this.brokerId = brokerId;
        this.kraftVersionSupplier = kraftVersionSupplier;
        this.logIdent_$eq("[MetadataCache brokerId=" + brokerId + "] ");
        this._currentImage = MetadataImage.EMPTY;
    }
}

