/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.config;

import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.config.ServerTopicConfigSynonyms;
import org.apache.kafka.server.record.BrokerCompressionType;
import org.apache.kafka.storage.internals.log.LogConfig;

public class ServerConfigs {
    public static final String BROKER_ID_CONFIG = "broker.id";
    public static final int BROKER_ID_DEFAULT = -1;
    public static final String BROKER_ID_DOC = "The broker id for this server.";
    public static final String MESSAGE_MAX_BYTES_CONFIG = "message.max.bytes";
    public static final String MESSAGE_MAX_BYTES_DOC = "The largest record batch size allowed by Kafka (after compression if compression is enabled). If this is increased and there are consumers older than 0.10.2, the consumers' fetch size must also be increased so that they can fetch record batches this large. In the latest message format version, records are always grouped into batches for efficiency. In previous message format versions, uncompressed records are not grouped into batches and this limit only applies to a single record in that case.This can be set per topic with the topic level <code>max.message.bytes</code> config.";
    public static final String NUM_IO_THREADS_CONFIG = "num.io.threads";
    public static final int NUM_IO_THREADS_DEFAULT = 8;
    public static final String NUM_IO_THREADS_DOC = "The number of threads that the server uses for processing requests, which may include disk I/O";
    public static final String BACKGROUND_THREADS_CONFIG = "background.threads";
    public static final int BACKGROUND_THREADS_DEFAULT = 10;
    public static final String BACKGROUND_THREADS_DOC = "The number of threads to use for various background processing tasks";
    public static final String NUM_REPLICA_ALTER_LOG_DIRS_THREADS_CONFIG = "num.replica.alter.log.dirs.threads";
    public static final String NUM_REPLICA_ALTER_LOG_DIRS_THREADS_DOC = "The number of threads that can move replicas between log directories, which may include disk I/O. The default value is equal to the number of directories specified in the <code>log.dir</code> or <code>log.dirs</code> configuration property.";
    public static final String REQUEST_TIMEOUT_MS_CONFIG = "request.timeout.ms";
    public static final int REQUEST_TIMEOUT_MS_DEFAULT = 30000;
    public static final String REQUEST_TIMEOUT_MS_DOC = "The configuration controls the maximum amount of time the client will wait for the response of a request. If the response is not received before the timeout elapses the client will resend the request if necessary or fail the request if retries are exhausted.";
    public static final String SOCKET_CONNECTION_SETUP_TIMEOUT_MS_CONFIG = "socket.connection.setup.timeout.ms";
    public static final long DEFAULT_SOCKET_CONNECTION_SETUP_TIMEOUT_MS = CommonClientConfigs.DEFAULT_SOCKET_CONNECTION_SETUP_TIMEOUT_MS;
    public static final String SOCKET_CONNECTION_SETUP_TIMEOUT_MS_DOC = "The amount of time the client will wait for the socket connection to be established. If the connection is not built before the timeout elapses, clients will close the socket channel. This value is the initial backoff value and will increase exponentially for each consecutive connection failure, up to the <code>socket.connection.setup.timeout.max.ms</code> value.";
    public static final String SOCKET_CONNECTION_SETUP_TIMEOUT_MAX_MS_CONFIG = "socket.connection.setup.timeout.max.ms";
    public static final long SOCKET_CONNECTION_SETUP_TIMEOUT_MAX_MS = CommonClientConfigs.DEFAULT_SOCKET_CONNECTION_SETUP_TIMEOUT_MAX_MS;
    public static final String SOCKET_CONNECTION_SETUP_TIMEOUT_MAX_MS_DOC = "The maximum amount of time the client will wait for the socket connection to be established. The connection setup timeout will increase exponentially for each consecutive connection failure up to this maximum. To avoid connection storms, a randomization factor of 0.2 will be applied to the timeout resulting in a random range between 20% below and 20% above the computed value.";
    public static final String DELETE_TOPIC_ENABLE_CONFIG = "delete.topic.enable";
    public static final boolean DELETE_TOPIC_ENABLE_DEFAULT = true;
    public static final String DELETE_TOPIC_ENABLE_DOC = "Enables delete topic. Delete topic through the admin tool will have no effect if this config is turned off";
    public static final String COMPRESSION_TYPE_CONFIG = ServerTopicConfigSynonyms.serverSynonym((String)"compression.type");
    public static final String COMPRESSION_TYPE_DOC = "Specify the final compression type for a given topic. This configuration accepts the standard compression codecs ('gzip', 'snappy', 'lz4', 'zstd'). It additionally accepts 'uncompressed' which is equivalent to no compression; and 'producer' which means retain the original compression codec set by the producer.";
    public static final String COMPRESSION_GZIP_LEVEL_CONFIG = ServerTopicConfigSynonyms.serverSynonym((String)"compression.gzip.level");
    public static final String COMPRESSION_GZIP_LEVEL_DOC = "The compression level to use if " + COMPRESSION_TYPE_CONFIG + " is set to 'gzip'.";
    public static final String COMPRESSION_LZ4_LEVEL_CONFIG = ServerTopicConfigSynonyms.serverSynonym((String)"compression.lz4.level");
    public static final String COMPRESSION_LZ4_LEVEL_DOC = "The compression level to use if " + COMPRESSION_TYPE_CONFIG + " is set to 'lz4'.";
    public static final String COMPRESSION_ZSTD_LEVEL_CONFIG = ServerTopicConfigSynonyms.serverSynonym((String)"compression.zstd.level");
    public static final String COMPRESSION_ZSTD_LEVEL_DOC = "The compression level to use if " + COMPRESSION_TYPE_CONFIG + " is set to 'zstd'.";
    public static final String BROKER_RACK_CONFIG = "broker.rack";
    public static final String BROKER_RACK_DOC = "Rack of the broker. This will be used in rack aware replication assignment for fault tolerance. Examples: <code>RACK1</code>, <code>us-east-1d</code>";
    public static final String CONTROLLED_SHUTDOWN_ENABLE_CONFIG = "controlled.shutdown.enable";
    public static final boolean CONTROLLED_SHUTDOWN_ENABLE_DEFAULT = true;
    public static final String CONTROLLED_SHUTDOWN_ENABLE_DOC = "Enable controlled shutdown of the server.";
    public static final String MAX_INCREMENTAL_FETCH_SESSION_CACHE_SLOTS_CONFIG = "max.incremental.fetch.session.cache.slots";
    public static final int MAX_INCREMENTAL_FETCH_SESSION_CACHE_SLOTS_DEFAULT = 1000;
    public static final String MAX_INCREMENTAL_FETCH_SESSION_CACHE_SLOTS_DOC = "The maximum number of total incremental fetch sessions that we will maintain. FetchSessionCache is sharded into 8 shards and the limit is equally divided among all shards. Sessions are allocated to each shard in round-robin. Only entries within a shard are considered eligible for eviction.";
    public static final String FETCH_MAX_BYTES_CONFIG = "fetch.max.bytes";
    public static final int FETCH_MAX_BYTES_DEFAULT = 0x3700000;
    public static final String FETCH_MAX_BYTES_DOC = "The maximum number of bytes we will return for a fetch request. Must be at least 1024.";
    public static final String MAX_REQUEST_PARTITION_SIZE_LIMIT_CONFIG = "max.request.partition.size.limit";
    public static final int MAX_REQUEST_PARTITION_SIZE_LIMIT_DEFAULT = 2000;
    public static final String MAX_REQUEST_PARTITION_SIZE_LIMIT_DOC = "The maximum number of partitions can be served in one request.";
    public static final String UNSTABLE_API_VERSIONS_ENABLE_CONFIG = "unstable.api.versions.enable";
    public static final String UNSTABLE_FEATURE_VERSIONS_ENABLE_CONFIG = "unstable.feature.versions.enable";
    public static final String AUTHORIZER_CLASS_NAME_CONFIG = "authorizer.class.name";
    public static final String AUTHORIZER_CLASS_NAME_DEFAULT = "";
    public static final String AUTHORIZER_CLASS_NAME_DOC = "The fully qualified name of a class that implements <code>" + Authorizer.class.getName() + "</code> interface, which is used by the broker for authorization.";
    public static final String EARLY_START_LISTENERS_CONFIG = "early.start.listeners";
    public static final String EARLY_START_LISTENERS_DOC = "A comma-separated list of listener names which may be started before the authorizer has finished initialization. This is useful when the authorizer is dependent on the cluster itself for bootstrapping, as is the case for the StandardAuthorizer (which stores ACLs in the metadata log.) By default, all listeners included in controller.listener.names will also be early start listeners. A listener should not appear in this list if it accepts external traffic.";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("broker.id", ConfigDef.Type.INT, (Object)-1, ConfigDef.Importance.HIGH, "The broker id for this server.").define("message.max.bytes", ConfigDef.Type.INT, (Object)0x10000C, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.HIGH, "The largest record batch size allowed by Kafka (after compression if compression is enabled). If this is increased and there are consumers older than 0.10.2, the consumers' fetch size must also be increased so that they can fetch record batches this large. In the latest message format version, records are always grouped into batches for efficiency. In previous message format versions, uncompressed records are not grouped into batches and this limit only applies to a single record in that case.This can be set per topic with the topic level <code>max.message.bytes</code> config.").define("num.io.threads", ConfigDef.Type.INT, (Object)8, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "The number of threads that the server uses for processing requests, which may include disk I/O").define("num.replica.alter.log.dirs.threads", ConfigDef.Type.INT, null, ConfigDef.Importance.HIGH, "The number of threads that can move replicas between log directories, which may include disk I/O. The default value is equal to the number of directories specified in the <code>log.dir</code> or <code>log.dirs</code> configuration property.").define("background.threads", ConfigDef.Type.INT, (Object)10, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "The number of threads to use for various background processing tasks").define("request.timeout.ms", ConfigDef.Type.INT, (Object)30000, ConfigDef.Importance.HIGH, "The configuration controls the maximum amount of time the client will wait for the response of a request. If the response is not received before the timeout elapses the client will resend the request if necessary or fail the request if retries are exhausted.").define("socket.connection.setup.timeout.ms", ConfigDef.Type.LONG, (Object)DEFAULT_SOCKET_CONNECTION_SETUP_TIMEOUT_MS, ConfigDef.Importance.MEDIUM, "The amount of time the client will wait for the socket connection to be established. If the connection is not built before the timeout elapses, clients will close the socket channel. This value is the initial backoff value and will increase exponentially for each consecutive connection failure, up to the <code>socket.connection.setup.timeout.max.ms</code> value.").define("socket.connection.setup.timeout.max.ms", ConfigDef.Type.LONG, (Object)SOCKET_CONNECTION_SETUP_TIMEOUT_MAX_MS, ConfigDef.Importance.MEDIUM, "The maximum amount of time the client will wait for the socket connection to be established. The connection setup timeout will increase exponentially for each consecutive connection failure up to this maximum. To avoid connection storms, a randomization factor of 0.2 will be applied to the timeout resulting in a random range between 20% below and 20% above the computed value.").define("authorizer.class.name", ConfigDef.Type.STRING, (Object)"", (ConfigDef.Validator)new ConfigDef.NonNullValidator(), ConfigDef.Importance.LOW, AUTHORIZER_CLASS_NAME_DOC).define("early.start.listeners", ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, "A comma-separated list of listener names which may be started before the authorizer has finished initialization. This is useful when the authorizer is dependent on the cluster itself for bootstrapping, as is the case for the StandardAuthorizer (which stores ACLs in the metadata log.) By default, all listeners included in controller.listener.names will also be early start listeners. A listener should not appear in this list if it accepts external traffic.").define("broker.rack", ConfigDef.Type.STRING, null, ConfigDef.Importance.MEDIUM, "Rack of the broker. This will be used in rack aware replication assignment for fault tolerance. Examples: <code>RACK1</code>, <code>us-east-1d</code>").define("controlled.shutdown.enable", ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.MEDIUM, "Enable controlled shutdown of the server.").define("delete.topic.enable", ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.HIGH, "Enables delete topic. Delete topic through the admin tool will have no effect if this config is turned off").define(COMPRESSION_TYPE_CONFIG, ConfigDef.Type.STRING, (Object)LogConfig.DEFAULT_COMPRESSION_TYPE, (ConfigDef.Validator)ConfigDef.ValidString.in((String[])BrokerCompressionType.names().toArray(new String[0])), ConfigDef.Importance.HIGH, "Specify the final compression type for a given topic. This configuration accepts the standard compression codecs ('gzip', 'snappy', 'lz4', 'zstd'). It additionally accepts 'uncompressed' which is equivalent to no compression; and 'producer' which means retain the original compression codec set by the producer.").define(COMPRESSION_GZIP_LEVEL_CONFIG, ConfigDef.Type.INT, (Object)CompressionType.GZIP.defaultLevel(), CompressionType.GZIP.levelValidator(), ConfigDef.Importance.MEDIUM, COMPRESSION_GZIP_LEVEL_DOC).define(COMPRESSION_LZ4_LEVEL_CONFIG, ConfigDef.Type.INT, (Object)CompressionType.LZ4.defaultLevel(), CompressionType.LZ4.levelValidator(), ConfigDef.Importance.MEDIUM, COMPRESSION_LZ4_LEVEL_DOC).define(COMPRESSION_ZSTD_LEVEL_CONFIG, ConfigDef.Type.INT, (Object)CompressionType.ZSTD.defaultLevel(), CompressionType.ZSTD.levelValidator(), ConfigDef.Importance.MEDIUM, COMPRESSION_ZSTD_LEVEL_DOC).define("max.incremental.fetch.session.cache.slots", ConfigDef.Type.INT, (Object)1000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "The maximum number of total incremental fetch sessions that we will maintain. FetchSessionCache is sharded into 8 shards and the limit is equally divided among all shards. Sessions are allocated to each shard in round-robin. Only entries within a shard are considered eligible for eviction.").define("fetch.max.bytes", ConfigDef.Type.INT, (Object)0x3700000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1024), ConfigDef.Importance.MEDIUM, "The maximum number of bytes we will return for a fetch request. Must be at least 1024.").define("max.request.partition.size.limit", ConfigDef.Type.INT, (Object)2000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The maximum number of partitions can be served in one request.").defineInternal("unstable.api.versions.enable", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.HIGH).defineInternal("unstable.feature.versions.enable", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.HIGH);
}

