/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.server.ForwardingManagerMetrics$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Percentile;
import org.apache.kafka.common.metrics.stats.Percentiles;
import scala.Function1;
import scala.Long$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005}e\u0001B\u0015+\u0005=B\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u0013\")q\n\u0001C\u0005!\"9Q\u000b\u0001b\u0001\n\u00031\u0006bBA>\u0001\u0001\u0006Ia\u0016\u0005\t\u0003{\u0002!\u0019!C\u0001-\"9\u0011q\u0010\u0001!\u0002\u00139\u0006\"CAA\u0001\t\u0007I\u0011AA\b\u0011!\t\u0019\t\u0001Q\u0001\n\u0005E\u0001\"CAC\u0001\t\u0007I\u0011AAD\u0011!\ti\n\u0001Q\u0001\n\u0005%\u0005bBA\u0010\u0001\u0011\u0005\u0013\u0011E\u0004\u00063*B\tA\u0017\u0004\u0006S)B\ta\u0017\u0005\u0006\u001f:!\ta\u0018\u0005\bA:\u0011\r\u0011\"\u0001b\u0011\u0019)g\u0002)A\u0005E\"9aM\u0004b\u0001\n\u0003\t\u0007BB4\u000fA\u0003%!\rC\u0004i\u001d\t\u0007I\u0011A1\t\r%t\u0001\u0015!\u0003c\r\u0011QgBA6\t\u0011m2\"\u0011!Q\u0001\nqB\u0001\u0002\u001c\f\u0003\u0002\u0003\u0006I!\u001c\u0005\toZ\u0011\t\u0011)A\u0005[\"A\u0001P\u0006B\u0001B\u0003%\u0011\nC\u0003P-\u0011\u0005\u0011\u0010C\u0005\u0002\u0002Y\u0011\r\u0011\"\u0003\u0002\u0004!A\u00111\u0002\f!\u0002\u0013\t)\u0001C\u0005\u0002\u000eY\u0011\r\u0011\"\u0001\u0002\u0010!A\u0011\u0011\u0004\f!\u0002\u0013\t\t\u0002C\u0005\u0002\u001cY\u0011\r\u0011\"\u0001\u0002\u0010!A\u0011Q\u0004\f!\u0002\u0013\t\t\u0002C\u0004\u0002 Y!\t%!\t\t\u000f\u0005%b\u0003\"\u0001\u0002,\u00191\u0011\u0011\u0007\b\u0007\u0003gA!\"a\u0015%\u0005\u0003\u0005\u000b\u0011BA+\u0011\u0019yE\u0005\"\u0001\u0002\\!9\u0011\u0011\r\u0013\u0005B\u0005\r\u0004bBA:\u001d\u0011\u0005\u0011Q\u000f\u0002\u0019\r>\u0014x/\u0019:eS:<W*\u00198bO\u0016\u0014X*\u001a;sS\u000e\u001c(BA\u0016-\u0003\u0019\u0019XM\u001d<fe*\tQ&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001\u0001\u0004\b\u0005\u00022m5\t!G\u0003\u00024i\u0005!A.\u00198h\u0015\u0005)\u0014\u0001\u00026bm\u0006L!a\u000e\u001a\u0003\r=\u0013'.Z2u!\t\t\u0014(\u0003\u0002;e\ti\u0011)\u001e;p\u00072|7/Z1cY\u0016\fq!\\3ue&\u001c7\u000f\u0005\u0002>\r6\taH\u0003\u0002<\u007f)\u0011\u0001)Q\u0001\u0007G>lWn\u001c8\u000b\u00055\u0012%BA\"E\u0003\u0019\t\u0007/Y2iK*\tQ)A\u0002pe\u001eL!a\u0012 \u0003\u000f5+GO]5dg\u0006IA/[7f_V$Xj\u001d\t\u0003\u00156k\u0011a\u0013\u0006\u0002\u0019\u0006)1oY1mC&\u0011aj\u0013\u0002\u0005\u0019>tw-\u0001\u0004=S:LGO\u0010\u000b\u0004#N#\u0006C\u0001*\u0001\u001b\u0005Q\u0003\"B\u001e\u0004\u0001\u0004a\u0004\"\u0002%\u0004\u0001\u0004I\u0015aD9vKV,G+[7f\u001bND\u0015n\u001d;\u0016\u0003]\u0003\"\u0001\u0017\f\u000f\u0005Ik\u0011\u0001\u0007$pe^\f'\u000fZ5oO6\u000bg.Y4fe6+GO]5dgB\u0011!KD\n\u0003\u001dq\u0003\"AS/\n\u0005y[%AB!osJ+g\rF\u0001[\u0003=iW\r\u001e:jG\u001e\u0013x.\u001e9OC6,W#\u00012\u0011\u0005E\u001a\u0017B\u000133\u0005\u0019\u0019FO]5oO\u0006\u0001R.\u001a;sS\u000e<%o\\;q\u001d\u0006lW\rI\u0001\u0010cV,W/\u001a+j[\u0016l5OT1nK\u0006\u0001\u0012/^3vKRKW.Z't\u001d\u0006lW\rI\u0001\u0011e\u0016lw\u000e^3US6,Wj\u001d(b[\u0016\f\u0011C]3n_R,G+[7f\u001bNt\u0015-\\3!\u0005Aa\u0015\r^3oGfD\u0015n\u001d;pOJ\fWnE\u0002\u0017aa\nAA\\1nKB\u0011a.\u001e\b\u0003_N\u0004\"\u0001]&\u000e\u0003ET!A\u001d\u0018\u0002\rq\u0012xn\u001c;?\u0013\t!8*\u0001\u0004Qe\u0016$WMZ\u0005\u0003IZT!\u0001^&\u0002\u000b\u001d\u0014x.\u001e9\u0002\u00155\f\u0007\u0010T1uK:\u001c\u0017\u0010F\u0003{yvtx\u0010\u0005\u0002|-5\ta\u0002C\u0003<7\u0001\u0007A\bC\u0003m7\u0001\u0007Q\u000eC\u0003x7\u0001\u0007Q\u000eC\u0003y7\u0001\u0007\u0011*\u0001\u0004tK:\u001cxN]\u000b\u0003\u0003\u000b\u00012!PA\u0004\u0013\r\tIA\u0010\u0002\u0007'\u0016t7o\u001c:\u0002\u000fM,gn]8sA\u0005qA.\u0019;f]\u000eL\b+O\u001dOC6,WCAA\t!\u0011\t\u0019\"!\u0006\u000e\u0003}J1!a\u0006@\u0005)iU\r\u001e:jG:\u000bW.Z\u0001\u0010Y\u0006$XM\\2z!fJd*Y7fA\u0005yA.\u0019;f]\u000eL\b+O\u001d:\u001d\u0006lW-\u0001\tmCR,gnY=QseJd*Y7fA\u0005)1\r\\8tKR\u0011\u00111\u0005\t\u0004\u0015\u0006\u0015\u0012bAA\u0014\u0017\n!QK\\5u\u0003\u0019\u0011XmY8sIR!\u00111EA\u0017\u0011\u0019\tyc\ta\u0001\u0013\u0006IA.\u0019;f]\u000eLXj\u001d\u0002\n\rVt7mR1vO\u0016,B!!\u000e\u0002BM!A\u0005MA\u001c!\u0015i\u0014\u0011HA\u001f\u0013\r\tYD\u0010\u0002\u0006\u000f\u0006,x-\u001a\t\u0005\u0003\u007f\t\t\u0005\u0004\u0001\u0005\u000f\u0005\rCE1\u0001\u0002F\t\tA+\u0005\u0003\u0002H\u00055\u0003c\u0001&\u0002J%\u0019\u00111J&\u0003\u000f9{G\u000f[5oOB\u0019!*a\u0014\n\u0007\u0005E3JA\u0002B]f\fAAZ;oGB1!*a\u0016J\u0003{I1!!\u0017L\u0005%1UO\\2uS>t\u0017\u0007\u0006\u0003\u0002^\u0005}\u0003\u0003B>%\u0003{Aq!a\u0015'\u0001\u0004\t)&A\u0003wC2,X\r\u0006\u0004\u0002>\u0005\u0015\u0014q\u000e\u0005\b\u0003O:\u0003\u0019AA5\u0003\u0019\u0019wN\u001c4jOB\u0019Q(a\u001b\n\u0007\u00055dH\u0001\u0007NKR\u0014\u0018nY\"p]\u001aLw\r\u0003\u0004\u0002r\u001d\u0002\r!S\u0001\u0004]><\u0018!B1qa2LH#B)\u0002x\u0005e\u0004\"B\u001e)\u0001\u0004a\u0004\"\u0002%)\u0001\u0004I\u0015\u0001E9vKV,G+[7f\u001bND\u0015n\u001d;!\u0003A\u0011X-\\8uKRKW.Z't\u0011&\u001cH/A\tsK6|G/\u001a+j[\u0016l5\u000fS5ti\u0002\nq\"];fk\u0016dUM\\4uQ:\u000bW.Z\u0001\u0011cV,W/\u001a'f]\u001e$\bNT1nK\u0002\n1\"];fk\u0016dUM\\4uQV\u0011\u0011\u0011\u0012\t\u0005\u0003\u0017\u000bI*\u0004\u0002\u0002\u000e*!\u0011qRAI\u0003\u0019\tGo\\7jG*!\u00111SAK\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\u0003/#\u0014\u0001B;uS2LA!a'\u0002\u000e\ni\u0011\t^8nS\u000eLe\u000e^3hKJ\fA\"];fk\u0016dUM\\4uQ\u0002\u0002")
public final class ForwardingManagerMetrics
implements AutoCloseable {
    private final Metrics metrics;
    private final LatencyHistogram queueTimeMsHist;
    private final LatencyHistogram remoteTimeMsHist;
    private final MetricName queueLengthName;
    private final AtomicInteger queueLength;

    public static ForwardingManagerMetrics apply(Metrics metrics, long timeoutMs) {
        return new ForwardingManagerMetrics(metrics, timeoutMs);
    }

    public static String remoteTimeMsName() {
        return ForwardingManagerMetrics$.MODULE$.remoteTimeMsName();
    }

    public static String queueTimeMsName() {
        return ForwardingManagerMetrics$.MODULE$.queueTimeMsName();
    }

    public static String metricGroupName() {
        return ForwardingManagerMetrics$.MODULE$.metricGroupName();
    }

    public LatencyHistogram queueTimeMsHist() {
        return this.queueTimeMsHist;
    }

    public LatencyHistogram remoteTimeMsHist() {
        return this.remoteTimeMsHist;
    }

    public MetricName queueLengthName() {
        return this.queueLengthName;
    }

    public AtomicInteger queueLength() {
        return this.queueLength;
    }

    @Override
    public void close() {
        this.queueTimeMsHist().close();
        this.remoteTimeMsHist().close();
        this.metrics.removeMetric(this.queueLengthName());
    }

    public ForwardingManagerMetrics(Metrics metrics, long timeoutMs) {
        this.metrics = metrics;
        this.queueTimeMsHist = new LatencyHistogram(metrics, ForwardingManagerMetrics$.MODULE$.queueTimeMsName(), ForwardingManagerMetrics$.MODULE$.metricGroupName(), timeoutMs);
        this.remoteTimeMsHist = new LatencyHistogram(metrics, ForwardingManagerMetrics$.MODULE$.remoteTimeMsName(), ForwardingManagerMetrics$.MODULE$.metricGroupName(), timeoutMs);
        this.queueLengthName = metrics.metricName("QueueLength", ForwardingManagerMetrics$.MODULE$.metricGroupName(), "The current number of RPCs that are waiting in the broker's forwarding manager queue, waiting to be sent to the controller.");
        this.queueLength = new AtomicInteger(0);
        metrics.addMetric(this.queueLengthName(), new FuncGauge((JFunction1.mcIJ.sp & Serializable)x$1 -> this.queueLength().get()));
    }

    private static final class FuncGauge<T>
    implements Gauge<T> {
        private final Function1<Object, T> func;

        public T value(MetricConfig config, long now) {
            return (T)this.func.apply((Object)BoxesRunTime.boxToLong((long)now));
        }

        public FuncGauge(Function1<Object, T> func) {
            this.func = func;
        }
    }

    public static final class LatencyHistogram
    implements AutoCloseable {
        private final Metrics metrics;
        private final String name;
        private final Sensor sensor;
        private final MetricName latencyP99Name;
        private final MetricName latencyP999Name;

        private Sensor sensor() {
            return this.sensor;
        }

        public MetricName latencyP99Name() {
            return this.latencyP99Name;
        }

        public MetricName latencyP999Name() {
            return this.latencyP999Name;
        }

        @Override
        public void close() {
            this.metrics.removeSensor(this.name);
            this.metrics.removeMetric(this.latencyP99Name());
            this.metrics.removeMetric(this.latencyP999Name());
        }

        public void record(long latencyMs) {
            this.sensor().record((double)latencyMs);
        }

        /*
         * WARNING - void declaration
         */
        public LatencyHistogram(Metrics metrics, String name, String group, long maxLatency) {
            void add_stat;
            this.metrics = metrics;
            this.name = name;
            this.sensor = metrics.sensor(name);
            this.latencyP99Name = metrics.metricName(new StringBuilder(4).append(name).append(".p99").toString(), group);
            this.latencyP999Name = metrics.metricName(new StringBuilder(5).append(name).append(".p999").toString(), group);
            Sensor sensor = this.sensor();
            Percentiles percentiles = new Percentiles(4000, Long$.MODULE$.long2double(maxLatency), Percentiles.BucketSizing.CONSTANT, new Percentile[]{new Percentile(this.latencyP99Name(), 99.0), new Percentile(this.latencyP999Name(), 99.9)});
            if (sensor == null) {
                throw null;
            }
            sensor.add((CompoundStat)add_stat, null);
        }
    }
}

