/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.message.KRaftVersionRecord;
import org.apache.kafka.common.message.LeaderChangeMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.apache.kafka.raft.ElectionState;
import org.apache.kafka.raft.Endpoints;
import org.apache.kafka.raft.EpochState;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.RaftUtil;
import org.apache.kafka.raft.ReplicaKey;
import org.apache.kafka.raft.VoterSet;
import org.apache.kafka.raft.internals.AddVoterHandlerState;
import org.apache.kafka.raft.internals.BatchAccumulator;
import org.apache.kafka.raft.internals.RemoveVoterHandlerState;
import org.apache.kafka.server.common.KRaftVersion;
import org.slf4j.Logger;

public class LeaderState<T>
implements EpochState {
    static final long OBSERVER_SESSION_TIMEOUT_MS = 300000L;
    static final double CHECK_QUORUM_TIMEOUT_FACTOR = 1.5;
    private final ReplicaKey localReplicaKey;
    private final int epoch;
    private final long epochStartOffset;
    private final Set<Integer> grantingVoters;
    private final Endpoints localListeners;
    private final VoterSet voterSetAtEpochStart;
    private final OptionalLong offsetOfVotersAtEpochStart;
    private final KRaftVersion kraftVersionAtEpochStart;
    private Optional<LogOffsetMetadata> highWatermark = Optional.empty();
    private Map<Integer, ReplicaState> voterStates = new HashMap<Integer, ReplicaState>();
    private Optional<AddVoterHandlerState> addVoterHandlerState = Optional.empty();
    private Optional<RemoveVoterHandlerState> removeVoterHandlerState = Optional.empty();
    private final Map<ReplicaKey, ReplicaState> observerStates = new HashMap<ReplicaKey, ReplicaState>();
    private final Logger log;
    private final BatchAccumulator<T> accumulator;
    private final Set<Integer> fetchedVoters = new HashSet<Integer>();
    private final Timer checkQuorumTimer;
    private final int checkQuorumTimeoutMs;
    private final Timer beginQuorumEpochTimer;
    private final int beginQuorumEpochTimeoutMs;
    private volatile boolean resignRequested = false;

    protected LeaderState(Time time, ReplicaKey localReplicaKey, int epoch, long epochStartOffset, VoterSet voterSetAtEpochStart, OptionalLong offsetOfVotersAtEpochStart, KRaftVersion kraftVersionAtEpochStart, Set<Integer> grantingVoters, BatchAccumulator<T> accumulator, Endpoints localListeners, int fetchTimeoutMs, LogContext logContext) {
        this.localReplicaKey = localReplicaKey;
        this.epoch = epoch;
        this.epochStartOffset = epochStartOffset;
        this.localListeners = localListeners;
        for (VoterSet.VoterNode voterNode : voterSetAtEpochStart.voterNodes()) {
            boolean hasAcknowledgedLeader = voterNode.isVoter(localReplicaKey);
            this.voterStates.put(voterNode.voterKey().id(), new ReplicaState(voterNode.voterKey(), hasAcknowledgedLeader, voterNode.listeners()));
        }
        this.grantingVoters = Collections.unmodifiableSet(new HashSet<Integer>(grantingVoters));
        this.log = logContext.logger(LeaderState.class);
        this.accumulator = Objects.requireNonNull(accumulator, "accumulator must be non-null");
        this.checkQuorumTimeoutMs = (int)((double)fetchTimeoutMs * 1.5);
        this.checkQuorumTimer = time.timer((long)this.checkQuorumTimeoutMs);
        this.beginQuorumEpochTimeoutMs = fetchTimeoutMs / 2;
        this.beginQuorumEpochTimer = time.timer(0L);
        this.voterSetAtEpochStart = voterSetAtEpochStart;
        this.offsetOfVotersAtEpochStart = offsetOfVotersAtEpochStart;
        this.kraftVersionAtEpochStart = kraftVersionAtEpochStart;
    }

    public long timeUntilBeginQuorumEpochTimerExpires(long currentTimeMs) {
        this.beginQuorumEpochTimer.update(currentTimeMs);
        return this.beginQuorumEpochTimer.remainingMs();
    }

    public void resetBeginQuorumEpochTimer(long currentTimeMs) {
        this.beginQuorumEpochTimer.update(currentTimeMs);
        this.beginQuorumEpochTimer.reset((long)this.beginQuorumEpochTimeoutMs);
    }

    public long timeUntilCheckQuorumExpires(long currentTimeMs) {
        if (this.voterStates.size() == 1) {
            return Long.MAX_VALUE;
        }
        this.checkQuorumTimer.update(currentTimeMs);
        long remainingMs = this.checkQuorumTimer.remainingMs();
        if (remainingMs == 0L) {
            this.log.info("Did not receive fetch request from the majority of the voters within {}ms. Current fetched voters are {}, and voters are {}", new Object[]{this.checkQuorumTimeoutMs, this.fetchedVoters, this.voterStates.values().stream().map(voter -> ((ReplicaState)voter).replicaKey)});
        }
        return remainingMs;
    }

    public void updateCheckQuorumForFollowingVoter(ReplicaKey replicaKey, long currentTimeMs) {
        this.updateFetchedVoters(replicaKey);
        int majority = this.voterStates.size() / 2 + 1;
        if (this.voterStates.containsKey(this.localReplicaKey.id())) {
            --majority;
        }
        if (this.fetchedVoters.size() >= majority) {
            this.fetchedVoters.clear();
            this.checkQuorumTimer.update(currentTimeMs);
            this.checkQuorumTimer.reset((long)this.checkQuorumTimeoutMs);
        }
    }

    private void updateFetchedVoters(ReplicaKey replicaKey) {
        if (replicaKey.id() == this.localReplicaKey.id()) {
            throw new IllegalArgumentException("Received a FETCH/FETCH_SNAPSHOT request from the leader itself.");
        }
        ReplicaState state = this.voterStates.get(replicaKey.id());
        if (state != null && state.matchesKey(replicaKey)) {
            this.fetchedVoters.add(replicaKey.id());
        }
    }

    public BatchAccumulator<T> accumulator() {
        return this.accumulator;
    }

    public Optional<AddVoterHandlerState> addVoterHandlerState() {
        return this.addVoterHandlerState;
    }

    public void resetAddVoterHandlerState(Errors error, String message, Optional<AddVoterHandlerState> state) {
        this.addVoterHandlerState.ifPresent(handlerState -> handlerState.future().complete(RaftUtil.addVoterResponse(error, message)));
        this.addVoterHandlerState = state;
    }

    public Optional<RemoveVoterHandlerState> removeVoterHandlerState() {
        return this.removeVoterHandlerState;
    }

    public void resetRemoveVoterHandlerState(Errors error, String message, Optional<RemoveVoterHandlerState> state) {
        this.removeVoterHandlerState.ifPresent(handlerState -> handlerState.future().complete(RaftUtil.removeVoterResponse(error, message)));
        this.removeVoterHandlerState = state;
    }

    public long maybeExpirePendingOperation(long currentTimeMs) {
        long timeUntilRemoveVoterExpiration;
        long timeUntilAddVoterExpiration = this.addVoterHandlerState().map(state -> state.timeUntilOperationExpiration(currentTimeMs)).orElse(Long.MAX_VALUE);
        if (timeUntilAddVoterExpiration == 0L) {
            this.resetAddVoterHandlerState(Errors.REQUEST_TIMED_OUT, null, Optional.empty());
        }
        if ((timeUntilRemoveVoterExpiration = this.removeVoterHandlerState().map(state -> state.timeUntilOperationExpiration(currentTimeMs)).orElse(Long.MAX_VALUE).longValue()) == 0L) {
            this.resetRemoveVoterHandlerState(Errors.REQUEST_TIMED_OUT, null, Optional.empty());
        }
        return Math.min(this.addVoterHandlerState().map(state -> state.timeUntilOperationExpiration(currentTimeMs)).orElse(Long.MAX_VALUE), this.removeVoterHandlerState().map(state -> state.timeUntilOperationExpiration(currentTimeMs)).orElse(Long.MAX_VALUE));
    }

    public boolean isOperationPending(long currentTimeMs) {
        this.maybeExpirePendingOperation(currentTimeMs);
        return this.addVoterHandlerState.isPresent() || this.removeVoterHandlerState.isPresent();
    }

    private static List<LeaderChangeMessage.Voter> convertToVoters(Set<Integer> voterIds) {
        return voterIds.stream().map(follower -> new LeaderChangeMessage.Voter().setVoterId(follower.intValue())).collect(Collectors.toList());
    }

    public void appendStartOfEpochControlRecords(VoterSet.VoterNode localVoterNode, long currentTimeMs) {
        if (!this.localReplicaKey.equals(localVoterNode.voterKey())) {
            throw new IllegalArgumentException(String.format("Replica key %s didn't match the local key %s", localVoterNode.voterKey(), this.localReplicaKey));
        }
        if (!this.localListeners.equals(localVoterNode.listeners())) {
            throw new IllegalArgumentException(String.format("Listeners %s didn't match the local listeners %s", localVoterNode.listeners(), this.localListeners));
        }
        List<LeaderChangeMessage.Voter> voters = LeaderState.convertToVoters(this.voterStates.keySet());
        List<LeaderChangeMessage.Voter> grantingVoters = LeaderState.convertToVoters(this.grantingVoters());
        LeaderChangeMessage leaderChangeMessage = new LeaderChangeMessage().setVersion((short)0).setLeaderId(this.election().leaderId()).setVoters(voters).setGrantingVoters(grantingVoters);
        this.accumulator.appendControlMessages((baseOffset, epoch, compression, buffer) -> {
            try (MemoryRecordsBuilder builder = new MemoryRecordsBuilder(buffer, 2, compression, TimestampType.CREATE_TIME, baseOffset, currentTimeMs, -1L, -1, -1, false, true, epoch, buffer.capacity());){
                long offset;
                builder.appendLeaderChangeMessage(currentTimeMs, leaderChangeMessage);
                if (this.kraftVersionAtEpochStart.isReconfigSupported() && ((offset = this.offsetOfVotersAtEpochStart.orElseThrow(() -> new IllegalStateException(String.format("The %s is %s but there is no voter set in the log or checkpoint %s", "kraft.version", this.kraftVersionAtEpochStart, this.voterSetAtEpochStart)))) == -1L || this.voterSetAtEpochStart.voterNodeNeedsUpdate(localVoterNode))) {
                    VoterSet updatedVoterSet = this.voterSetAtEpochStart.updateVoter(localVoterNode).orElseThrow(() -> new IllegalStateException(String.format("Update expected for leader node %s and voter set %s", localVoterNode, this.voterSetAtEpochStart)));
                    builder.appendKRaftVersionMessage(currentTimeMs, new KRaftVersionRecord().setVersion(this.kraftVersionAtEpochStart.kraftVersionRecordVersion()).setKRaftVersion(this.kraftVersionAtEpochStart.featureLevel()));
                    builder.appendVotersMessage(currentTimeMs, updatedVoterSet.toVotersRecord(this.kraftVersionAtEpochStart.votersRecordVersion()));
                }
                MemoryRecords memoryRecords = builder.build();
                return memoryRecords;
            }
        });
    }

    public long appendVotersRecord(VoterSet voters, long currentTimeMs) {
        return this.accumulator.appendVotersRecord(voters.toVotersRecord((short)0), currentTimeMs);
    }

    public boolean isResignRequested() {
        return this.resignRequested;
    }

    public boolean isReplicaCaughtUp(ReplicaKey replicaKey, long currentTimeMs) {
        long anHourInMs = TimeUnit.HOURS.toMillis(1L);
        return Optional.ofNullable(this.observerStates.get(replicaKey)).map(state -> ((ReplicaState)state).lastCaughtUpTimestamp > 0L && ((ReplicaState)state).lastFetchTimestamp > 0L && ((ReplicaState)state).lastFetchTimestamp > currentTimeMs - anHourInMs).orElse(false);
    }

    public void requestResign() {
        this.resignRequested = true;
    }

    @Override
    public Optional<LogOffsetMetadata> highWatermark() {
        return this.highWatermark;
    }

    @Override
    public ElectionState election() {
        return ElectionState.withElectedLeader(this.epoch, this.localReplicaKey.id(), this.voterStates.keySet());
    }

    @Override
    public int epoch() {
        return this.epoch;
    }

    @Override
    public Endpoints leaderEndpoints() {
        return this.localListeners;
    }

    Map<Integer, ReplicaState> voterStates() {
        return this.voterStates;
    }

    Map<ReplicaKey, ReplicaState> observerStates(long currentTimeMs) {
        this.clearInactiveObservers(currentTimeMs);
        return this.observerStates;
    }

    public Set<Integer> grantingVoters() {
        return this.grantingVoters;
    }

    Set<ReplicaKey> nonAcknowledgingVoters() {
        HashSet<ReplicaKey> nonAcknowledging = new HashSet<ReplicaKey>();
        for (ReplicaState state : this.voterStates.values()) {
            if (state.hasAcknowledgedLeader) continue;
            nonAcknowledging.add(state.replicaKey);
        }
        return nonAcknowledging;
    }

    private boolean maybeUpdateHighWatermark() {
        LogOffsetMetadata highWatermarkUpdateMetadata;
        long highWatermarkUpdateOffset;
        int indexOfHw;
        ArrayList followersByDescendingFetchOffset = this.followersByDescendingFetchOffset().collect(Collectors.toCollection(ArrayList::new));
        Optional highWatermarkUpdateOpt = ((ReplicaState)followersByDescendingFetchOffset.get(indexOfHw = this.voterStates.size() / 2)).endOffset;
        if (highWatermarkUpdateOpt.isPresent() && (highWatermarkUpdateOffset = (highWatermarkUpdateMetadata = (LogOffsetMetadata)highWatermarkUpdateOpt.get()).offset()) > this.epochStartOffset) {
            if (this.highWatermark.isPresent()) {
                LogOffsetMetadata currentHighWatermarkMetadata = this.highWatermark.get();
                if (highWatermarkUpdateOffset > currentHighWatermarkMetadata.offset() || highWatermarkUpdateOffset == currentHighWatermarkMetadata.offset() && !highWatermarkUpdateMetadata.metadata().equals(currentHighWatermarkMetadata.metadata())) {
                    Optional<LogOffsetMetadata> oldHighWatermark = this.highWatermark;
                    this.highWatermark = highWatermarkUpdateOpt;
                    this.logHighWatermarkUpdate(oldHighWatermark, highWatermarkUpdateMetadata, indexOfHw, followersByDescendingFetchOffset);
                    return true;
                }
                if (highWatermarkUpdateOffset < currentHighWatermarkMetadata.offset()) {
                    this.log.info("The latest computed high watermark {} is smaller than the current value {}, which should only happen when voter set membership changes. If the voter set has not changed this suggests that one of the voters has lost committed data. Full voter replication state: {}", new Object[]{highWatermarkUpdateOffset, currentHighWatermarkMetadata.offset(), this.voterStates.values()});
                    return false;
                }
                return false;
            }
            Optional<LogOffsetMetadata> oldHighWatermark = this.highWatermark;
            this.highWatermark = highWatermarkUpdateOpt;
            this.logHighWatermarkUpdate(oldHighWatermark, highWatermarkUpdateMetadata, indexOfHw, followersByDescendingFetchOffset);
            return true;
        }
        return false;
    }

    private void logHighWatermarkUpdate(Optional<LogOffsetMetadata> oldHighWatermark, LogOffsetMetadata newHighWatermark, int indexOfHw, List<ReplicaState> followersByDescendingFetchOffset) {
        if (oldHighWatermark.isPresent()) {
            this.log.debug("High watermark set to {} from {} based on indexOfHw {} and voters {}", new Object[]{newHighWatermark, oldHighWatermark.get(), indexOfHw, followersByDescendingFetchOffset});
        } else {
            this.log.info("High watermark set to {} for the first time for epoch {} based on indexOfHw {} and voters {}", new Object[]{newHighWatermark, this.epoch, indexOfHw, followersByDescendingFetchOffset});
        }
    }

    public boolean updateLocalState(LogOffsetMetadata endOffsetMetadata, VoterSet lastVoterSet) {
        ReplicaState state = this.getOrCreateReplicaState(this.localReplicaKey);
        state.endOffset.ifPresent(currentEndOffset -> {
            if (currentEndOffset.offset() > endOffsetMetadata.offset()) {
                throw new IllegalStateException("Detected non-monotonic update of local end offset: " + currentEndOffset.offset() + " -> " + endOffsetMetadata.offset());
            }
        });
        state.updateLeaderEndOffset(endOffsetMetadata);
        this.updateVoterAndObserverStates(lastVoterSet);
        return this.maybeUpdateHighWatermark();
    }

    public boolean updateReplicaState(ReplicaKey replicaKey, long currentTimeMs, LogOffsetMetadata fetchOffsetMetadata) {
        if (replicaKey.id() < 0) {
            return false;
        }
        if (replicaKey.id() == this.localReplicaKey.id()) {
            throw new IllegalStateException(String.format("Remote replica ID %s matches the local leader ID", replicaKey));
        }
        ReplicaState state = this.getOrCreateReplicaState(replicaKey);
        state.endOffset.ifPresent(currentEndOffset -> {
            if (currentEndOffset.offset() > fetchOffsetMetadata.offset()) {
                this.log.warn("Detected non-monotonic update of fetch offset from nodeId {}: {} -> {}", new Object[]{state.replicaKey, currentEndOffset.offset(), fetchOffsetMetadata.offset()});
            }
        });
        Optional leaderEndOffsetOpt = this.getOrCreateReplicaState(this.localReplicaKey).endOffset;
        state.updateFollowerState(currentTimeMs, fetchOffsetMetadata, leaderEndOffsetOpt);
        this.updateCheckQuorumForFollowingVoter(replicaKey, currentTimeMs);
        return this.isVoter(state.replicaKey) && this.maybeUpdateHighWatermark();
    }

    public List<ReplicaKey> nonLeaderVotersByDescendingFetchOffset() {
        return this.followersByDescendingFetchOffset().filter(state -> !state.matchesKey(this.localReplicaKey)).map(state -> ((ReplicaState)state).replicaKey).collect(Collectors.toList());
    }

    private Stream<ReplicaState> followersByDescendingFetchOffset() {
        return this.voterStates.values().stream().sorted();
    }

    public void addAcknowledgementFrom(int remoteNodeId) {
        ReplicaState voterState = this.ensureValidVoter(remoteNodeId);
        voterState.hasAcknowledgedLeader = true;
    }

    private ReplicaState ensureValidVoter(int remoteNodeId) {
        ReplicaState state = this.voterStates.get(remoteNodeId);
        if (state == null) {
            throw new IllegalArgumentException("Unexpected acknowledgement from non-voter " + remoteNodeId);
        }
        return state;
    }

    public long epochStartOffset() {
        return this.epochStartOffset;
    }

    private ReplicaState getOrCreateReplicaState(ReplicaKey replicaKey) {
        ReplicaState state = this.voterStates.get(replicaKey.id());
        if (state == null || !state.matchesKey(replicaKey)) {
            this.observerStates.putIfAbsent(replicaKey, new ReplicaState(replicaKey, false, Endpoints.empty()));
            return this.observerStates.get(replicaKey);
        }
        return state;
    }

    public Optional<ReplicaState> getReplicaState(ReplicaKey replicaKey) {
        ReplicaState state = this.voterStates.get(replicaKey.id());
        if (state == null || !state.matchesKey(replicaKey)) {
            state = this.observerStates.get(replicaKey);
        }
        return Optional.ofNullable(state);
    }

    private void clearInactiveObservers(long currentTimeMs) {
        this.observerStates.entrySet().removeIf(integerReplicaStateEntry -> currentTimeMs - ((ReplicaState)integerReplicaStateEntry.getValue()).lastFetchTimestamp >= 300000L && !((ReplicaKey)integerReplicaStateEntry.getKey()).equals(this.localReplicaKey));
    }

    private boolean isVoter(ReplicaKey remoteReplicaKey) {
        ReplicaState state = this.voterStates.get(remoteReplicaKey.id());
        return state != null && state.matchesKey(remoteReplicaKey);
    }

    private void updateVoterAndObserverStates(VoterSet lastVoterSet) {
        HashMap<Integer, ReplicaState> newVoterStates = new HashMap<Integer, ReplicaState>();
        HashMap<Integer, ReplicaState> oldVoterStates = new HashMap<Integer, ReplicaState>(this.voterStates);
        for (VoterSet.VoterNode voterNode : lastVoterSet.voterNodes()) {
            ReplicaState state = this.getReplicaState(voterNode.voterKey()).orElse(new ReplicaState(voterNode.voterKey(), false, voterNode.listeners()));
            oldVoterStates.remove(voterNode.voterKey().id());
            this.observerStates.remove(voterNode.voterKey());
            state.setReplicaKey(voterNode.voterKey());
            state.updateListeners(voterNode.listeners());
            newVoterStates.put(state.replicaKey.id(), state);
        }
        this.voterStates = newVoterStates;
        for (ReplicaState replicaStateEntry : oldVoterStates.values()) {
            replicaStateEntry.clearListeners();
            this.observerStates.putIfAbsent(replicaStateEntry.replicaKey, replicaStateEntry);
        }
    }

    @Override
    public boolean canGrantVote(ReplicaKey candidateKey, boolean isLogUpToDate) {
        this.log.debug("Rejecting vote request from candidate ({}) since we are already leader in epoch {}", (Object)candidateKey, (Object)this.epoch);
        return false;
    }

    public String toString() {
        return String.format("Leader(localReplicaKey=%s, epoch=%d, epochStartOffset=%d, highWatermark=%s, voterStates=%s)", this.localReplicaKey, this.epoch, this.epochStartOffset, this.highWatermark, this.voterStates);
    }

    @Override
    public String name() {
        return "Leader";
    }

    @Override
    public void close() {
        this.resetAddVoterHandlerState(Errors.NOT_LEADER_OR_FOLLOWER, null, Optional.empty());
        this.resetRemoveVoterHandlerState(Errors.NOT_LEADER_OR_FOLLOWER, null, Optional.empty());
        this.accumulator.close();
    }

    public static class ReplicaState
    implements Comparable<ReplicaState> {
        private ReplicaKey replicaKey;
        private Endpoints listeners;
        private Optional<LogOffsetMetadata> endOffset;
        private long lastFetchTimestamp;
        private long lastFetchLeaderLogEndOffset;
        private long lastCaughtUpTimestamp;
        private boolean hasAcknowledgedLeader;

        public ReplicaState(ReplicaKey replicaKey, boolean hasAcknowledgedLeader, Endpoints listeners) {
            this.replicaKey = replicaKey;
            this.listeners = listeners;
            this.endOffset = Optional.empty();
            this.lastFetchTimestamp = -1L;
            this.lastFetchLeaderLogEndOffset = -1L;
            this.lastCaughtUpTimestamp = -1L;
            this.hasAcknowledgedLeader = hasAcknowledgedLeader;
        }

        public ReplicaKey replicaKey() {
            return this.replicaKey;
        }

        public Endpoints listeners() {
            return this.listeners;
        }

        public Optional<LogOffsetMetadata> endOffset() {
            return this.endOffset;
        }

        public long lastFetchTimestamp() {
            return this.lastFetchTimestamp;
        }

        public long lastCaughtUpTimestamp() {
            return this.lastCaughtUpTimestamp;
        }

        void setReplicaKey(ReplicaKey replicaKey) {
            if (this.replicaKey.id() != replicaKey.id()) {
                throw new IllegalArgumentException(String.format("Attempting to update the replica key %s with a different replica id %s", this.replicaKey, replicaKey));
            }
            if (this.replicaKey.directoryId().isPresent() && !this.replicaKey.equals(replicaKey)) {
                throw new IllegalArgumentException(String.format("Attempting to update an already set directory id %s with a different directory id %s", this.replicaKey, replicaKey));
            }
            this.replicaKey = replicaKey;
        }

        void updateListeners(Endpoints listeners) {
            this.listeners = listeners;
        }

        void clearListeners() {
            this.updateListeners(Endpoints.empty());
        }

        boolean matchesKey(ReplicaKey replicaKey) {
            if (this.replicaKey.id() != replicaKey.id()) {
                return false;
            }
            if (this.replicaKey.directoryId().isPresent()) {
                return this.replicaKey.directoryId().equals(replicaKey.directoryId());
            }
            return true;
        }

        void updateLeaderEndOffset(LogOffsetMetadata endOffsetMetadata) {
            this.endOffset = Optional.of(endOffsetMetadata);
        }

        void updateFollowerState(long currentTimeMs, LogOffsetMetadata fetchOffsetMetadata, Optional<LogOffsetMetadata> leaderEndOffsetOpt) {
            leaderEndOffsetOpt.ifPresent(leaderEndOffset -> {
                if (fetchOffsetMetadata.offset() >= leaderEndOffset.offset()) {
                    this.lastCaughtUpTimestamp = Math.max(this.lastCaughtUpTimestamp, currentTimeMs);
                } else if (this.lastFetchLeaderLogEndOffset > 0L && fetchOffsetMetadata.offset() >= this.lastFetchLeaderLogEndOffset) {
                    this.lastCaughtUpTimestamp = Math.max(this.lastCaughtUpTimestamp, this.lastFetchTimestamp);
                }
                this.lastFetchLeaderLogEndOffset = leaderEndOffset.offset();
            });
            this.lastFetchTimestamp = Math.max(this.lastFetchTimestamp, currentTimeMs);
            this.endOffset = Optional.of(fetchOffsetMetadata);
            this.hasAcknowledgedLeader = true;
        }

        @Override
        public int compareTo(ReplicaState that) {
            if (this.endOffset.equals(that.endOffset)) {
                return this.replicaKey.compareTo(that.replicaKey);
            }
            if (!this.endOffset.isPresent()) {
                return 1;
            }
            if (!that.endOffset.isPresent()) {
                return -1;
            }
            return Long.compare(that.endOffset.get().offset(), this.endOffset.get().offset());
        }

        public String toString() {
            return String.format("ReplicaState(replicaKey=%s, endOffset=%s, lastFetchTimestamp=%s, lastCaughtUpTimestamp=%s, hasAcknowledgedLeader=%s)", this.replicaKey, this.endOffset, this.lastFetchTimestamp, this.lastCaughtUpTimestamp, this.hasAcknowledgedLeader);
        }
    }
}

