/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.coordinator.group.generated.GroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.OffsetCommitKey;
import org.apache.kafka.coordinator.group.generated.OffsetCommitKeyJsonConverter;
import org.apache.kafka.coordinator.group.generated.OffsetCommitValue;
import org.apache.kafka.coordinator.group.generated.OffsetCommitValueJsonConverter;
import org.apache.kafka.tools.consumer.ApiMessageFormatter;

public class OffsetsMessageFormatter
extends ApiMessageFormatter {
    @Override
    protected JsonNode readToKeyJson(ByteBuffer byteBuffer, short version) {
        return this.readToGroupMetadataKey(byteBuffer).map(logKey -> this.transferKeyMessageToJsonNode((ApiMessage)logKey, version)).orElseGet(() -> new TextNode("unknown"));
    }

    @Override
    protected JsonNode readToValueJson(ByteBuffer byteBuffer, short version) {
        return this.readToOffsetMessageValue(byteBuffer).map(logValue -> OffsetCommitValueJsonConverter.write((OffsetCommitValue)logValue, (short)version)).orElseGet(() -> new TextNode("unknown"));
    }

    private Optional<ApiMessage> readToGroupMetadataKey(ByteBuffer byteBuffer) {
        short version = byteBuffer.getShort();
        if (version >= 0 && version <= 1) {
            return Optional.of(new OffsetCommitKey((Readable)new ByteBufferAccessor(byteBuffer), version));
        }
        if (version >= 2 && version <= 2) {
            return Optional.of(new GroupMetadataKey((Readable)new ByteBufferAccessor(byteBuffer), version));
        }
        return Optional.empty();
    }

    private JsonNode transferKeyMessageToJsonNode(ApiMessage logKey, short keyVersion) {
        if (logKey instanceof OffsetCommitKey) {
            return OffsetCommitKeyJsonConverter.write((OffsetCommitKey)((OffsetCommitKey)logKey), (short)keyVersion);
        }
        if (logKey instanceof GroupMetadataKey) {
            return NullNode.getInstance();
        }
        return new TextNode("unknown");
    }

    private Optional<OffsetCommitValue> readToOffsetMessageValue(ByteBuffer byteBuffer) {
        short version = byteBuffer.getShort();
        if (version >= 0 && version <= 4) {
            return Optional.of(new OffsetCommitValue((Readable)new ByteBufferAccessor(byteBuffer), version));
        }
        return Optional.empty();
    }
}

