/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.task;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.trogdor.common.JsonUtil;
import org.apache.kafka.trogdor.task.TaskController;
import org.apache.kafka.trogdor.task.TaskWorker;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="class")
public abstract class TaskSpec {
    public static final long MAX_TASK_DURATION_MS = 1000000000000000L;
    private final long startMs;
    private final long durationMs;

    protected TaskSpec(@JsonProperty(value="startMs") long startMs, @JsonProperty(value="durationMs") long durationMs) {
        this.startMs = startMs;
        this.durationMs = Math.max(0L, Math.min(durationMs, 1000000000000000L));
    }

    @JsonProperty
    public final long startMs() {
        return this.startMs;
    }

    public final long endMs() {
        return this.startMs + this.durationMs;
    }

    @JsonProperty
    public final long durationMs() {
        return this.durationMs;
    }

    public abstract TaskController newController(String var1);

    public abstract TaskWorker newTaskWorker(String var1);

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public final int hashCode() {
        return Objects.hashCode(this.toString());
    }

    public String toString() {
        return JsonUtil.toJsonString(this);
    }

    protected Map<String, String> configOrEmptyMap(Map<String, String> config) {
        return config == null ? Collections.emptyMap() : config;
    }
}

