/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import org.apache.kafka.common.KafkaException;

public final class LogOffsetMetadata {
    private static final long UNIFIED_LOG_UNKNOWN_OFFSET = -1L;
    private static final int UNKNOWN_FILE_POSITION = -1;
    public static final LogOffsetMetadata UNKNOWN_OFFSET_METADATA = new LogOffsetMetadata(-1L, -1L, -1);
    public final long messageOffset;
    public final long segmentBaseOffset;
    public final int relativePositionInSegment;

    public LogOffsetMetadata(long messageOffset) {
        this(messageOffset, -1L, -1);
    }

    public LogOffsetMetadata(long messageOffset, long segmentBaseOffset, int relativePositionInSegment) {
        this.messageOffset = messageOffset;
        this.segmentBaseOffset = segmentBaseOffset;
        this.relativePositionInSegment = relativePositionInSegment;
    }

    public boolean onOlderSegment(LogOffsetMetadata that) {
        if (this.messageOffsetOnly() || that.messageOffsetOnly()) {
            return false;
        }
        return this.segmentBaseOffset < that.segmentBaseOffset;
    }

    public boolean onSameSegment(LogOffsetMetadata that) {
        if (this.messageOffsetOnly() || that.messageOffsetOnly()) {
            return false;
        }
        return this.segmentBaseOffset == that.segmentBaseOffset;
    }

    public int positionDiff(LogOffsetMetadata that) {
        if (this.messageOffsetOnly() || that.messageOffsetOnly()) {
            throw new KafkaException(this + " cannot compare its segment position with " + that + " since it only has message offset info");
        }
        if (!this.onSameSegment(that)) {
            throw new KafkaException(this + " cannot compare its segment position with " + that + " since they are not on the same segment");
        }
        return this.relativePositionInSegment - that.relativePositionInSegment;
    }

    public boolean messageOffsetOnly() {
        return this.segmentBaseOffset == -1L && this.relativePositionInSegment == -1;
    }

    public String toString() {
        return "(offset=" + this.messageOffset + ", segment=[" + this.segmentBaseOffset + ":" + this.relativePositionInSegment + "])";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogOffsetMetadata that = (LogOffsetMetadata)o;
        return this.messageOffset == that.messageOffset && this.segmentBaseOffset == that.segmentBaseOffset && this.relativePositionInSegment == that.relativePositionInSegment;
    }

    public int hashCode() {
        int result = Long.hashCode(this.messageOffset);
        result = 31 * result + Long.hashCode(this.segmentBaseOffset);
        result = 31 * result + Integer.hashCode(this.relativePositionInSegment);
        return result;
    }
}

