/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.Collections;
import java.util.Optional;
import java.util.OptionalInt;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.raft.BatchReader;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.raft.errors.NotLeaderException;
import org.apache.kafka.snapshot.SnapshotReader;
import org.apache.kafka.snapshot.SnapshotWriter;
import org.slf4j.Logger;

public class ReplicatedCounter
implements RaftClient.Listener<Integer> {
    private static final int SNAPSHOT_DELAY_IN_RECORDS = 10;
    private final int nodeId;
    private final Logger log;
    private final RaftClient<Integer> client;
    private int committed = 0;
    private int uncommitted = 0;
    private OptionalInt claimedEpoch = OptionalInt.empty();
    private long lastOffsetSnapshotted = -1L;
    private int handleLoadSnapshotCalls = 0;

    public ReplicatedCounter(int nodeId, RaftClient<Integer> client, LogContext logContext) {
        this.nodeId = nodeId;
        this.client = client;
        this.log = logContext.logger(ReplicatedCounter.class);
    }

    public synchronized boolean isWritable() {
        return this.claimedEpoch.isPresent();
    }

    public synchronized void increment() {
        if (!this.claimedEpoch.isPresent()) {
            throw new KafkaException("Counter is not currently writable");
        }
        int epoch = this.claimedEpoch.getAsInt();
        ++this.uncommitted;
        try {
            long offset = this.client.scheduleAppend(epoch, Collections.singletonList(this.uncommitted));
            this.log.debug("Scheduled append of record {} with epoch {} at offset {}", new Object[]{this.uncommitted, epoch, offset});
        }
        catch (NotLeaderException e) {
            this.log.info("Appending failed, transition to resigned", (Throwable)((Object)e));
            this.client.resign(epoch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void handleCommit(BatchReader<Integer> reader) {
        block10: {
            try {
                int initialCommitted = this.committed;
                long lastCommittedOffset = -1L;
                int lastCommittedEpoch = 0;
                long lastCommittedTimestamp = -1L;
                while (reader.hasNext()) {
                    Batch batch = (Batch)reader.next();
                    this.log.debug("Handle commit of batch with records {} at base offset {}", batch.records(), (Object)batch.baseOffset());
                    for (Integer nextCommitted : batch.records()) {
                        if (nextCommitted != this.committed + 1) {
                            throw new AssertionError((Object)String.format("Expected next committed value to be %d, but instead found %d on node %d", this.committed + 1, nextCommitted, this.nodeId));
                        }
                        this.committed = nextCommitted;
                    }
                    lastCommittedOffset = batch.lastOffset();
                    lastCommittedEpoch = batch.epoch();
                    lastCommittedTimestamp = batch.appendTimestamp();
                }
                this.log.debug("Counter incremented from {} to {}", (Object)initialCommitted, (Object)this.committed);
                if (this.lastOffsetSnapshotted + 10L >= lastCommittedOffset) break block10;
                this.log.debug("Generating new snapshot with committed offset {} and epoch {} since the previous snapshot includes {}", new Object[]{lastCommittedOffset, lastCommittedEpoch, this.lastOffsetSnapshotted});
                Optional<SnapshotWriter<Integer>> snapshot = this.client.createSnapshot(new OffsetAndEpoch(lastCommittedOffset + 1L, lastCommittedEpoch), lastCommittedTimestamp);
                if (snapshot.isPresent()) {
                    try {
                        snapshot.get().append(Collections.singletonList(this.committed));
                        snapshot.get().freeze();
                        this.lastOffsetSnapshotted = lastCommittedOffset;
                        break block10;
                    }
                    finally {
                        snapshot.get().close();
                    }
                }
                this.lastOffsetSnapshotted = lastCommittedOffset;
            }
            finally {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void handleLoadSnapshot(SnapshotReader<Integer> reader) {
        try {
            this.log.debug("Loading snapshot {}", (Object)reader.snapshotId());
            boolean foundDataRecord = false;
            while (reader.hasNext()) {
                Batch batch = (Batch)reader.next();
                if (!batch.records().isEmpty()) {
                    if (foundDataRecord) {
                        throw new AssertionError((Object)String.format("Expected the snapshot at %s to only one data batch %s", reader.snapshotId(), batch));
                    }
                    if (batch.records().size() != 1) {
                        throw new AssertionError((Object)String.format("Expected the snapshot at %s to only contain one record %s", reader.snapshotId(), batch.records()));
                    }
                    foundDataRecord = true;
                }
                for (Integer value : batch) {
                    this.log.debug("Setting value: {}", (Object)value);
                    this.committed = value;
                    this.uncommitted = value;
                }
            }
            this.lastOffsetSnapshotted = reader.lastContainedLogOffset();
            ++this.handleLoadSnapshotCalls;
            this.log.debug("Finished loading snapshot. Set value: {}", (Object)this.committed);
        }
        finally {
            reader.close();
        }
    }

    @Override
    public synchronized void handleLeaderChange(LeaderAndEpoch newLeader) {
        if (newLeader.isLeader(this.nodeId)) {
            this.log.debug("Counter uncommitted value initialized to {} after claiming leadership in epoch {}", (Object)this.committed, (Object)newLeader);
            this.uncommitted = this.committed;
            this.claimedEpoch = OptionalInt.of(newLeader.epoch());
        } else {
            this.log.debug("Counter uncommitted value reset after resigning leadership");
            this.uncommitted = -1;
            this.claimedEpoch = OptionalInt.empty();
        }
        this.handleLoadSnapshotCalls = 0;
    }

    public int handleLoadSnapshotCalls() {
        return this.handleLoadSnapshotCalls;
    }
}

