/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import kafka.server.BrokerReconfigurable;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Y3Aa\u0002\u0005\u0001\u001b!Aa\u0004\u0001BC\u0002\u0013\u0005q\u0004\u0003\u00050\u0001\t\u0005\t\u0015!\u0003!\u0011\u0015\u0001\u0004\u0001\"\u00012\u0011\u0015!\u0004\u0001\"\u00016\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0011\u0015\u0019\u0005\u0001\"\u0011E\u0005\u0005\"\u0015P\\1nS\u000e\u0004&o\u001c3vG\u0016\u00148\u000b^1uK6\u000bg.Y4fe\u000e{gNZ5h\u0015\tI!\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u0017\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\u000f)a\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\u000b\u0017\u001b\u0005A\u0011BA\f\t\u0005Q\u0011%o\\6feJ+7m\u001c8gS\u001e,(/\u00192mKB\u0011\u0011\u0004H\u0007\u00025)\u00111DC\u0001\u0006kRLGn]\u0005\u0003;i\u0011q\u0001T8hO&tw-\u0001\u000eqe>$WoY3s'R\fG/Z'b]\u0006<WM]\"p]\u001aLw-F\u0001!!\t\tS&D\u0001#\u0015\t\u0019C%A\u0002m_\u001eT!!\n\u0014\u0002\u0013%tG/\u001a:oC2\u001c(BA\u0014)\u0003\u001d\u0019Ho\u001c:bO\u0016T!aC\u0015\u000b\u0005)Z\u0013AB1qC\u000eDWMC\u0001-\u0003\ry'oZ\u0005\u0003]\t\u0012!\u0004\u0015:pIV\u001cWM]*uCR,W*\u00198bO\u0016\u00148i\u001c8gS\u001e\f1\u0004\u001d:pIV\u001cWM]*uCR,W*\u00198bO\u0016\u00148i\u001c8gS\u001e\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u00023gA\u0011Q\u0003\u0001\u0005\u0006=\r\u0001\r\u0001I\u0001\fe\u0016\u001cwN\u001c4jOV\u0014X\rF\u00027sy\u0002\"aD\u001c\n\u0005a\u0002\"\u0001B+oSRDQA\u000f\u0003A\u0002m\n\u0011b\u001c7e\u0007>tg-[4\u0011\u0005Ua\u0014BA\u001f\t\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u000b}\"\u0001\u0019A\u001e\u0002\u00139,woQ8oM&<\u0017a\u0006<bY&$\u0017\r^3SK\u000e|gNZ5hkJ\fG/[8o)\t1$\tC\u0003@\u000b\u0001\u00071(A\u000bsK\u000e|gNZ5hkJ\f'\r\\3D_:4\u0017nZ:\u0016\u0003\u0015\u00032AR%L\u001b\u00059%B\u0001%\u0011\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u0015\u001e\u00131aU3u!\ta5K\u0004\u0002N#B\u0011a\nE\u0007\u0002\u001f*\u0011\u0001\u000bD\u0001\u0007yI|w\u000e\u001e \n\u0005I\u0003\u0012A\u0002)sK\u0012,g-\u0003\u0002U+\n11\u000b\u001e:j]\u001eT!A\u0015\t")
public class DynamicProducerStateManagerConfig
implements BrokerReconfigurable,
Logging {
    private final ProducerStateManagerConfig producerStateManagerConfig;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ProducerStateManagerConfig producerStateManagerConfig() {
        return this.producerStateManagerConfig;
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        if (!BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)this.producerStateManagerConfig().producerIdExpirationMs()), (Object)newConfig.producerIdExpirationMs())) {
            this.info((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(47).append("Reconfigure ").append("producer.id.expiration.ms").append(" from ").append(this.producerStateManagerConfig().producerIdExpirationMs()).append(" to ").append(newConfig.producerIdExpirationMs()).toString());
            this.producerStateManagerConfig().setProducerIdExpirationMs(Predef$.MODULE$.Integer2int(newConfig.producerIdExpirationMs()));
        }
        if (!BoxesRunTime.equals((Object)BoxesRunTime.boxToBoolean((boolean)this.producerStateManagerConfig().transactionVerificationEnabled()), (Object)newConfig.transactionPartitionVerificationEnable())) {
            this.info((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(63).append("Reconfigure ").append("transaction.partition.verification.enable").append(" from ").append(this.producerStateManagerConfig().transactionVerificationEnabled()).append(" to ").append(newConfig.transactionPartitionVerificationEnable()).toString());
            this.producerStateManagerConfig().setTransactionVerificationEnabled(Predef$.MODULE$.Boolean2boolean(newConfig.transactionPartitionVerificationEnable()));
            return;
        }
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        if (Predef$.MODULE$.Integer2int(newConfig.producerIdExpirationMs()) < 0) {
            throw new ConfigException(new StringBuilder(85).append("producer.id.expiration.ms").append(" cannot be less than 0, current value is ").append(this.producerStateManagerConfig().producerIdExpirationMs()).append(", and new value is ").append(newConfig.producerIdExpirationMs()).toString());
        }
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return DynamicBrokerConfig$.MODULE$.DynamicProducerStateManagerConfig();
    }

    public DynamicProducerStateManagerConfig(ProducerStateManagerConfig producerStateManagerConfig) {
        this.producerStateManagerConfig = producerStateManagerConfig;
        Logging.$init$(this);
    }
}

