/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.util.Map;
import java.util.regex.Pattern;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.utils.ConfigUtils;
import org.apache.kafka.connect.mirror.ConfigPropertyFilter;
import org.apache.kafka.connect.mirror.MirrorUtils;

public class DefaultConfigPropertyFilter
implements ConfigPropertyFilter {
    public static final String CONFIG_PROPERTIES_EXCLUDE_CONFIG = "config.properties.exclude";
    public static final String CONFIG_PROPERTIES_EXCLUDE_ALIAS_CONFIG = "config.properties.blacklist";
    public static final String USE_DEFAULTS_FROM = "use.defaults.from";
    private static final String USE_DEFAULTS_FROM_DOC = "Which cluster's defaults (source or target) to use when syncing topic configurations that have default values.";
    private static final String USE_DEFAULTS_FROM_DEFAULT = "target";
    private static final String CONFIG_PROPERTIES_EXCLUDE_DOC = "List of topic configuration properties and/or regexes that should not be replicated.";
    public static final String CONFIG_PROPERTIES_EXCLUDE_DEFAULT = "follower\\.replication\\.throttled\\.replicas, leader\\.replication\\.throttled\\.replicas, message\\.timestamp\\.difference\\.max\\.ms, message\\.timestamp\\.type, unclean\\.leader\\.election\\.enable, min\\.insync\\.replicas";
    private Pattern excludePattern = MirrorUtils.compilePatternList("follower\\.replication\\.throttled\\.replicas, leader\\.replication\\.throttled\\.replicas, message\\.timestamp\\.difference\\.max\\.ms, message\\.timestamp\\.type, unclean\\.leader\\.election\\.enable, min\\.insync\\.replicas");
    private String useDefaultsFrom = "target";

    @Override
    public void configure(Map<String, ?> props) {
        ConfigPropertyFilterConfig config = new ConfigPropertyFilterConfig(props);
        this.excludePattern = config.excludePattern();
        this.useDefaultsFrom = config.useDefaultsFrom();
    }

    private boolean excluded(String prop) {
        return this.excludePattern != null && this.excludePattern.matcher(prop).matches();
    }

    @Override
    public boolean shouldReplicateConfigProperty(String prop) {
        return !this.excluded(prop);
    }

    @Override
    public boolean shouldReplicateSourceDefault(String prop) {
        return this.useDefaultsFrom.equals("source");
    }

    static class ConfigPropertyFilterConfig
    extends AbstractConfig {
        static final ConfigDef DEF = new ConfigDef().define("config.properties.exclude", ConfigDef.Type.LIST, (Object)"follower\\.replication\\.throttled\\.replicas, leader\\.replication\\.throttled\\.replicas, message\\.timestamp\\.difference\\.max\\.ms, message\\.timestamp\\.type, unclean\\.leader\\.election\\.enable, min\\.insync\\.replicas", ConfigDef.Importance.HIGH, "List of topic configuration properties and/or regexes that should not be replicated.").define("config.properties.blacklist", ConfigDef.Type.LIST, null, ConfigDef.Importance.HIGH, "Deprecated. Use config.properties.exclude instead.").define("use.defaults.from", ConfigDef.Type.STRING, (Object)"target", ConfigDef.Importance.MEDIUM, "Which cluster's defaults (source or target) to use when syncing topic configurations that have default values.");

        ConfigPropertyFilterConfig(Map<String, ?> props) {
            super(DEF, ConfigUtils.translateDeprecatedConfigs(props, (String[][])new String[][]{{DefaultConfigPropertyFilter.CONFIG_PROPERTIES_EXCLUDE_CONFIG, DefaultConfigPropertyFilter.CONFIG_PROPERTIES_EXCLUDE_ALIAS_CONFIG}}), false);
        }

        Pattern excludePattern() {
            return MirrorUtils.compilePatternList(this.getList(DefaultConfigPropertyFilter.CONFIG_PROPERTIES_EXCLUDE_CONFIG));
        }

        String useDefaultsFrom() {
            return this.getString(DefaultConfigPropertyFilter.USE_DEFAULTS_FROM);
        }
    }
}

