/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.log.Cleaner;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.LogCleaner$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleaningException;
import kafka.log.LogToClean;
import kafka.log.PreCleanStats;
import kafka.log.UnifiedLog;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import kafka.utils.Pool;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.util.ShutdownableThread;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.OffsetMap;
import org.apache.kafka.storage.internals.log.SkimpyOffsetMap;
import org.apache.kafka.storage.internals.utils.Throttler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\r\u0005e\u0001B(Q\u0001UC\u0001\u0002\u001b\u0001\u0003\u0002\u0003\u0006I!\u001b\u0005\to\u0002\u0011)\u0019!C\u0001q\"I\u0011q\u0002\u0001\u0003\u0002\u0003\u0006I!\u001f\u0005\u000b\u0003#\u0001!Q1A\u0005\u0002\u0005M\u0001BCA\u0018\u0001\t\u0005\t\u0015!\u0003\u0002\u0016!Q\u0011\u0011\u0007\u0001\u0003\u0006\u0004%\t!a\r\t\u0015\u0005m\u0002A!A!\u0002\u0013\t)\u0004\u0003\u0006\u0002>\u0001\u0011\t\u0011)A\u0005\u0003\u007fAq!!\u0013\u0001\t\u0003\tY\u0005\u0003\u0006\u0002Z\u0001\u0011\r\u0011\"\u0001Q\u00037B\u0001\"a\u001b\u0001A\u0003%\u0011Q\f\u0005\n\u0003[\u0002\u0001\u0019!C\u0005\u0003_B\u0011\"!\u001d\u0001\u0001\u0004%I!a\u001d\t\u000f\u0005}\u0004\u0001)Q\u0005S\"Q\u0011\u0011\u0012\u0001C\u0002\u0013\u0005\u0001+a#\t\u0011\u0005M\u0005\u0001)A\u0005\u0003\u001bC!\"!&\u0001\u0005\u0004%\t\u0001UAL\u0011!\t\u0019\u000b\u0001Q\u0001\n\u0005e\u0005BCAS\u0001\t\u0007I\u0011\u0001)\u0002(\"A!q\u000f\u0001!\u0002\u0013\tI\u000bC\u0004\u0003z\u0001!IAa\u001f\t\u0011\t5\u0005\u0001\"\u0001Q\u0005\u001fCqA!%\u0001\t\u0003\u0011i\u0003C\u0004\u0003\u0014\u0002!\tA!\f\t\u000f\tU\u0005\u0001\"\u0001\u0003.!9!q\u0013\u0001\u0005B\te\u0005b\u0002BQ\u0001\u0011\u0005#1\u0015\u0005\b\u0005_\u0003A\u0011\tBY\u0011\u001d\u0011I\f\u0001C\u0001\u0005wCqAa0\u0001\t\u0003\u0011\t\rC\u0005\u0003R\u0002\t\n\u0011\"\u0001\u0003T\"9!\u0011\u001e\u0001\u0005\u0002\t-\bb\u0002B|\u0001\u0011\u0005!\u0011 \u0005\b\u0005\u007f\u0004A\u0011AB\u0001\u0011\u001d\u0019Y\u0001\u0001C\u0001\u0007\u001bAqa!\u0005\u0001\t\u0003\u0019\u0019\u0002C\u0004\u0004 \u0001!\ta!\t\t\u0013\r-\u0002!%A\u0005\u0002\r5\u0002bBB\u0019\u0001\u0011\u000511\u0007\u0005\t\u0007{\u0001A\u0011\u0001*\u0002p!A1q\b\u0001\u0005\u0002A\u0013yIB\u0004\u0002:\u0002\u0001\u0001+a/\t\u0015\u0005%'F!A!\u0002\u0013\tY\rC\u0004\u0002J)\"\t!!5\t\u000f\u0005U'\u0006\"\u0015\u0002X\"I\u0011q\u001e\u0016C\u0002\u0013\u0005\u0011\u0011\u001f\u0005\t\u0003sT\u0003\u0015!\u0003\u0002t\"I\u00111 \u0016A\u0002\u0013\u0005\u0011Q \u0005\n\u0005\u000bQ\u0003\u0019!C\u0001\u0005\u000fA\u0001Ba\u0003+A\u0003&\u0011q \u0005\n\u0005\u001fQ\u0003\u0019!C\u0001\u0005#A\u0011B!\u0007+\u0001\u0004%\tAa\u0007\t\u0011\t}!\u0006)Q\u0005\u0005'AqAa\t+\t\u0013\u0011)\u0003C\u0004\u0003,)\"\tE!\f\t\u000f\t=\"\u0006\"\u0003\u00032!9!\u0011\b\u0016\u0005\n\tE\u0002b\u0002B&U\u0011%!Q\n\u0005\b\u00053RC\u0011\u0002B.\u000f\u001d\u0019\t\u0005\u0015E\u0001\u0007\u00072aa\u0014)\t\u0002\r\u0015\u0003bBA%{\u0011\u00051q\t\u0005\n\u0007\u0013j$\u0019!C\u0001\u00053C\u0001ba\u0013>A\u0003%!1\u0014\u0005\b\u0007\u001bjD\u0011AB(\u0011%\u0019\u0019&\u0010b\u0001\n\u0013\u0019)\u0006\u0003\u0005\u0004bu\u0002\u000b\u0011BB,\u0011%\u0019\u0019'\u0010b\u0001\n\u0013\u0019)\u0006\u0003\u0005\u0004fu\u0002\u000b\u0011BB,\u0011%\u00199'\u0010b\u0001\n\u0013\u0019)\u0006\u0003\u0005\u0004ju\u0002\u000b\u0011BB,\u0011%\u0019Y'\u0010b\u0001\n\u0013\u0019)\u0006\u0003\u0005\u0004nu\u0002\u000b\u0011BB,\u0011%\u0019y'\u0010b\u0001\n\u0013\u0019)\u0006\u0003\u0005\u0004ru\u0002\u000b\u0011BB,\u0011)\u0019\u0019(\u0010b\u0001\n\u0003\u00016Q\u000f\u0005\t\u0007sj\u0004\u0015!\u0003\u0004x!I11P\u001f\u0012\u0002\u0013\u00051Q\u0010\u0002\u000b\u0019><7\t\\3b]\u0016\u0014(BA)S\u0003\rawn\u001a\u0006\u0002'\u0006)1.\u00194lC\u000e\u00011\u0003\u0002\u0001W9\n\u0004\"a\u0016.\u000e\u0003aS\u0011!W\u0001\u0006g\u000e\fG.Y\u0005\u00037b\u0013a!\u00118z%\u00164\u0007CA/a\u001b\u0005q&BA0S\u0003\u0015)H/\u001b7t\u0013\t\tgLA\u0004M_\u001e<\u0017N\\4\u0011\u0005\r4W\"\u00013\u000b\u0005\u0015\u0014\u0016AB:feZ,'/\u0003\u0002hI\n!\"I]8lKJ\u0014VmY8oM&<WO]1cY\u0016\fQ\"\u001b8ji&\fGnQ8oM&<\u0007C\u00016v\u001b\u0005Y'BA)m\u0015\tig.A\u0005j]R,'O\\1mg*\u0011q\u000e]\u0001\bgR|'/Y4f\u0015\t\u0019\u0016O\u0003\u0002sg\u00061\u0011\r]1dQ\u0016T\u0011\u0001^\u0001\u0004_J<\u0017B\u0001<l\u00055\u0019E.Z1oKJ\u001cuN\u001c4jO\u00069An\\4ESJ\u001cX#A=\u0011\u0007ilx0D\u0001|\u0015\ta\b,\u0001\u0006d_2dWm\u0019;j_:L!A`>\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002\u0002\u0005-QBAA\u0002\u0015\u0011\t)!a\u0002\u0002\u0005%|'BAA\u0005\u0003\u0011Q\u0017M^1\n\t\u00055\u00111\u0001\u0002\u0005\r&dW-\u0001\u0005m_\u001e$\u0015N]:!\u0003\u0011awnZ:\u0016\u0005\u0005U\u0001cB/\u0002\u0018\u0005m\u0011qE\u0005\u0004\u00033q&\u0001\u0002)p_2\u0004B!!\b\u0002$5\u0011\u0011q\u0004\u0006\u0004\u0003C\u0001\u0018AB2p[6|g.\u0003\u0003\u0002&\u0005}!A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0005\u0003S\tY#D\u0001Q\u0013\r\ti\u0003\u0015\u0002\u000b+:Lg-[3e\u0019><\u0017!\u00027pON\u0004\u0013\u0001\u00067pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G.\u0006\u0002\u00026A\u0019!.a\u000e\n\u0007\u0005e2N\u0001\u000bM_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\\\u0001\u0016Y><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7!\u0003\u0011!\u0018.\\3\u0011\t\u0005\u0005\u0013QI\u0007\u0003\u0003\u0007R1aXA\u0010\u0013\u0011\t9%a\u0011\u0003\tQKW.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0019\u00055\u0013qJA)\u0003'\n)&a\u0016\u0011\u0007\u0005%\u0002\u0001C\u0003i\u0013\u0001\u0007\u0011\u000eC\u0003x\u0013\u0001\u0007\u0011\u0010C\u0004\u0002\u0012%\u0001\r!!\u0006\t\u000f\u0005E\u0012\u00021\u0001\u00026!I\u0011QH\u0005\u0011\u0002\u0003\u0007\u0011qH\u0001\r[\u0016$(/[2t\u000fJ|W\u000f]\u000b\u0003\u0003;\u0002B!a\u0018\u0002h5\u0011\u0011\u0011\r\u0006\u0005\u0003G\n)'A\u0004nKR\u0014\u0018nY:\u000b\u0005\u0015\u0004\u0018\u0002BA5\u0003C\u0012\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u00035iW\r\u001e:jGN<%o\\;qA\u000511m\u001c8gS\u001e,\u0012![\u0001\u000bG>tg-[4`I\u0015\fH\u0003BA;\u0003w\u00022aVA<\u0013\r\tI\b\u0017\u0002\u0005+:LG\u000f\u0003\u0005\u0002~5\t\t\u00111\u0001j\u0003\rAH%M\u0001\bG>tg-[4!Q\rq\u00111\u0011\t\u0004/\u0006\u0015\u0015bAAD1\nAao\u001c7bi&dW-\u0001\bdY\u0016\fg.\u001a:NC:\fw-\u001a:\u0016\u0005\u00055\u0005\u0003BA\u0015\u0003\u001fK1!!%Q\u0005EaunZ\"mK\u0006tWM]'b]\u0006<WM]\u0001\u0010G2,\u0017M\\3s\u001b\u0006t\u0017mZ3sA\u0005IA\u000f\u001b:piRdWM]\u000b\u0003\u00033\u0003B!a'\u0002 6\u0011\u0011Q\u0014\u0006\u0003?2LA!!)\u0002\u001e\nIA\u000b\u001b:piRdWM]\u0001\u000bi\"\u0014x\u000e\u001e;mKJ\u0004\u0013\u0001C2mK\u0006tWM]:\u0016\u0005\u0005%\u0006CBAV\u0003c\u000b),\u0004\u0002\u0002.*\u0019\u0011qV>\u0002\u000f5,H/\u00192mK&!\u00111WAW\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0007\u0005]&&D\u0001\u0001\u00055\u0019E.Z1oKJ$\u0006N]3bIN!!&!0]!\u0011\ty,!2\u000e\u0005\u0005\u0005'\u0002BAb\u0003K\nA!\u001e;jY&!\u0011qYAa\u0005I\u0019\u0006.\u001e;e_^t\u0017M\u00197f)\"\u0014X-\u00193\u0002\u0011QD'/Z1e\u0013\u0012\u00042aVAg\u0013\r\ty\r\u0017\u0002\u0004\u0013:$H\u0003BA[\u0003'Dq!!3-\u0001\u0004\tY-\u0001\u0006m_\u001e<WM\u001d(b[\u0016,\"!!7\u0011\t\u0005m\u0017\u0011\u001e\b\u0005\u0003;\f)\u000fE\u0002\u0002`bk!!!9\u000b\u0007\u0005\rH+\u0001\u0004=e>|GOP\u0005\u0004\u0003OD\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002l\u00065(AB*ue&twMC\u0002\u0002hb\u000bqa\u00197fC:,'/\u0006\u0002\u0002tB!\u0011\u0011FA{\u0013\r\t9\u0010\u0015\u0002\b\u00072,\u0017M\\3s\u0003!\u0019G.Z1oKJ\u0004\u0013!\u00037bgR\u001cF/\u0019;t+\t\ty\u0010\u0005\u0003\u0002*\t\u0005\u0011b\u0001B\u0002!\na1\t\\3b]\u0016\u00148\u000b^1ug\u0006iA.Y:u'R\fGo]0%KF$B!!\u001e\u0003\n!I\u0011QP\u0019\u0002\u0002\u0003\u0007\u0011q`\u0001\u000bY\u0006\u001cHo\u0015;biN\u0004\u0003f\u0001\u001a\u0002\u0004\u0006\tB.Y:u!J,7\t\\3b]N#\u0018\r^:\u0016\u0005\tM\u0001\u0003BA\u0015\u0005+I1Aa\u0006Q\u00055\u0001&/Z\"mK\u0006t7\u000b^1ug\u0006)B.Y:u!J,7\t\\3b]N#\u0018\r^:`I\u0015\fH\u0003BA;\u0005;A\u0011\"! 5\u0003\u0003\u0005\rAa\u0005\u0002%1\f7\u000f\u001e)sK\u000ecW-\u00198Ti\u0006$8\u000f\t\u0015\u0004k\u0005\r\u0015!C2iK\u000e\\Gi\u001c8f)\u0011\t)Ha\n\t\u000f\t%b\u00071\u0001\u0002\u001c\u0005qAo\u001c9jGB\u000b'\u000f^5uS>t\u0017A\u00023p/>\u00148\u000e\u0006\u0002\u0002v\u0005!BO]=DY\u0016\fgNR5mi\"LWm\u001d;M_\u001e$\"Aa\r\u0011\u0007]\u0013)$C\u0002\u00038a\u0013qAQ8pY\u0016\fg.A\tdY\u0016\fgNR5mi\"LWm\u001d;M_\u001eDS!\u000fB\u001f\u0005\u0013\u0002Ra\u0016B \u0005\u0007J1A!\u0011Y\u0005\u0019!\bN]8xgB!\u0011\u0011\u0006B#\u0013\r\u00119\u0005\u0015\u0002\u0015\u0019><7\t\\3b]&tw-\u0012=dKB$\u0018n\u001c8$\u0005\t\r\u0013\u0001C2mK\u0006tGj\\4\u0015\t\u0005U$q\n\u0005\b\u0005#R\u0004\u0019\u0001B*\u0003%\u0019G.Z1oC\ndW\r\u0005\u0003\u0002*\tU\u0013b\u0001B,!\nQAj\\4U_\u000ecW-\u00198\u0002\u0017I,7m\u001c:e'R\fGo\u001d\u000b\r\u0003k\u0012iF!\u0019\u0003f\t=$1\u000f\u0005\b\u0005?Z\u0004\u0019AAf\u0003\tIG\rC\u0004\u0003dm\u0002\r!!7\u0002\t9\fW.\u001a\u0005\b\u0005OZ\u0004\u0019\u0001B5\u0003\u00111'o\\7\u0011\u0007]\u0013Y'C\u0002\u0003na\u0013A\u0001T8oO\"9!\u0011O\u001eA\u0002\t%\u0014A\u0001;p\u0011\u001d\u0011)h\u000fa\u0001\u0003\u007f\fQa\u001d;biN\f\u0011b\u00197fC:,'o\u001d\u0011\u0002+5\f\u0007p\u0014<fe\u000ecW-\u00198feRC'/Z1egR!\u00111\u001aB?\u0011\u001d\u0011y(\u0006a\u0001\u0005\u0003\u000b\u0011A\u001a\t\b/\n\r\u0015Q\u0017BD\u0013\r\u0011)\t\u0017\u0002\n\rVt7\r^5p]F\u00022a\u0016BE\u0013\r\u0011Y\t\u0017\u0002\u0007\t>,(\r\\3\u0002\u001f\u0011,\u0017\r\u001a+ie\u0016\fGmQ8v]R,\"!a3\u0002\u000fM$\u0018M\u001d;va\u0006A1\u000f[;uI><h.A\u0007sK6|g/Z'fiJL7m]\u0001\u0016e\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4t+\t\u0011Y\nE\u0003{\u0005;\u000bI.C\u0002\u0003 n\u00141aU3u\u0003]1\u0018\r\\5eCR,'+Z2p]\u001aLw-\u001e:bi&|g\u000e\u0006\u0003\u0002v\t\u0015\u0006b\u0002BT7\u0001\u0007!\u0011V\u0001\n]\u0016<8i\u001c8gS\u001e\u00042a\u0019BV\u0013\r\u0011i\u000b\u001a\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0006sK\u000e|gNZ5hkJ,GCBA;\u0005g\u00139\fC\u0004\u00036r\u0001\rA!+\u0002\u0013=dGmQ8oM&<\u0007b\u0002BT9\u0001\u0007!\u0011V\u0001\u000eC\n|'\u000f^\"mK\u0006t\u0017N\\4\u0015\t\u0005U$Q\u0018\u0005\b\u0005Si\u0002\u0019AA\u000e\u0003E)\b\u000fZ1uK\u000eCWmY6q_&tGo\u001d\u000b\u0007\u0003k\u0012\u0019Ma2\t\r\t\u0015g\u00041\u0001\u0000\u0003\u001d!\u0017\r^1ESJD\u0011B!3\u001f!\u0003\u0005\rAa3\u0002#A\f'\u000f^5uS>tGk\u001c*f[>4X\rE\u0003X\u0005\u001b\fY\"C\u0002\u0003Pb\u0013aa\u00149uS>t\u0017aG;qI\u0006$Xm\u00115fG.\u0004x.\u001b8ug\u0012\"WMZ1vYR$#'\u0006\u0002\u0003V*\"!1\u001aBlW\t\u0011I\u000e\u0005\u0003\u0003\\\n\u0015XB\u0001Bo\u0015\u0011\u0011yN!9\u0002\u0013Ut7\r[3dW\u0016$'b\u0001Br1\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u001d(Q\u001c\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AE1mi\u0016\u00148\t[3dWB|\u0017N\u001c;ESJ$\u0002\"!\u001e\u0003n\n=(1\u001f\u0005\b\u0005S\u0001\u0003\u0019AA\u000e\u0011\u0019\u0011\t\u0010\ta\u0001\u007f\u0006a1o\\;sG\u0016dun\u001a#je\"1!Q\u001f\u0011A\u0002}\f!\u0002Z3ti2{w\rR5s\u0003MA\u0017M\u001c3mK2{w\rR5s\r\u0006LG.\u001e:f)\u0011\t)Ha?\t\u000f\tu\u0018\u00051\u0001\u0002Z\u0006\u0019A-\u001b:\u0002/5\f\u0017PY3UeVt7-\u0019;f\u0007\",7m\u001b9pS:$H\u0003CA;\u0007\u0007\u0019)aa\u0002\t\r\t\u0015'\u00051\u0001\u0000\u0011\u001d\u0011IC\ta\u0001\u00037Aqa!\u0003#\u0001\u0004\u0011I'\u0001\u0004pM\u001a\u001cX\r^\u0001\u0016C\n|'\u000f^!oIB\u000bWo]3DY\u0016\fg.\u001b8h)\u0011\t)ha\u0004\t\u000f\t%2\u00051\u0001\u0002\u001c\u0005q!/Z:v[\u0016\u001cE.Z1oS:<G\u0003BA;\u0007+Aqaa\u0006%\u0001\u0004\u0019I\"A\bu_BL7\rU1si&$\u0018n\u001c8t!\u0015Q81DA\u000e\u0013\r\u0019ib\u001f\u0002\t\u0013R,'/\u00192mK\u0006a\u0011m^1ji\u000ecW-\u00198fIRA!1GB\u0012\u0007K\u00199\u0003C\u0004\u0003*\u0015\u0002\r!a\u0007\t\u000f\r%Q\u00051\u0001\u0003j!I1\u0011F\u0013\u0011\u0002\u0003\u0007!\u0011N\u0001\n[\u0006Dx+Y5u\u001bN\fa#Y<bSR\u001cE.Z1oK\u0012$C-\u001a4bk2$HeM\u000b\u0003\u0007_QCA!\u001b\u0003X\u00061\u0003/Y;tK\u000ecW-\u00198j]\u001e4uN\u001d(p]\u000e{W\u000e]1di\u0016$\u0007+\u0019:uSRLwN\\:\u0015\u0005\rU\u0002#\u0002>\u0004\u001c\r]\u0002cB,\u0004:\u0005m\u0011qE\u0005\u0004\u0007wA&A\u0002+va2,''A\u0007dkJ\u0014XM\u001c;D_:4\u0017nZ\u0001\rG2,\u0017M\\3s\u0007>,h\u000e^\u0001\u000b\u0019><7\t\\3b]\u0016\u0014\bcAA\u0015{M\u0011QH\u0016\u000b\u0003\u0007\u0007\nQCU3d_:4\u0017nZ;sC\ndWmQ8oM&<7/\u0001\fSK\u000e|gNZ5hkJ\f'\r\\3D_:4\u0017nZ:!\u00035\u0019G.Z1oKJ\u001cuN\u001c4jOR\u0019\u0011n!\u0015\t\u000f\u00055\u0014\t1\u0001\u0003*\u0006)S*\u0019=Ck\u001a4WM]+uS2L'0\u0019;j_:\u0004VM]2f]RlU\r\u001e:jG:\u000bW.Z\u000b\u0003\u0007/\u0002Ba!\u0017\u0004`5\u001111\f\u0006\u0005\u0007;\n9!\u0001\u0003mC:<\u0017\u0002BAv\u00077\na%T1y\u0005V4g-\u001a:Vi&d\u0017N_1uS>t\u0007+\u001a:dK:$X*\u001a;sS\u000et\u0015-\\3!\u0003y\u0019E.Z1oKJ\u0014VmY8qsB+'oY3oi6+GO]5d\u001d\u0006lW-A\u0010DY\u0016\fg.\u001a:SK\u000e|\u0007/\u001f)fe\u000e,g\u000e^'fiJL7MT1nK\u0002\na#T1y\u00072,\u0017M\u001c+j[\u0016lU\r\u001e:jG:\u000bW.Z\u0001\u0018\u001b\u0006D8\t\\3b]RKW.Z'fiJL7MT1nK\u0002\nQ$T1y\u0007>l\u0007/Y2uS>tG)\u001a7bs6+GO]5dg:\u000bW.Z\u0001\u001f\u001b\u0006D8i\\7qC\u000e$\u0018n\u001c8EK2\f\u00170T3ue&\u001c7OT1nK\u0002\n\u0011\u0004R3bIRC'/Z1e\u0007>,h\u000e^'fiJL7MT1nK\u0006QB)Z1e)\"\u0014X-\u00193D_VtG/T3ue&\u001cg*Y7fA\u0005YQ*\u001a;sS\u000et\u0015-\\3t+\t\u00199\bE\u0003{\u0005;\u001b9&\u0001\u0007NKR\u0014\u0018n\u0019(b[\u0016\u001c\b%A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u000b\u0003\u0007\u007fRC!a\u0010\u0003X\u0002")
public class LogCleaner
implements Logging,
BrokerReconfigurable {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, UnifiedLog> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    public final Time kafka$log$LogCleaner$$time;
    private final KafkaMetricsGroup metricsGroup;
    private volatile CleanerConfig kafka$log$LogCleaner$$config;
    private final LogCleanerManager cleanerManager;
    private final Throttler throttler;
    private final ArrayBuffer<CleanerThread> cleaners;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$5() {
        return LogCleaner$.MODULE$.$lessinit$greater$default$5();
    }

    public static CleanerConfig cleanerConfig(KafkaConfig kafkaConfig) {
        return LogCleaner$.MODULE$.cleanerConfig(kafkaConfig);
    }

    public static Set<String> ReconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, UnifiedLog> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public CleanerConfig kafka$log$LogCleaner$$config() {
        return this.kafka$log$LogCleaner$$config;
    }

    private void kafka$log$LogCleaner$$config_$eq(CleanerConfig x$1) {
        this.kafka$log$LogCleaner$$config = x$1;
    }

    public LogCleanerManager cleanerManager() {
        return this.cleanerManager;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    public ArrayBuffer<CleanerThread> cleaners() {
        return this.cleaners;
    }

    private int maxOverCleanerThreads(Function1<CleanerThread, Object> f) {
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(max, thread) -> {
            double $anonfun$maxOverCleanerThreads$1_max = BoxesRunTime.unboxToDouble((Object)max);
            return BoxesRunTime.boxToDouble((double)package$.MODULE$.max($anonfun$maxOverCleanerThreads$1_max, BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply(thread))));
        }));
    }

    public int deadThreadCount() {
        return this.cleaners().count((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isThreadFailed()));
    }

    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting the log cleaner");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$log$LogCleaner$$config().numThreads).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            CleanerThread cleaner = new CleanerThread(i);
            this.cleaners().$plus$eq((Object)cleaner);
            cleaner.start();
        });
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down the log cleaner.");
        try {
            this.cleaners().foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                x$8.shutdown();
                return BoxedUnit.UNIT;
            });
            this.cleaners().clear();
        }
        finally {
            this.removeMetrics();
        }
    }

    public void removeMetrics() {
        LogCleaner$.MODULE$.MetricNames().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            LogCleaner.$anonfun$removeMetrics$1(this, x$1);
            return BoxedUnit.UNIT;
        });
        this.cleanerManager().removeMetrics();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        int numThreads = LogCleaner$.MODULE$.cleanerConfig((KafkaConfig)newConfig).numThreads;
        int currentThreads = this.kafka$log$LogCleaner$$config().numThreads;
        if (numThreads < 1) {
            throw new ConfigException("Log cleaner threads should be at least 1");
        }
        if (numThreads < currentThreads / 2) {
            throw new ConfigException(new StringBuilder(74).append("Log cleaner threads cannot be reduced to less than half the current value ").append(currentThreads).toString());
        }
        if (numThreads > currentThreads * 2) {
            throw new ConfigException(new StringBuilder(78).append("Log cleaner threads cannot be increased to more than double the current value ").append(currentThreads).toString());
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        this.kafka$log$LogCleaner$$config_$eq(LogCleaner$.MODULE$.cleanerConfig(newConfig));
        double maxIoBytesPerSecond = this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond;
        if (!BoxesRunTime.equals((Object)BoxesRunTime.boxToDouble((double)maxIoBytesPerSecond), (Object)oldConfig.logCleanerIoMaxBytesPerSecond())) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Updating logCleanerIoMaxBytesPerSecond: ").append(maxIoBytesPerSecond).toString());
            this.throttler().updateDesiredRatePerSec(maxIoBytesPerSecond);
        }
        this.shutdown();
        this.startup();
    }

    public void abortCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortCleaning(topicPartition);
    }

    public void updateCheckpoints(File dataDir, Option<TopicPartition> partitionToRemove) {
        Option<Tuple2<TopicPartition, Object>> x$3 = this.cleanerManager().updateCheckpoints$default$2();
        this.cleanerManager().updateCheckpoints(dataDir, x$3, partitionToRemove);
    }

    public Option<TopicPartition> updateCheckpoints$default$2() {
        return None$.MODULE$;
    }

    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        this.cleanerManager().alterCheckpointDir(topicPartition, sourceLogDir, destLogDir);
    }

    public void handleLogDirFailure(String dir) {
        this.cleanerManager().handleLogDirFailure(dir);
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        this.cleanerManager().maybeTruncateCheckpoint(dataDir, topicPartition, offset);
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortAndPauseCleaning(topicPartition);
    }

    public void resumeCleaning(Iterable<TopicPartition> topicPartitions) {
        this.cleanerManager().resumeCleaning(topicPartitions);
    }

    public boolean awaitCleaned(TopicPartition topicPartition, long offset, long maxWaitMs) {
        long sleepTime;
        for (long remainingWaitMs = maxWaitMs; !this.isCleaned$1(topicPartition, offset) && remainingWaitMs > 0L; remainingWaitMs -= sleepTime) {
            sleepTime = package$.MODULE$.min(100L, remainingWaitMs);
            Thread.sleep(sleepTime);
        }
        return this.isCleaned$1(topicPartition, offset);
    }

    public long awaitCleaned$default$3() {
        return 60000L;
    }

    public Iterable<Tuple2<TopicPartition, UnifiedLog>> pauseCleaningForNonCompactedPartitions() {
        return this.cleanerManager().pauseCleaningForNonCompactedPartitions();
    }

    public CleanerConfig currentConfig() {
        return this.kafka$log$LogCleaner$$config();
    }

    public int cleanerCount() {
        return this.cleaners().size();
    }

    public static final /* synthetic */ double $anonfun$maxOverCleanerThreads$1(Function1 f$1, double max, CleanerThread thread) {
        return package$.MODULE$.max(max, BoxesRunTime.unboxToDouble((Object)f$1.apply((Object)thread)));
    }

    public static final /* synthetic */ double $anonfun$new$2(CleanerThread x$1) {
        return x$1.lastStats().bufferUtilization();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$1() {
        Function1 & Serializable & scala.Serializable maxOverCleanerThreads_f = (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$2(x$1));
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(max, thread) -> {
            double $anonfun$maxOverCleanerThreads$1_max = BoxesRunTime.unboxToDouble((Object)max);
            return BoxesRunTime.boxToDouble((double)package$.MODULE$.max($anonfun$maxOverCleanerThreads$1_max, BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply(thread))));
        })) * 100;
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$3() {
        ArrayBuffer stats = (ArrayBuffer)this.cleaners().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.lastStats(), ArrayBuffer$.MODULE$.canBuildFrom());
        double recopyRate = (double)BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.bytesWritten())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.bytesRead())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), 1L);
        return (int)((double)100 * recopyRate);
    }

    public static final /* synthetic */ double $anonfun$new$8(CleanerThread x$5) {
        return x$5.lastStats().elapsedSecs();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$7() {
        Function1 & Serializable & scala.Serializable maxOverCleanerThreads_f = (Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$8(x$5));
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(max, thread) -> {
            double $anonfun$maxOverCleanerThreads$1_max = BoxesRunTime.unboxToDouble((Object)max);
            return BoxesRunTime.boxToDouble((double)package$.MODULE$.max($anonfun$maxOverCleanerThreads$1_max, BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply(thread))));
        }));
    }

    public static final /* synthetic */ double $anonfun$new$10(CleanerThread x$6) {
        return x$6.lastPreCleanStats().maxCompactionDelayMs();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$9() {
        Function1 & Serializable & scala.Serializable maxOverCleanerThreads_f = (Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$10(x$6));
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(max, thread) -> {
            double $anonfun$maxOverCleanerThreads$1_max = BoxesRunTime.unboxToDouble((Object)max);
            return BoxesRunTime.boxToDouble((double)package$.MODULE$.max($anonfun$maxOverCleanerThreads$1_max, BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply(thread))));
        })) / 1000;
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$11() {
        return this.deadThreadCount();
    }

    public static final /* synthetic */ void $anonfun$removeMetrics$1(LogCleaner $this, String x$1) {
        $this.metricsGroup().removeMetric(x$1);
    }

    private final boolean isCleaned$1(TopicPartition topicPartition$1, long offset$1) {
        return BoxesRunTime.unboxToBoolean((Object)this.cleanerManager().allCleanerCheckpoints().get((Object)topicPartition$1).fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, (Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$9 -> x$9 >= offset$1));
    }

    public LogCleaner(CleanerConfig initialConfig, Seq<File> logDirs, Pool<TopicPartition, UnifiedLog> logs, LogDirFailureChannel logDirFailureChannel, Time time) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        this.kafka$log$LogCleaner$$time = time;
        Logging.$init$(this);
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.kafka$log$LogCleaner$$config = initialConfig;
        this.cleanerManager = new LogCleanerManager(logDirs, logs, logDirFailureChannel);
        this.throttler = new Throttler(this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond, 300L, "cleaner-io", "bytes", time);
        this.cleaners = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.kafka$log$LogCleaner$$MaxBufferUtilizationPercentMetricName(), (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.kafka$log$LogCleaner$$CleanerRecopyPercentMetricName(), (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$3();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.kafka$log$LogCleaner$$MaxCleanTimeMetricName(), (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$7();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.kafka$log$LogCleaner$$MaxCompactionDelayMetricsName(), (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$9();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.metricsGroup().newGauge(LogCleaner$.MODULE$.kafka$log$LogCleaner$$DeadThreadCountMetricName(), (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$11();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public class CleanerThread
    extends ShutdownableThread
    implements Logging {
        private final Cleaner cleaner;
        private volatile CleanerStats lastStats;
        private volatile PreCleanStats lastPreCleanStats;
        private Logger logger;
        private String logIdent;
        private volatile boolean bitmap$0;

        @Override
        public String msgWithLogIdent(String msg) {
            return Logging.msgWithLogIdent$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        private Logger logger$lzycompute() {
            synchronized (this) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            if (!this.bitmap$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        @Override
        public String loggerName() {
            return LogCleaner.class.getName();
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public CleanerStats lastStats() {
            return this.lastStats;
        }

        public void lastStats_$eq(CleanerStats x$1) {
            this.lastStats = x$1;
        }

        public PreCleanStats lastPreCleanStats() {
            return this.lastPreCleanStats;
        }

        public void lastPreCleanStats_$eq(PreCleanStats x$1) {
            this.lastPreCleanStats = x$1;
        }

        private void checkDone(TopicPartition topicPartition) {
            if (!this.isRunning()) {
                throw new ThreadShutdownException();
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().checkCleaningAborted(topicPartition);
        }

        public void doWork() {
            if (!this.tryCleanFilthiestLog()) {
                this.pause(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().backoffMs, TimeUnit.MILLISECONDS);
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().maintainUncleanablePartitions();
        }

        private boolean tryCleanFilthiestLog() {
            try {
                return this.cleanFilthiestLog();
            }
            catch (LogCleaningException e) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Unexpected exception thrown when cleaning log ").append(e.log()).append(". Marking its partition (").append(e.log().topicPartition()).append(") as uncleanable").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().markPartitionUncleanable(e.log().parentDir(), e.log().topicPartition());
                return false;
            }
        }

        private boolean cleanFilthiestLog() throws LogCleaningException {
            boolean bl;
            PreCleanStats preCleanStats = new PreCleanStats();
            Option<LogToClean> ltc = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().grabFilthiestCompactedLog(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$time, preCleanStats);
            if (None$.MODULE$.equals(ltc)) {
                bl = false;
            } else if (ltc instanceof Some) {
                LogToClean cleanable = (LogToClean)((Some)ltc).value();
                this.lastPreCleanStats_$eq(preCleanStats);
                try {
                    this.cleanLog(cleanable);
                    bl = true;
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadShutdownException ? true : throwable instanceof ControlThrowable) {
                        throw throwable;
                    }
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw new LogCleaningException(cleanable.log(), exception.getMessage(), exception);
                    }
                    throw throwable;
                }
            } else {
                throw new MatchError(ltc);
            }
            boolean cleaned = bl;
            Iterable<Tuple2<TopicPartition, UnifiedLog>> deletable = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().deletableLogs();
            try {
                deletable.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)CleanerThread.$anonfun$cleanFilthiestLog$1(x0$1)));
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneDeleting((Iterable<TopicPartition>)((Iterable)deletable.map((Function1 & Serializable & scala.Serializable)x$10 -> (TopicPartition)x$10._1(), Iterable$.MODULE$.canBuildFrom())));
            }
            return cleaned;
        }

        /*
         * WARNING - void declaration
         */
        private void cleanLog(LogToClean cleanable) {
            long startOffset;
            long endOffset = startOffset = cleanable.firstDirtyOffset();
            try {
                try {
                    void var9_6;
                    void var7_5;
                    Tuple2<Object, CleanerStats> tuple2 = this.cleaner().clean(cleanable);
                    if (tuple2 == null) {
                        throw new MatchError(null);
                    }
                    long nextDirtyOffset = tuple2._1$mcJ$sp();
                    CleanerStats cleanerStats = (CleanerStats)tuple2._2();
                    endOffset = var7_5;
                    this.recordStats(this.cleaner().id(), cleanable.log().name(), startOffset, (long)var7_5, (CleanerStats)var9_6);
                }
                catch (LogCleaningAbortedException logCleaningAbortedException) {
                }
                catch (KafkaStorageException kafkaStorageException) {
                }
                catch (IOException e) {
                    String logDirectory = cleanable.log().parentDir();
                    String msg = new StringBuilder(54).append("Failed to clean up log for ").append(cleanable.topicPartition()).append(" in dir ").append(logDirectory).append(" due to IOException").toString();
                    this.kafka$log$LogCleaner$CleanerThread$$$outer().logDirFailureChannel().maybeAddOfflineLogDir(logDirectory, msg, e);
                }
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().parentDirFile(), endOffset);
            }
        }

        private void recordStats(int id, String name, long from, long to, CleanerStats stats) {
            this.lastStats_$eq(stats);
            String message = new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString("%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), name, BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)}))).append(new StringOps(Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)CleanerThread.mb$1((double)stats.bytesRead() / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.mapBytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)(CleanerThread.mb$1(stats.mapBytesRead()) / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)100 * stats.bufferUtilization()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)(CleanerThread.mb$1(stats.bytesRead()) / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))}))).append(new StringOps(Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToLong((long)stats.messagesRead())}))).append(new StringOps(Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesWritten())), BoxesRunTime.boxToLong((long)stats.messagesWritten())}))).append(new StringOps(Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}))).toString();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
            if (this.lastPreCleanStats().delayedPartitions() > 0) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("\tCleanable partitions: %d, Delayed partitions: %d, max delay: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().cleanablePartitions()), BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().delayedPartitions()), BoxesRunTime.boxToLong((long)this.lastPreCleanStats().maxCompactionDelayMs())})));
            }
            if (stats.invalidMessagesRead() > 0L) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("\tFound %d invalid messages during compaction.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stats.invalidMessagesRead())})));
                return;
            }
        }

        public /* synthetic */ LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return LogCleaner.this;
        }

        public static final /* synthetic */ int $anonfun$cleanFilthiestLog$1(Tuple2 x0$1) {
            if (x0$1 != null) {
                UnifiedLog log = (UnifiedLog)x0$1._2();
                try {
                    return log.deleteOldSegments();
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadShutdownException ? true : throwable instanceof ControlThrowable) {
                        throw throwable;
                    }
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw new LogCleaningException(log, exception.getMessage(), exception);
                    }
                    throw throwable;
                }
            }
            throw new MatchError(null);
        }

        private static final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanerThread(int threadId) {
            if (LogCleaner.this == null) {
                throw null;
            }
            super(new StringBuilder(25).append("kafka-log-cleaner-thread-").append(threadId).toString(), false);
            Logging.$init$(this);
            this.logIdent_$eq(this.logPrefix);
            if (LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads > Integer.MAX_VALUE) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Cannot use more than 2G of cleaner buffer space per cleaner thread, ignoring excess buffer space...");
            }
            this.cleaner = new Cleaner(threadId, (OffsetMap)new SkimpyOffsetMap((int)package$.MODULE$.min(LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads, Integer.MAX_VALUE), LogCleaner.this.kafka$log$LogCleaner$$config().hashAlgorithm()), LogCleaner.this.kafka$log$LogCleaner$$config().ioBufferSize / LogCleaner.this.kafka$log$LogCleaner$$config().numThreads / 2, LogCleaner.this.kafka$log$LogCleaner$$config().maxMessageSize, LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferLoadFactor, LogCleaner.this.throttler(), LogCleaner.this.kafka$log$LogCleaner$$time, (Function1<TopicPartition, BoxedUnit>)(Function1 & Serializable & scala.Serializable)topicPartition -> {
                this.checkDone(topicPartition);
                return BoxedUnit.UNIT;
            });
            this.lastStats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
            this.lastPreCleanStats = new PreCleanStats();
        }
    }
}

