/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shell.command;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.image.node.MetadataNode;
import org.apache.kafka.shell.InteractiveShell;
import org.apache.kafka.shell.command.CommandUtils;
import org.apache.kafka.shell.command.Commands;
import org.apache.kafka.shell.glob.GlobVisitor;
import org.apache.kafka.shell.state.MetadataShellState;
import org.jline.reader.Candidate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LsCommandHandler
implements Commands.Handler {
    private static final Logger log = LoggerFactory.getLogger(LsCommandHandler.class);
    public static final Commands.Type TYPE = new LsCommandType();
    private final List<String> targets;

    public LsCommandHandler(List<String> targets) {
        this.targets = targets;
    }

    @Override
    public void run(Optional<InteractiveShell> shell, PrintWriter writer, MetadataShellState state) throws Exception {
        ArrayList<String> targetFiles = new ArrayList<String>();
        ArrayList<TargetDirectory> targetDirectories = new ArrayList<TargetDirectory>();
        for (String target : CommandUtils.getEffectivePaths(this.targets)) {
            state.visit(new GlobVisitor(target, entryOption -> {
                if (entryOption.isPresent()) {
                    GlobVisitor.MetadataNodeInfo info = (GlobVisitor.MetadataNodeInfo)entryOption.get();
                    MetadataNode node = info.node();
                    if (node.isDirectory()) {
                        ArrayList<String> children = new ArrayList<String>();
                        children.addAll(node.childNames());
                        children.sort(String::compareTo);
                        targetDirectories.add(new TargetDirectory(info.lastPathComponent(), children));
                    } else {
                        targetFiles.add(info.lastPathComponent());
                    }
                } else {
                    writer.println("ls: " + target + ": no such file or directory.");
                }
            }));
        }
        OptionalInt screenWidth = shell.isPresent() ? OptionalInt.of(shell.get().screenWidth()) : OptionalInt.empty();
        log.trace("LS : targetFiles = {}, targetDirectories = {}, screenWidth = {}", new Object[]{targetFiles, targetDirectories, screenWidth});
        LsCommandHandler.printTargets(writer, screenWidth, targetFiles, targetDirectories);
    }

    static void printTargets(PrintWriter writer, OptionalInt screenWidth, List<String> targetFiles, List<TargetDirectory> targetDirectories) {
        LsCommandHandler.printEntries(writer, "", screenWidth, targetFiles);
        boolean needIntro = targetFiles.size() > 0 || targetDirectories.size() > 1;
        boolean firstIntro = targetFiles.isEmpty();
        for (TargetDirectory targetDirectory : targetDirectories) {
            String intro = "";
            if (needIntro) {
                if (!firstIntro) {
                    intro = intro + String.format("%n", new Object[0]);
                }
                intro = intro + targetDirectory.name + ":";
                firstIntro = false;
            }
            log.trace("LS : targetDirectory name = {}, children = {}", (Object)targetDirectory.name, (Object)targetDirectory.children);
            LsCommandHandler.printEntries(writer, intro, screenWidth, targetDirectory.children);
        }
    }

    static void printEntries(PrintWriter writer, String intro, OptionalInt screenWidth, List<String> entries) {
        if (entries.isEmpty()) {
            return;
        }
        if (!intro.isEmpty()) {
            writer.println(intro);
        }
        ColumnSchema columnSchema = LsCommandHandler.calculateColumnSchema(screenWidth, entries);
        int numColumns = columnSchema.numColumns();
        int numLines = (entries.size() + numColumns - 1) / numColumns;
        for (int line = 0; line < numLines; ++line) {
            StringBuilder output = new StringBuilder();
            for (int column = 0; column < numColumns; ++column) {
                int entryIndex = line + column * columnSchema.entriesPerColumn();
                if (entryIndex >= entries.size()) continue;
                String entry = entries.get(entryIndex);
                output.append(entry);
                if (column >= numColumns - 1) continue;
                int width = columnSchema.columnWidth(column);
                for (int i = 0; i < width - entry.length(); ++i) {
                    output.append(" ");
                }
            }
            writer.println(output);
        }
    }

    static ColumnSchema calculateColumnSchema(OptionalInt screenWidth, List<String> entries) {
        if (!screenWidth.isPresent()) {
            return new ColumnSchema(1, entries.size());
        }
        int maxColumns = screenWidth.getAsInt() / 4;
        if (maxColumns <= 1) {
            return new ColumnSchema(1, entries.size());
        }
        ColumnSchema[] schemas = new ColumnSchema[maxColumns];
        for (int numColumns = 1; numColumns <= maxColumns; ++numColumns) {
            schemas[numColumns - 1] = new ColumnSchema(numColumns, (entries.size() + numColumns - 1) / numColumns);
        }
        for (int i = 0; i < entries.size(); ++i) {
            String entry = entries.get(i);
            for (int s = 0; s < schemas.length; ++s) {
                ColumnSchema schema = schemas[s];
                schema.process(i, entry);
            }
        }
        for (int s = schemas.length - 1; s > 0; --s) {
            ColumnSchema schema = schemas[s];
            if (schema.columnWidths[schema.columnWidths.length - 1] == 0 || schema.totalWidth() > screenWidth.getAsInt()) continue;
            return schema;
        }
        return schemas[0];
    }

    public int hashCode() {
        return Objects.hashCode(this.targets);
    }

    public boolean equals(Object other) {
        if (!(other instanceof LsCommandHandler)) {
            return false;
        }
        LsCommandHandler o = (LsCommandHandler)other;
        return Objects.equals(o.targets, this.targets);
    }

    static class ColumnSchema {
        private final int[] columnWidths;
        private final int entriesPerColumn;

        ColumnSchema(int numColumns, int entriesPerColumn) {
            this.columnWidths = new int[numColumns];
            this.entriesPerColumn = entriesPerColumn;
        }

        ColumnSchema setColumnWidths(Integer ... widths) {
            for (int i = 0; i < widths.length; ++i) {
                this.columnWidths[i] = widths[i];
            }
            return this;
        }

        void process(int entryIndex, String output) {
            int columnIndex = entryIndex / this.entriesPerColumn;
            this.columnWidths[columnIndex] = Math.max(this.columnWidths[columnIndex], output.length() + 2);
        }

        int totalWidth() {
            int total = 0;
            for (int i = 0; i < this.columnWidths.length; ++i) {
                total += this.columnWidths[i];
            }
            return total;
        }

        int numColumns() {
            return this.columnWidths.length;
        }

        int columnWidth(int columnIndex) {
            return this.columnWidths[columnIndex];
        }

        int entriesPerColumn() {
            return this.entriesPerColumn;
        }

        public int hashCode() {
            return Objects.hash(this.columnWidths, this.entriesPerColumn);
        }

        public boolean equals(Object o) {
            if (!(o instanceof ColumnSchema)) {
                return false;
            }
            ColumnSchema other = (ColumnSchema)o;
            if (this.entriesPerColumn != other.entriesPerColumn) {
                return false;
            }
            return Arrays.equals(this.columnWidths, other.columnWidths);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder("ColumnSchema(columnWidths=[");
            String prefix = "";
            for (int i = 0; i < this.columnWidths.length; ++i) {
                bld.append(prefix);
                bld.append(this.columnWidths[i]);
                prefix = ", ";
            }
            bld.append("], entriesPerColumn=").append(this.entriesPerColumn).append(")");
            return bld.toString();
        }
    }

    static class TargetDirectory {
        private final String name;
        private final List<String> children;

        TargetDirectory(String name, List<String> children) {
            this.name = name;
            this.children = children;
        }
    }

    public static class LsCommandType
    implements Commands.Type {
        private LsCommandType() {
        }

        @Override
        public String name() {
            return "ls";
        }

        @Override
        public String description() {
            return "List metadata nodes.";
        }

        @Override
        public boolean shellOnly() {
            return false;
        }

        @Override
        public void addArguments(ArgumentParser parser) {
            parser.addArgument(new String[]{"targets"}).nargs("*").help("The metadata node paths to list.");
        }

        @Override
        public Commands.Handler createHandler(Namespace namespace) {
            return new LsCommandHandler(namespace.getList("targets"));
        }

        @Override
        public void completeNext(MetadataShellState state, List<String> nextWords, List<Candidate> candidates) throws Exception {
            CommandUtils.completePath(state, nextWords.get(nextWords.size() - 1), candidates);
        }
    }
}

