/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Set;
import org.apache.kafka.streams.kstream.ValueTransformerWithKey;
import org.apache.kafka.streams.kstream.ValueTransformerWithKeySupplier;
import org.apache.kafka.streams.processor.api.ContextualProcessor;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.ProcessorSupplier;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.ForwardingDisabledProcessorContext;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.state.StoreBuilder;

public class KStreamFlatTransformValues<KIn, VIn, VOut>
implements ProcessorSupplier<KIn, VIn, KIn, VOut> {
    private final ValueTransformerWithKeySupplier<KIn, VIn, Iterable<VOut>> valueTransformerSupplier;

    public KStreamFlatTransformValues(ValueTransformerWithKeySupplier<KIn, VIn, Iterable<VOut>> valueTransformerWithKeySupplier) {
        this.valueTransformerSupplier = valueTransformerWithKeySupplier;
    }

    @Override
    public Processor<KIn, VIn, KIn, VOut> get() {
        return new KStreamFlatTransformValuesProcessor(this.valueTransformerSupplier.get());
    }

    @Override
    public Set<StoreBuilder<?>> stores() {
        return this.valueTransformerSupplier.stores();
    }

    public static class KStreamFlatTransformValuesProcessor<KIn, VIn, VOut>
    extends ContextualProcessor<KIn, VIn, KIn, VOut> {
        private final ValueTransformerWithKey<KIn, VIn, Iterable<VOut>> valueTransformer;

        KStreamFlatTransformValuesProcessor(ValueTransformerWithKey<KIn, VIn, Iterable<VOut>> valueTransformer) {
            this.valueTransformer = valueTransformer;
        }

        @Override
        public void init(ProcessorContext<KIn, VOut> context) {
            super.init(context);
            this.valueTransformer.init(new ForwardingDisabledProcessorContext((InternalProcessorContext)context));
        }

        @Override
        public void process(Record<KIn, VIn> record) {
            Iterable<VOut> transformedValues = this.valueTransformer.transform(record.key(), record.value());
            if (transformedValues != null) {
                for (VOut transformedValue : transformedValues) {
                    this.context().forward(record.withValue(transformedValue));
                }
            }
        }

        @Override
        public void close() {
            super.close();
            this.valueTransformer.close();
        }
    }
}

