/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.json;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Context;
import org.apache.juneau.MediaType;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.UriContext;
import org.apache.juneau.UriRelativity;
import org.apache.juneau.UriResolution;
import org.apache.juneau.Visibility;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.internal.Cache;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.json.JsonSchemaSerializerSession;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.jsonschema.BeanDefMapper;
import org.apache.juneau.jsonschema.JsonSchemaBeanPropertyMeta;
import org.apache.juneau.jsonschema.JsonSchemaClassMeta;
import org.apache.juneau.jsonschema.JsonSchemaGenerator;
import org.apache.juneau.jsonschema.JsonSchemaMetaProvider;
import org.apache.juneau.jsonschema.TypeCategory;
import org.apache.juneau.serializer.SerializerListener;
import org.apache.juneau.swap.BeanInterceptor;
import org.apache.juneau.utils.HashKey;
import org.apache.juneau.utils.ThrowingFunction;

public class JsonSchemaSerializer
extends JsonSerializer
implements JsonSchemaMetaProvider {
    public static final JsonSchemaSerializer DEFAULT = new JsonSchemaSerializer(JsonSchemaSerializer.create());
    public static final JsonSchemaSerializer DEFAULT_READABLE = new Readable(JsonSchemaSerializer.create());
    public static final JsonSchemaSerializer DEFAULT_SIMPLE = new Simple(JsonSchemaSerializer.create());
    public static final JsonSchemaSerializer DEFAULT_SIMPLE_READABLE = new SimpleReadable(JsonSchemaSerializer.create());
    final JsonSchemaGenerator generator;
    private final Map<ClassMeta<?>, JsonSchemaClassMeta> jsonSchemaClassMetas = new ConcurrentHashMap();
    private final Map<BeanPropertyMeta, JsonSchemaBeanPropertyMeta> jsonSchemaBeanPropertyMetas = new ConcurrentHashMap<BeanPropertyMeta, JsonSchemaBeanPropertyMeta>();

    public static Builder create() {
        return new Builder();
    }

    public JsonSchemaSerializer(Builder builder) {
        super(builder.detectRecursions().ignoreRecursions());
        this.generator = builder.generatorBuilder.build();
    }

    @Override
    public Builder copy() {
        return new Builder(this);
    }

    @Override
    public JsonSchemaSerializerSession.Builder createSession() {
        return JsonSchemaSerializerSession.create(this);
    }

    @Override
    public JsonSchemaSerializerSession getSession() {
        return this.createSession().build();
    }

    JsonSchemaGenerator getGenerator() {
        return this.generator;
    }

    @Override
    public JsonSchemaClassMeta getJsonSchemaClassMeta(ClassMeta<?> cm) {
        JsonSchemaClassMeta m = this.jsonSchemaClassMetas.get(cm);
        if (m == null) {
            m = new JsonSchemaClassMeta(cm, this);
            this.jsonSchemaClassMetas.put(cm, m);
        }
        return m;
    }

    @Override
    public JsonSchemaBeanPropertyMeta getJsonSchemaBeanPropertyMeta(BeanPropertyMeta bpm) {
        JsonSchemaBeanPropertyMeta m = this.jsonSchemaBeanPropertyMetas.get(bpm);
        if (m == null) {
            m = new JsonSchemaBeanPropertyMeta(bpm.getDelegateFor(), this);
            this.jsonSchemaBeanPropertyMetas.put(bpm, m);
        }
        return m;
    }

    @Override
    protected JsonMap properties() {
        return JsonMap.filteredMap("generator", this.generator);
    }

    @FluentSetters
    public static class Builder
    extends JsonSerializer.Builder {
        private static final Cache<HashKey, JsonSchemaSerializer> CACHE = Cache.of(HashKey.class, JsonSchemaSerializer.class).build();
        JsonSchemaGenerator.Builder generatorBuilder;

        protected Builder() {
            this.produces("application/json");
            this.accept("application/json+schema,text/json+schema");
            this.generatorBuilder = JsonSchemaGenerator.create().beanContext(this.beanContext());
        }

        protected Builder(JsonSchemaSerializer copyFrom) {
            super(copyFrom);
            this.generatorBuilder = copyFrom.generator.copy().beanContext(this.beanContext());
        }

        protected Builder(Builder copyFrom) {
            super(copyFrom);
            this.generatorBuilder = copyFrom.generatorBuilder.copy().beanContext(this.beanContext());
        }

        @Override
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        public JsonSchemaSerializer build() {
            return this.cache(CACHE).build(JsonSchemaSerializer.class);
        }

        @Override
        public HashKey hashKey() {
            return HashKey.of(super.hashKey(), this.generatorBuilder.hashKey());
        }

        @FluentSetter
        public Builder addDescriptionsTo(TypeCategory ... values) {
            this.generatorBuilder.addDescriptionsTo(values);
            return this;
        }

        @FluentSetter
        public Builder addExamplesTo(TypeCategory ... values) {
            this.generatorBuilder.addExamplesTo(values);
            return this;
        }

        @FluentSetter
        public Builder allowNestedDescriptions() {
            this.generatorBuilder.allowNestedDescriptions();
            return this;
        }

        @FluentSetter
        public Builder allowNestedExamples() {
            this.generatorBuilder.allowNestedExamples();
            return this;
        }

        @FluentSetter
        public Builder beanDefMapper(Class<? extends BeanDefMapper> value) {
            this.generatorBuilder.beanDefMapper(value);
            return this;
        }

        @FluentSetter
        public Builder useBeanDefs() {
            this.generatorBuilder.useBeanDefs();
            return this;
        }

        @Override
        public Builder annotations(Annotation ... values) {
            super.annotations(values);
            return this;
        }

        @Override
        public Builder apply(AnnotationWorkList work) {
            super.apply(work);
            return this;
        }

        @Override
        public Builder applyAnnotations(Class<?> ... fromClasses) {
            super.applyAnnotations((Class[])fromClasses);
            return this;
        }

        @Override
        public Builder applyAnnotations(Method ... fromMethods) {
            super.applyAnnotations(fromMethods);
            return this;
        }

        @Override
        public Builder cache(Cache<HashKey, ? extends Context> value) {
            super.cache((Cache)value);
            return this;
        }

        @Override
        public Builder debug() {
            super.debug();
            return this;
        }

        @Override
        public Builder debug(boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder impl(Context value) {
            super.impl(value);
            return this;
        }

        @Override
        public Builder type(Class<? extends Context> value) {
            super.type((Class)value);
            return this;
        }

        @Override
        public Builder beanClassVisibility(Visibility value) {
            super.beanClassVisibility(value);
            return this;
        }

        @Override
        public Builder beanConstructorVisibility(Visibility value) {
            super.beanConstructorVisibility(value);
            return this;
        }

        @Override
        public Builder beanContext(BeanContext value) {
            super.beanContext(value);
            return this;
        }

        @Override
        public Builder beanContext(BeanContext.Builder value) {
            super.beanContext(value);
            return this;
        }

        @Override
        public Builder beanDictionary(Class<?> ... values) {
            super.beanDictionary((Class[])values);
            return this;
        }

        @Override
        public Builder beanFieldVisibility(Visibility value) {
            super.beanFieldVisibility(value);
            return this;
        }

        @Override
        public Builder beanInterceptor(Class<?> on, Class<? extends BeanInterceptor<?>> value) {
            super.beanInterceptor((Class)on, (Class)value);
            return this;
        }

        @Override
        public Builder beanMapPutReturnsOldValue() {
            super.beanMapPutReturnsOldValue();
            return this;
        }

        @Override
        public Builder beanMethodVisibility(Visibility value) {
            super.beanMethodVisibility(value);
            return this;
        }

        @Override
        public Builder beanProperties(Map<String, Object> values) {
            super.beanProperties((Map)values);
            return this;
        }

        @Override
        public Builder beanProperties(Class<?> beanClass, String properties) {
            super.beanProperties((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanProperties(String beanClassName, String properties) {
            super.beanProperties(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(Map<String, Object> values) {
            super.beanPropertiesExcludes((Map)values);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(Class<?> beanClass, String properties) {
            super.beanPropertiesExcludes((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesExcludes(String beanClassName, String properties) {
            super.beanPropertiesExcludes(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(Map<String, Object> values) {
            super.beanPropertiesReadOnly((Map)values);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(Class<?> beanClass, String properties) {
            super.beanPropertiesReadOnly((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesReadOnly(String beanClassName, String properties) {
            super.beanPropertiesReadOnly(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(Map<String, Object> values) {
            super.beanPropertiesWriteOnly((Map)values);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(Class<?> beanClass, String properties) {
            super.beanPropertiesWriteOnly((Class)beanClass, properties);
            return this;
        }

        @Override
        public Builder beanPropertiesWriteOnly(String beanClassName, String properties) {
            super.beanPropertiesWriteOnly(beanClassName, properties);
            return this;
        }

        @Override
        public Builder beansRequireDefaultConstructor() {
            super.beansRequireDefaultConstructor();
            return this;
        }

        @Override
        public Builder beansRequireSerializable() {
            super.beansRequireSerializable();
            return this;
        }

        @Override
        public Builder beansRequireSettersForGetters() {
            super.beansRequireSettersForGetters();
            return this;
        }

        @Override
        public Builder dictionaryOn(Class<?> on, Class<?> ... values) {
            super.dictionaryOn((Class)on, (Class[])values);
            return this;
        }

        @Override
        public Builder disableBeansRequireSomeProperties() {
            super.disableBeansRequireSomeProperties();
            return this;
        }

        @Override
        public Builder disableIgnoreMissingSetters() {
            super.disableIgnoreMissingSetters();
            return this;
        }

        @Override
        public Builder disableIgnoreTransientFields() {
            super.disableIgnoreTransientFields();
            return this;
        }

        @Override
        public Builder disableIgnoreUnknownNullBeanProperties() {
            super.disableIgnoreUnknownNullBeanProperties();
            return this;
        }

        @Override
        public Builder disableInterfaceProxies() {
            super.disableInterfaceProxies();
            return this;
        }

        @Override
        public <T> Builder example(Class<T> pojoClass, T o) {
            super.example((Class)pojoClass, (Object)o);
            return this;
        }

        @Override
        public <T> Builder example(Class<T> pojoClass, String json) {
            super.example((Class)pojoClass, json);
            return this;
        }

        @Override
        public Builder findFluentSetters() {
            super.findFluentSetters();
            return this;
        }

        @Override
        public Builder findFluentSetters(Class<?> on) {
            super.findFluentSetters((Class)on);
            return this;
        }

        @Override
        public Builder ignoreInvocationExceptionsOnGetters() {
            super.ignoreInvocationExceptionsOnGetters();
            return this;
        }

        @Override
        public Builder ignoreInvocationExceptionsOnSetters() {
            super.ignoreInvocationExceptionsOnSetters();
            return this;
        }

        @Override
        public Builder ignoreUnknownBeanProperties() {
            super.ignoreUnknownBeanProperties();
            return this;
        }

        @Override
        public Builder ignoreUnknownEnumValues() {
            super.ignoreUnknownEnumValues();
            return this;
        }

        @Override
        public Builder implClass(Class<?> interfaceClass, Class<?> implClass) {
            super.implClass((Class)interfaceClass, (Class)implClass);
            return this;
        }

        @Override
        public Builder implClasses(Map<Class<?>, Class<?>> values) {
            super.implClasses((Map)values);
            return this;
        }

        @Override
        public Builder interfaceClass(Class<?> on, Class<?> value) {
            super.interfaceClass((Class)on, (Class)value);
            return this;
        }

        @Override
        public Builder interfaces(Class<?> ... value) {
            super.interfaces((Class[])value);
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder notBeanClasses(Class<?> ... values) {
            super.notBeanClasses((Class[])values);
            return this;
        }

        @Override
        public Builder notBeanPackages(String ... values) {
            super.notBeanPackages(values);
            return this;
        }

        @Override
        public Builder propertyNamer(Class<? extends PropertyNamer> value) {
            super.propertyNamer((Class)value);
            return this;
        }

        @Override
        public Builder propertyNamer(Class<?> on, Class<? extends PropertyNamer> value) {
            super.propertyNamer((Class)on, (Class)value);
            return this;
        }

        @Override
        public Builder sortProperties() {
            super.sortProperties();
            return this;
        }

        @Override
        public Builder sortProperties(Class<?> ... on) {
            super.sortProperties((Class[])on);
            return this;
        }

        @Override
        public Builder stopClass(Class<?> on, Class<?> value) {
            super.stopClass((Class)on, (Class)value);
            return this;
        }

        @Override
        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction) {
            super.swap((Class)normalClass, (Class)swappedClass, (ThrowingFunction)swapFunction);
            return this;
        }

        @Override
        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction, ThrowingFunction<S, T> unswapFunction) {
            super.swap((Class)normalClass, (Class)swappedClass, (ThrowingFunction)swapFunction, (ThrowingFunction)unswapFunction);
            return this;
        }

        @Override
        public Builder swaps(Class<?> ... values) {
            super.swaps((Class[])values);
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        @Override
        public Builder typeName(Class<?> on, String value) {
            super.typeName((Class)on, value);
            return this;
        }

        @Override
        public Builder typePropertyName(String value) {
            super.typePropertyName(value);
            return this;
        }

        @Override
        public Builder typePropertyName(Class<?> on, String value) {
            super.typePropertyName((Class)on, value);
            return this;
        }

        @Override
        public Builder useEnumNames() {
            super.useEnumNames();
            return this;
        }

        @Override
        public Builder useJavaBeanIntrospector() {
            super.useJavaBeanIntrospector();
            return this;
        }

        @Override
        public Builder detectRecursions() {
            super.detectRecursions();
            return this;
        }

        @Override
        public Builder detectRecursions(boolean value) {
            super.detectRecursions(value);
            return this;
        }

        @Override
        public Builder ignoreRecursions() {
            super.ignoreRecursions();
            return this;
        }

        @Override
        public Builder ignoreRecursions(boolean value) {
            super.ignoreRecursions(value);
            return this;
        }

        @Override
        public Builder initialDepth(int value) {
            super.initialDepth(value);
            return this;
        }

        @Override
        public Builder maxDepth(int value) {
            super.maxDepth(value);
            return this;
        }

        @Override
        public Builder accept(String value) {
            super.accept(value);
            return this;
        }

        @Override
        public Builder addBeanTypes() {
            super.addBeanTypes();
            return this;
        }

        @Override
        public Builder addBeanTypes(boolean value) {
            super.addBeanTypes(value);
            return this;
        }

        @Override
        public Builder addRootType() {
            super.addRootType();
            return this;
        }

        @Override
        public Builder addRootType(boolean value) {
            super.addRootType(value);
            return this;
        }

        @Override
        public Builder keepNullProperties() {
            super.keepNullProperties();
            return this;
        }

        @Override
        public Builder keepNullProperties(boolean value) {
            super.keepNullProperties(value);
            return this;
        }

        @Override
        public Builder listener(Class<? extends SerializerListener> value) {
            super.listener((Class)value);
            return this;
        }

        @Override
        public Builder produces(String value) {
            super.produces(value);
            return this;
        }

        @Override
        public Builder sortCollections() {
            super.sortCollections();
            return this;
        }

        @Override
        public Builder sortCollections(boolean value) {
            super.sortCollections(value);
            return this;
        }

        @Override
        public Builder sortMaps() {
            super.sortMaps();
            return this;
        }

        @Override
        public Builder sortMaps(boolean value) {
            super.sortMaps(value);
            return this;
        }

        @Override
        public Builder trimEmptyCollections() {
            super.trimEmptyCollections();
            return this;
        }

        @Override
        public Builder trimEmptyCollections(boolean value) {
            super.trimEmptyCollections(value);
            return this;
        }

        @Override
        public Builder trimEmptyMaps() {
            super.trimEmptyMaps();
            return this;
        }

        @Override
        public Builder trimEmptyMaps(boolean value) {
            super.trimEmptyMaps(value);
            return this;
        }

        @Override
        public Builder trimStrings() {
            super.trimStrings();
            return this;
        }

        @Override
        public Builder trimStrings(boolean value) {
            super.trimStrings(value);
            return this;
        }

        @Override
        public Builder uriContext(UriContext value) {
            super.uriContext(value);
            return this;
        }

        @Override
        public Builder uriRelativity(UriRelativity value) {
            super.uriRelativity(value);
            return this;
        }

        @Override
        public Builder uriResolution(UriResolution value) {
            super.uriResolution(value);
            return this;
        }

        @Override
        public Builder fileCharset(Charset value) {
            super.fileCharset(value);
            return this;
        }

        @Override
        public Builder maxIndent(int value) {
            super.maxIndent(value);
            return this;
        }

        @Override
        public Builder quoteChar(char value) {
            super.quoteChar(value);
            return this;
        }

        @Override
        public Builder quoteCharOverride(char value) {
            super.quoteCharOverride(value);
            return this;
        }

        @Override
        public Builder sq() {
            super.sq();
            return this;
        }

        @Override
        public Builder streamCharset(Charset value) {
            super.streamCharset(value);
            return this;
        }

        @Override
        public Builder useWhitespace() {
            super.useWhitespace();
            return this;
        }

        @Override
        public Builder useWhitespace(boolean value) {
            super.useWhitespace(value);
            return this;
        }

        @Override
        public Builder ws() {
            super.ws();
            return this;
        }

        @Override
        public Builder addBeanTypesJson() {
            super.addBeanTypesJson();
            return this;
        }

        @Override
        public Builder addBeanTypesJson(boolean value) {
            super.addBeanTypesJson(value);
            return this;
        }

        @Override
        public Builder escapeSolidus() {
            super.escapeSolidus();
            return this;
        }

        @Override
        public Builder escapeSolidus(boolean value) {
            super.escapeSolidus(value);
            return this;
        }

        @Override
        public Builder simpleAttrs() {
            super.simpleAttrs();
            return this;
        }

        @Override
        public Builder simpleAttrs(boolean value) {
            super.simpleAttrs(value);
            return this;
        }

        @Override
        public Builder json5() {
            super.json5();
            return this;
        }
    }

    public static class Readable
    extends JsonSchemaSerializer {
        public Readable(Builder builder) {
            super(builder.useWhitespace());
        }
    }

    public static class Simple
    extends JsonSchemaSerializer {
        public Simple(Builder builder) {
            super(builder.simpleAttrs().quoteChar('\''));
        }
    }

    public static class SimpleReadable
    extends JsonSchemaSerializer {
        public SimpleReadable(Builder builder) {
            super(builder.simpleAttrs().quoteChar('\'').useWhitespace());
        }
    }
}

